/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonTrailingCommaRemover
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range2) {
        PsiElement rootPsi = element.getPsi();
        if (rootPsi.getLanguage() != JsonLanguage.INSTANCE) {
            return range2;
        }
        JsonCodeStyleSettings settings = (JsonCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)rootPsi.getContainingFile(), JsonCodeStyleSettings.class);
        if (settings.KEEP_TRAILING_COMMA) {
            return range2;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)rootPsi.getProject());
        Document document = psiDocumentManager.getDocument(rootPsi.getContainingFile());
        if (document == null) {
            return range2;
        }
        DocumentUtil.executeInBulk(document, true, () -> {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            Visitor visitor = new Visitor(document);
            rootPsi.accept((PsiElementVisitor)visitor);
            psiDocumentManager.commitDocument(document);
        });
        return range2;
    }

    private static class Visitor
    extends JsonRecursiveElementVisitor {
        private final Document myDocument;
        private int myOffsetDelta;

        Visitor(Document document) {
            this.myDocument = document;
        }

        @Override
        public void visitArray(@NotNull JsonArray o) {
            super.visitArray(o);
            PsiElement lastChild = o.getLastChild();
            if (lastChild == null || lastChild.getNode().getElementType() != JsonElementTypes.R_BRACKET) {
                return;
            }
            this.deleteTrailingCommas((PsiElement)ObjectUtils.coalesce((Object)ContainerUtil.getLastItem(o.getValueList()), (Object)o.getFirstChild()));
        }

        @Override
        public void visitObject(@NotNull JsonObject o) {
            super.visitObject(o);
            PsiElement lastChild = o.getLastChild();
            if (lastChild == null || lastChild.getNode().getElementType() != JsonElementTypes.R_CURLY) {
                return;
            }
            this.deleteTrailingCommas((PsiElement)ObjectUtils.coalesce((Object)ContainerUtil.getLastItem(o.getPropertyList()), (Object)o.getFirstChild()));
        }

        private void deleteTrailingCommas(@Nullable PsiElement lastElementOrOpeningBrace) {
            PsiElement element;
            PsiElement psiElement = element = lastElementOrOpeningBrace != null ? lastElementOrOpeningBrace.getNextSibling() : null;
            while (element != null) {
                if (element.getNode().getElementType() == JsonElementTypes.COMMA || element instanceof PsiErrorElement && ",".equals(element.getText())) {
                    this.deleteNode(element.getNode());
                } else if (!(element instanceof PsiComment) && !(element instanceof PsiWhiteSpace)) break;
                element = element.getNextSibling();
            }
        }

        private void deleteNode(@NotNull ASTNode node) {
            int length = node.getTextLength();
            this.myDocument.deleteString(node.getStartOffset() + this.myOffsetDelta, node.getStartOffset() + length + this.myOffsetDelta);
            this.myOffsetDelta -= length;
        }
    }
}

