/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.pointer;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPointerResolver {
    private final JsonValue myRoot;
    private final String myPointer;

    public JsonPointerResolver(@NotNull JsonValue root, @NotNull String pointer) {
        this.myRoot = root;
        this.myPointer = pointer;
    }

    @Nullable
    public JsonValue resolve() {
        JsonValue root = this.myRoot;
        List<JsonPointerPosition.Step> steps = JsonPointerPosition.parsePointer(this.myPointer).getSteps();
        for (JsonPointerPosition.Step step : steps) {
            String name = step.getName();
            if (name != null) {
                if (!(root instanceof JsonObject)) {
                    return null;
                }
                JsonProperty property = ((JsonObject)root).findProperty(name);
                root = property == null ? null : property.getValue();
                continue;
            }
            int idx = step.getIdx();
            if (idx < 0) {
                return null;
            }
            if (!(root instanceof JsonArray)) {
                if (root instanceof JsonObject) {
                    JsonProperty property = ((JsonObject)root).findProperty(String.valueOf(idx));
                    if (property == null) {
                        return null;
                    }
                    root = property.getValue();
                    continue;
                }
                return null;
            }
            List<JsonValue> list2 = ((JsonArray)root).getValueList();
            if (idx >= list2.size()) {
                return null;
            }
            root = list2.get(idx);
        }
        return root;
    }
}

