/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.surroundWith;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.surroundWith.JsonSurrounderBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonWithObjectLiteralSurrounder
extends JsonSurrounderBase {
    public String getTemplateDescription() {
        return JsonBundle.message("surround.with.object.literal.desc", new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        return !JsonPsiUtil.isPropertyKey(elements[0]) && (elements[0] instanceof JsonProperty || elements.length == 1);
    }

    @Override
    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        JsonValue newNameElement;
        if (!this.isApplicable(elements)) {
            return null;
        }
        JsonElementGenerator generator = new JsonElementGenerator(project);
        PsiElement firstElement = elements[0];
        if (firstElement instanceof JsonValue) {
            assert (elements.length == 1) : "Only single JSON value can be wrapped in object literal";
            JsonObject replacement = (JsonObject)generator.createValue(this.createReplacementText(firstElement.getText()));
            replacement = (JsonObject)firstElement.replace((PsiElement)replacement);
            newNameElement = replacement.getPropertyList().get(0).getNameElement();
        } else {
            assert (firstElement instanceof JsonProperty);
            String propertiesText = JsonWithObjectLiteralSurrounder.getTextAndRemoveMisc(firstElement, elements[elements.length - 1]);
            JsonObject tempJsonObject = (JsonObject)generator.createValue(this.createReplacementText("{\n" + propertiesText) + "\n}");
            JsonProperty replacement = tempJsonObject.getPropertyList().get(0);
            replacement = (JsonProperty)firstElement.replace((PsiElement)replacement);
            newNameElement = replacement.getNameElement();
        }
        TextRange rangeWithQuotes = newNameElement.getTextRange();
        return new TextRange(rangeWithQuotes.getStartOffset() + 1, rangeWithQuotes.getEndOffset() - 1);
    }

    @Override
    @NotNull
    protected String createReplacementText(@NotNull String textInRange) {
        return "{\n\"property\": " + textInRange + "\n}";
    }
}

