/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SmartEnterProcessorWithFixers
extends SmartEnterProcessor {
    protected static final Logger LOG = Logger.getInstance(SmartEnterProcessorWithFixers.class);
    protected static final int MAX_ATTEMPTS = 20;
    protected static final Key<Long> SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    protected int myFirstErrorOffset = Integer.MAX_VALUE;
    protected int myAttempt = 0;
    private final List<Fixer<? extends SmartEnterProcessorWithFixers>> myFixers = new ArrayList<Fixer<? extends SmartEnterProcessorWithFixers>>();
    protected final List<FixEnterProcessor> myEnterProcessors = new ArrayList<FixEnterProcessor>();
    private final List<FixEnterProcessor> myAfterEnterProcessors = new ArrayList<FixEnterProcessor>();

    protected static void plainEnter(@NotNull Editor editor) {
        SmartEnterProcessorWithFixers.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor) {
        Long timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP);
        assert (timestamp != null);
        return editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    public boolean doNotStepInto(PsiElement element) {
        return false;
    }

    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.complete.statement");
        return this.invokeProcessor(project, editor, psiFile, false);
    }

    public boolean processAfterCompletion(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        return this.invokeProcessor(psiFile.getProject(), editor, psiFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeProcessor(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile, boolean afterCompletion) {
        Document document = editor.getDocument();
        CharSequence textForRollback = document.getImmutableCharSequence();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.process(project, editor, psiFile, 0, afterCompletion);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), textForRollback);
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    protected void process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, int attempt, boolean afterCompletion) throws TooManyAttemptsException {
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        this.myAttempt = attempt;
        try {
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            PsiElement atCaret = this.getStatementAtCaret(editor, file2);
            if (atCaret == null) {
                this.processDefaultEnter(project, editor, file2);
                return;
            }
            OrderedSet queue2 = new OrderedSet();
            this.collectAllElements(atCaret, (OrderedSet<PsiElement>)queue2, this.collectChildrenRecursively(atCaret));
            queue2.add((Object)atCaret);
            for (PsiElement psiElement : queue2) {
                for (Fixer<? extends SmartEnterProcessorWithFixers> fixer : this.myFixers) {
                    fixer.apply(editor, this, psiElement);
                    if (LookupManager.getInstance(project).getActiveLookup() != null) {
                        return;
                    }
                    if (!SmartEnterProcessorWithFixers.isUncommited((Project)project) && psiElement.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor, file2);
                    this.process(project, editor, file2, attempt + 1, afterCompletion);
                    return;
                }
            }
            this.doEnter(atCaret, file2, editor, afterCompletion);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected boolean collectChildrenRecursively(@NotNull PsiElement atCaret) {
        return true;
    }

    protected void processDefaultEnter(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
    }

    protected void collectAllElements(@NotNull PsiElement element, @NotNull OrderedSet<PsiElement> result2, boolean recursive) {
        result2.add(0, (Object)element);
        if (this.doNotStepInto(element)) {
            if (!recursive) {
                return;
            }
            recursive = false;
        }
        this.collectAdditionalElements(element, (List<PsiElement>)result2);
        for (PsiElement child2 : element.getChildren()) {
            this.collectAllElements(child2, result2, recursive);
        }
    }

    protected void doEnter(@NotNull PsiElement atCaret, @NotNull PsiFile psiFile, @NotNull Editor editor, boolean afterCompletion) throws IncorrectOperationException {
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat(atCaret);
            return;
        }
        RangeMarker rangeMarker = this.createRangeMarker(atCaret);
        if (this.reformatBeforeEnter(atCaret)) {
            this.reformat(atCaret);
        }
        this.commit(editor);
        PsiElement actualAtCaret = this.restoreElementAtCaret(psiFile, atCaret, rangeMarker);
        int endOffset = rangeMarker.getEndOffset();
        rangeMarker.dispose();
        if (actualAtCaret != null) {
            for (FixEnterProcessor enterProcessor : this.myEnterProcessors) {
                if (!enterProcessor.doEnter(actualAtCaret, psiFile, editor, SmartEnterProcessorWithFixers.isModified(editor))) continue;
                return;
            }
        }
        if (!SmartEnterProcessorWithFixers.isModified(editor) && !afterCompletion) {
            if (actualAtCaret != null) {
                SmartEnterProcessorWithFixers.plainEnter(editor);
            }
        } else {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset == Integer.MAX_VALUE ? (actualAtCaret != null ? actualAtCaret.getTextRange().getEndOffset() : endOffset) : this.myFirstErrorOffset);
        }
    }

    protected PsiElement restoreElementAtCaret(PsiFile file2, PsiElement origElement, RangeMarker marker) {
        if (!origElement.isValid()) {
            LOG.warn("Please, override com.intellij.lang.SmartEnterProcessorWithFixers.restoreElementAtCaret for your language!");
        }
        return origElement;
    }

    protected boolean reformatBeforeEnter(@NotNull PsiElement atCaret) {
        return true;
    }

    protected void addEnterProcessors(FixEnterProcessor ... processors) {
        ContainerUtil.addAllNotNull(this.myEnterProcessors, (Object[])processors);
    }

    protected void addAfterEnterProcessors(FixEnterProcessor ... processors) {
        ContainerUtil.addAllNotNull(this.myAfterEnterProcessors, (Object[])processors);
    }

    @SafeVarargs
    protected final void addFixers(Fixer<? extends SmartEnterProcessorWithFixers> ... fixers) {
        ContainerUtil.addAllNotNull(this.myFixers, (Object[])fixers);
    }

    protected void collectAdditionalElements(@NotNull PsiElement element, @NotNull List<PsiElement> result2) {
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file2) throws IncorrectOperationException {
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    public static abstract class FixEnterProcessor {
        public abstract boolean doEnter(PsiElement var1, PsiFile var2, @NotNull Editor var3, boolean var4);

        protected void plainEnter(@NotNull Editor editor) {
            SmartEnterProcessorWithFixers.plainEnter(editor);
        }
    }

    public static abstract class Fixer<P extends SmartEnterProcessorWithFixers> {
        public abstract void apply(@NotNull Editor var1, @NotNull P var2, @NotNull PsiElement var3) throws IncorrectOperationException;
    }

    public static class TooManyAttemptsException
    extends Exception {
    }
}

