/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFoldingRegionsPopup {
    public static void show(@NotNull Collection<? extends FoldingDescriptor> descriptors, @NotNull Editor editor, @NotNull Project project) {
        List<MyFoldingDescriptorWrapper> model = CustomFoldingRegionsPopup.orderByPosition(descriptors);
        JBPopupFactory.getInstance().createPopupChooserBuilder(model).setTitle(IdeBundle.message((String)"goto.custom.region.command", (Object[])new Object[0])).setResizable(false).setMovable(false).setItemChosenCallback(selection -> {
            PsiElement navigationElement = selection.getDescriptor().getElement().getPsi();
            if (navigationElement != null) {
                CustomFoldingRegionsPopup.navigateTo(editor, navigationElement);
                IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    private static List<MyFoldingDescriptorWrapper> orderByPosition(Collection<? extends FoldingDescriptor> descriptors) {
        ArrayList<? extends FoldingDescriptor> sorted = new ArrayList<FoldingDescriptor>(descriptors.size());
        sorted.addAll(descriptors);
        Collections.sort(sorted, (descriptor1, descriptor2) -> {
            int pos1 = descriptor1.getElement().getTextRange().getStartOffset();
            int pos2 = descriptor2.getElement().getTextRange().getStartOffset();
            return pos1 - pos2;
        });
        Stack<FoldingDescriptor> stack = new Stack<FoldingDescriptor>();
        ArrayList<MyFoldingDescriptorWrapper> result2 = new ArrayList<MyFoldingDescriptorWrapper>();
        for (FoldingDescriptor foldingDescriptor : sorted) {
            while (!stack.isEmpty() && foldingDescriptor.getRange().getStartOffset() >= ((FoldingDescriptor)stack.peek()).getRange().getEndOffset()) {
                stack.pop();
            }
            result2.add(new MyFoldingDescriptorWrapper(foldingDescriptor, stack.size()));
            stack.push(foldingDescriptor);
        }
        return result2;
    }

    private static void navigateTo(@NotNull Editor editor, @NotNull PsiElement element) {
        int offset = element.getTextRange().getStartOffset();
        if (offset >= 0 && offset < editor.getDocument().getTextLength()) {
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            editor.getSelectionModel().removeSelection();
        }
    }

    private static class MyFoldingDescriptorWrapper {
        @NotNull
        private final FoldingDescriptor myDescriptor;
        private final int myIndent;

        private MyFoldingDescriptorWrapper(@NotNull FoldingDescriptor descriptor, int indent) {
            this.myDescriptor = descriptor;
            this.myIndent = indent;
        }

        @NotNull
        public FoldingDescriptor getDescriptor() {
            return this.myDescriptor;
        }

        @Nullable
        public String toString() {
            return StringUtil.repeat((String)"   ", (int)this.myIndent) + this.myDescriptor.getPlaceholderText();
        }
    }
}

