/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.dtd;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.xml.XMLParserDefinition;
import com.intellij.lexer.DtdLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.parsing.xml.DtdParsing;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import org.jetbrains.annotations.NotNull;

public class DTDParserDefinition
extends XMLParserDefinition {
    @Override
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)new DtdLexer(false));
    }

    @Override
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new XmlFileImpl(viewProvider, (IElementType)XmlElementType.DTD_FILE);
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        return new PsiParser(){

            @NotNull
            public ASTNode parse(IElementType root, PsiBuilder builder2) {
                return new DtdParsing(root, XmlEntityDecl.EntityContextType.GENERIC_XML, builder2).parse();
            }
        };
    }

    @Override
    public IFileElementType getFileNodeType() {
        return XmlElementType.DTD_FILE;
    }

    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        return new DtdLexer(false);
    }
}

