/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public class HtmlQuotesFormatPreprocessor
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range2) {
        PsiElement psiElement = node.getPsi();
        if (psiElement != null && psiElement.isValid() && psiElement.getLanguage().is((Language)HTMLLanguage.INSTANCE)) {
            CodeStyleSettings rootSettings = CodeStyle.getSettings((PsiFile)psiElement.getContainingFile());
            HtmlCodeStyleSettings htmlSettings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
            CodeStyleSettings.QuoteStyle quoteStyle = htmlSettings.HTML_QUOTE_STYLE;
            if (quoteStyle != CodeStyleSettings.QuoteStyle.None && htmlSettings.HTML_ENFORCE_QUOTES) {
                PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper(rootSettings.getCommonSettings((Language)HTMLLanguage.INSTANCE));
                postFormatProcessorHelper.setResultTextRange(range2);
                HtmlQuotesConverter converter = new HtmlQuotesConverter(quoteStyle, psiElement, postFormatProcessorHelper);
                Document document = converter.getDocument();
                if (document != null) {
                    DocumentUtil.executeInBulk(document, true, converter);
                }
                return postFormatProcessorHelper.getResultTextRange();
            }
        }
        return range2;
    }

    public static class HtmlQuotesConverter
    extends XmlRecursiveElementVisitor
    implements Runnable {
        private final TextRange myOriginalRange;
        private final Document myDocument;
        private final PsiDocumentManager myDocumentManager;
        private final PostFormatProcessorHelper myPostProcessorHelper;
        private final PsiElement myContext;
        private final String myNewQuote;

        public HtmlQuotesConverter(@NotNull CodeStyleSettings.QuoteStyle style, @NotNull PsiElement context, @NotNull PostFormatProcessorHelper postFormatProcessorHelper) {
            this.myPostProcessorHelper = postFormatProcessorHelper;
            Project project = context.getProject();
            PsiFile file2 = context.getContainingFile();
            this.myContext = context;
            this.myOriginalRange = postFormatProcessorHelper.getResultTextRange();
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)project);
            this.myDocument = file2.getViewProvider().getDocument();
            switch (style) {
                case Single: {
                    this.myNewQuote = "'";
                    break;
                }
                case Double: {
                    this.myNewQuote = "\"";
                    break;
                }
                default: {
                    this.myNewQuote = String.valueOf(0);
                }
            }
        }

        public Document getDocument() {
            return this.myDocument;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value) {
            PsiElement child2;
            if (this.myOriginalRange.contains(value.getTextRange()) && (child2 = value.getFirstChild()) != null && !this.containsQuoteChars(value)) {
                if (child2.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    CharSequence delimiterChars;
                    PsiElement lastChild = value.getLastChild();
                    if (lastChild != null && lastChild.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (delimiterChars = child2.getNode().getChars()).length() == 1 && !StringUtil.equals((CharSequence)delimiterChars, (CharSequence)this.myNewQuote)) {
                        int startOffset = value.getTextRange().getStartOffset();
                        int endOffset = value.getTextRange().getEndOffset();
                        this.replaceString(startOffset, startOffset + 1, this.myNewQuote);
                        this.replaceString(endOffset - 1, endOffset, this.myNewQuote);
                    }
                } else if (child2.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && child2 == value.getLastChild()) {
                    this.insertString(child2.getTextRange().getStartOffset(), this.myNewQuote);
                    this.insertString(child2.getTextRange().getEndOffset(), this.myNewQuote);
                }
            }
        }

        private void replaceString(int start2, int end, String newValue) {
            int mappedStart = this.myPostProcessorHelper.mapOffset(start2);
            int mappedEnd = this.myPostProcessorHelper.mapOffset(end);
            this.myDocument.replaceString(mappedStart, mappedEnd, (CharSequence)newValue);
            this.myPostProcessorHelper.updateResultRange(end - start2, newValue.length());
        }

        private void insertString(int offset, String value) {
            int mappedOffset = this.myPostProcessorHelper.mapOffset(offset);
            this.myDocument.insertString(mappedOffset, (CharSequence)value);
            this.myPostProcessorHelper.updateResultRange(0, value.length());
        }

        private boolean containsQuoteChars(@NotNull XmlAttributeValue value) {
            for (PsiElement child2 = value.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                if (HtmlQuotesConverter.isDelimiter(child2.getNode().getElementType()) || !StringUtil.contains((CharSequence)child2.getNode().getChars(), (CharSequence)this.myNewQuote)) continue;
                return true;
            }
            return false;
        }

        private static boolean isDelimiter(@NotNull IElementType elementType) {
            return elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
        }

        @Override
        public void run() {
            if (this.myDocument != null) {
                this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
                this.myContext.accept((PsiElementVisitor)this);
                this.myDocumentManager.commitDocument(this.myDocument);
            }
        }

        public static void runOnElement(@NotNull CodeStyleSettings.QuoteStyle quoteStyle, @NotNull PsiElement element) {
            PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper(CodeStyle.getDefaultSettings());
            postFormatProcessorHelper.setResultTextRange(element.getTextRange());
            new HtmlQuotesConverter(quoteStyle, element, postFormatProcessorHelper).run();
        }
    }
}

