/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HtmlTagTreeElement
extends PsiTreeElementBase<XmlTag>
implements LocationPresentation {
    static final int MAX_TEXT_LENGTH = 50;

    HtmlTagTreeElement(XmlTag tag) {
        super(tag);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        XmlTag tag = (XmlTag)this.getElement();
        if (tag == null || !tag.isValid()) {
            return Collections.emptyList();
        }
        return ContainerUtil.map2List((Object[])tag.getSubTags(), HtmlTagTreeElement::new);
    }

    public String getPresentableText() {
        XmlTag tag = (XmlTag)this.getElement();
        if (tag == null) {
            return IdeBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]);
        }
        return HtmlUtil.getTagPresentation(tag);
    }

    @Override
    @Nullable
    public String getLocationString() {
        XmlTag tag = (XmlTag)this.getElement();
        if (tag == null) {
            return null;
        }
        if (tag.getName().equalsIgnoreCase("img") || HtmlUtil.isScriptTag(tag)) {
            return HtmlTagTreeElement.getPathDescription(tag.getAttributeValue("src"));
        }
        if (tag.getName().equalsIgnoreCase("link")) {
            return HtmlTagTreeElement.getPathDescription(tag.getAttributeValue("href"));
        }
        return StringUtil.nullize((String)HtmlTagTreeElement.normalizeSpacesAndShortenIfLong(tag.getValue().getTrimmedText()));
    }

    private static String getPathDescription(String src) {
        if (StringUtil.isEmpty((String)src)) {
            return null;
        }
        return StringUtil.shortenPathWithEllipsis((String)src, (int)50, (boolean)true);
    }

    @Override
    public boolean isSearchInLocationString() {
        return true;
    }

    @Nullable
    public static String normalizeSpacesAndShortenIfLong(@NotNull String text) {
        StringBuilder builder2 = HtmlTagTreeElement.normalizeSpaces(text);
        return builder2 == null ? null : HtmlTagTreeElement.shortenTextIfLong(builder2);
    }

    @Nullable
    private static StringBuilder normalizeSpaces(@NotNull String text) {
        if (text.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c <= ' ' || Character.isSpaceChar(c)) {
                if (buf.length() != 0 && buf.charAt(buf.length() - 1) == ' ') continue;
                buf.append(' ');
                continue;
            }
            buf.append(c);
        }
        return buf;
    }

    @Nullable
    private static String shortenTextIfLong(@NotNull StringBuilder text) {
        int index;
        if (text.length() <= 50) {
            return text.toString();
        }
        for (index = 50; index > 30 && Character.isLetter(text.charAt(index)); --index) {
        }
        text.setLength(Character.isLetter(index) ? 50 : index);
        return text.append("\u2026").toString();
    }

    public String getLocationPrefix() {
        return "  ";
    }

    public String getLocationSuffix() {
        return "";
    }
}

