/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.TokenWrapper;
import com.intellij.lang.WhitespaceSkippedCallback;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.impl.MarkerOptionalData;
import com.intellij.lang.impl.MarkerPool;
import com.intellij.lang.impl.MarkerProduction;
import com.intellij.lang.impl.TokenSequence;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UnprotectedUserDataHolder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.CustomLanguageASTComparator;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.psi.tree.ILightLazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderImpl
extends UnprotectedUserDataHolder
implements PsiBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.impl.PsiBuilderImpl");
    public static final Key<TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState>> CUSTOM_COMPARATOR = Key.create((String)"CUSTOM_COMPARATOR");
    private static final Key<TokenSequence> LAZY_PARSEABLE_TOKENS = Key.create((String)"LAZY_PARSEABLE_TOKENS");
    private static TokenSet ourAnyLanguageWhitespaceTokens = TokenSet.EMPTY;
    private final Project myProject;
    private PsiFile myFile;
    private final int[] myLexStarts;
    private final IElementType[] myLexTypes;
    private int myCurrentLexeme;
    private final ParserDefinition myParserDefinition;
    private final Lexer myLexer;
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    private CharTable myCharTable;
    private final CharSequence myText;
    private final CharSequence myLastCommittedText;
    private final char[] myTextArray;
    private boolean myDebugMode;
    private final int myLexemeCount;
    private boolean myTokenTypeChecked;
    private ITokenTypeRemapper myRemapper;
    private WhitespaceSkippedCallback myWhitespaceSkippedCallback;
    private final ASTNode myOriginalTree;
    private final MyTreeStructure myParentLightTree;
    private final int myOffset;
    private IElementType myCachedTokenType;
    private final TIntObjectHashMap<LazyParseableToken> myChameleonCache = new TIntObjectHashMap();
    private final MarkerPool myPool = new MarkerPool(this);
    private final MarkerOptionalData myOptionalData = new MarkerOptionalData();
    private final MarkerProduction myProduction = new MarkerProduction(this.myPool, this.myOptionalData);
    @NonNls
    private static final String UNBALANCED_MESSAGE = "Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem";

    public static void registerWhitespaceToken(@NotNull IElementType type) {
        ourAnyLanguageWhitespaceTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{ourAnyLanguageWhitespaceTokens, TokenSet.create((IElementType[])new IElementType[]{type})});
    }

    public PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable MyTreeStructure parentLightTree) {
        this(project, containingFile, parserDefinition, lexer, charTable, text, originalTree, originalTree == null ? null : originalTree.getText(), parentLightTree, null);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull ASTNode chameleon, @NotNull CharSequence text) {
        this(project, SharedImplUtil.getContainingFile(chameleon), parserDefinition, lexer, SharedImplUtil.findCharTableByTree(chameleon), text, (ASTNode)Pair.getFirst((Pair)((Pair)chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED))), (CharSequence)Pair.getSecond((Pair)((Pair)chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED))), null, chameleon);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull LighterLazyParseableNode chameleon, @NotNull CharSequence text) {
        this(project, chameleon.getContainingFile(), parserDefinition, lexer, chameleon.getCharTable(), text, null, null, ((LazyParseableToken)chameleon).myParentStructure, chameleon);
    }

    private PsiBuilderImpl(@Nullable Project project, @Nullable PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @Nullable CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable CharSequence lastCommittedText, @Nullable MyTreeStructure parentLightTree, @Nullable Object parentCachingNode) {
        this.myProject = project;
        this.myFile = containingFile;
        this.myParserDefinition = parserDefinition;
        this.myText = text;
        this.myTextArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text);
        this.myLexer = lexer;
        this.myWhitespaces = parserDefinition.getWhitespaceTokens();
        this.myComments = parserDefinition.getCommentTokens();
        this.myCharTable = charTable;
        this.myOriginalTree = originalTree;
        this.myLastCommittedText = lastCommittedText;
        if (originalTree == null != (lastCommittedText == null)) {
            throw new IllegalArgumentException("originalTree and lastCommittedText must be null/notnull together but got: originalTree=" + originalTree + "; lastCommittedText=" + (lastCommittedText == null ? null : "'" + StringUtil.first((CharSequence)lastCommittedText, (int)80, (boolean)true) + "'"));
        }
        this.myParentLightTree = parentLightTree;
        this.myOffset = parentCachingNode instanceof LazyParseableToken ? ((LazyParseableToken)parentCachingNode).getStartOffset() : 0;
        TokenSequence tokens = this.performLexing(parentCachingNode);
        this.myLexStarts = tokens.lexStarts;
        this.myLexTypes = tokens.lexTypes;
        this.myLexemeCount = tokens.lexemeCount;
    }

    private TokenSequence performLexing(@Nullable Object parentCachingNode) {
        TokenSequence fromParent = null;
        if (parentCachingNode instanceof LazyParseableToken) {
            fromParent = ((LazyParseableToken)parentCachingNode).getParsedTokenSequence();
            assert (fromParent == null || fromParent.lexStarts[fromParent.lexemeCount] == this.myText.length());
            ProgressIndicatorProvider.checkCanceled();
        } else if (parentCachingNode instanceof LazyParseableElement) {
            LazyParseableElement parentElement = (LazyParseableElement)parentCachingNode;
            fromParent = (TokenSequence)parentElement.getUserData(LAZY_PARSEABLE_TOKENS);
            parentElement.putUserData(LAZY_PARSEABLE_TOKENS, null);
        }
        if (fromParent != null) {
            if (PsiBuilderImpl.doLexingOptimizationCorrectionCheck()) {
                fromParent.assertMatches(this.myText, this.myLexer);
            }
            return fromParent;
        }
        return new TokenSequence.Builder(this.myText, this.myLexer).performLexing();
    }

    private static boolean doLexingOptimizationCorrectionCheck() {
        return false;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void enforceCommentTokens(@NotNull TokenSet tokens) {
        this.myComments = tokens;
    }

    @Nullable
    public StartMarker getLatestDoneMarker() {
        for (int index = this.myProduction.size() - 1; index >= 0; --index) {
            StartMarker marker = this.myProduction.getDoneMarkerAt(index);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    @Nullable
    public List<ProductionMarker> getProductions() {
        return new AbstractList<ProductionMarker>(){

            @Override
            public ProductionMarker get(int index) {
                return PsiBuilderImpl.this.myProduction.getMarkerAt(index);
            }

            @Override
            public int size() {
                return PsiBuilderImpl.this.myProduction.size();
            }
        };
    }

    @NotNull
    private PsiBuilder.Marker precede(StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "Preceding disposed marker";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        StartMarker pre = this.createMarker(marker.myLexemeIndex);
        this.myProduction.addBefore(pre, marker);
        return pre;
    }

    @NotNull
    public CharSequence getOriginalText() {
        return this.myText;
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType cached = this.myCachedTokenType;
        if (cached == null) {
            this.myCachedTokenType = cached = this.calcTokenType();
        }
        return cached;
    }

    private void clearCachedTokenType() {
        this.myCachedTokenType = null;
    }

    private IElementType remapCurrentToken() {
        if (this.myCachedTokenType != null) {
            return this.myCachedTokenType;
        }
        if (this.myRemapper != null) {
            this.remapCurrentToken(this.myRemapper.filter(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1], this.myText));
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    private IElementType calcTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            this.skipWhitespace();
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    public void setTokenTypeRemapper(ITokenTypeRemapper remapper) {
        this.myRemapper = remapper;
        this.myTokenTypeChecked = false;
        this.clearCachedTokenType();
    }

    public void remapCurrentToken(IElementType type) {
        this.myLexTypes[this.myCurrentLexeme] = type;
        this.clearCachedTokenType();
    }

    @Nullable
    public IElementType lookAhead(int steps) {
        if (this.eof()) {
            return null;
        }
        int cur = this.myCurrentLexeme;
        while (steps > 0) {
            ++cur;
            while (cur < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[cur])) {
                ++cur;
            }
            --steps;
        }
        return cur < this.myLexemeCount ? this.myLexTypes[cur] : null;
    }

    public IElementType rawLookup(int steps) {
        int cur = this.myCurrentLexeme + steps;
        return cur < this.myLexemeCount && cur >= 0 ? this.myLexTypes[cur] : null;
    }

    public int rawTokenTypeStart(int steps) {
        int cur = this.myCurrentLexeme + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myLexemeCount) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[cur];
    }

    public int rawTokenIndex() {
        return this.myCurrentLexeme;
    }

    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback callback2) {
        this.myWhitespaceSkippedCallback = callback2;
    }

    public void advanceLexer() {
        ProgressIndicatorProvider.checkCanceled();
        if (this.eof()) {
            return;
        }
        if (!this.myTokenTypeChecked) {
            LOG.error("Probably a bug: eating token without its type checking");
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexeme;
        this.clearCachedTokenType();
    }

    private void skipWhitespace() {
        while (this.myCurrentLexeme < this.myLexemeCount && this.whitespaceOrComment(this.remapCurrentToken())) {
            this.onSkip(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myCurrentLexeme + 1 < this.myLexemeCount ? this.myLexStarts[this.myCurrentLexeme + 1] : this.myText.length());
            ++this.myCurrentLexeme;
            this.clearCachedTokenType();
        }
    }

    private void onSkip(IElementType type, int start2, int end) {
        if (this.myWhitespaceSkippedCallback != null) {
            this.myWhitespaceSkippedCallback.onSkip(type, start2, end);
        }
    }

    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[this.myCurrentLexeme];
    }

    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type = this.getTokenType();
        if (type instanceof TokenWrapper) {
            return ((TokenWrapper)type).getValue();
        }
        return this.myText.subSequence(this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1]).toString();
    }

    public boolean whitespaceOrComment(IElementType token) {
        return this.myWhitespaces.contains(token) || this.myComments.contains(token);
    }

    @NotNull
    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexeme);
        this.myProduction.addMarker(marker);
        return marker;
    }

    @NotNull
    private StartMarker createMarker(int lexemeIndex) {
        StartMarker marker = this.myPool.allocateStartMarker();
        marker.myLexemeIndex = lexemeIndex;
        if (this.myDebugMode) {
            this.myOptionalData.notifyAllocated(marker.markerId);
        }
        return marker;
    }

    public final boolean eof() {
        if (!this.myTokenTypeChecked) {
            this.myTokenTypeChecked = true;
            this.skipWhitespace();
        }
        return this.myCurrentLexeme >= this.myLexemeCount;
    }

    private void rollbackTo(@NotNull StartMarker marker) {
        assert (marker.myLexemeIndex >= 0) : "Disposed marker passed to rollbackTo";
        if (this.myDebugMode) {
            this.myProduction.assertNoDoneMarkerAround(marker);
        }
        this.myCurrentLexeme = marker.myLexemeIndex;
        this.myTokenTypeChecked = true;
        this.myProduction.rollbackTo(marker);
        this.clearCachedTokenType();
    }

    public boolean hasErrorsAfter(@NotNull PsiBuilder.Marker marker) {
        return this.myProduction.hasErrorsAfter((StartMarker)marker);
    }

    private void processDone(@NotNull StartMarker marker, @Nullable String errorMessage, @Nullable StartMarker before) {
        int doneLexeme;
        this.doValidityChecks(marker, before);
        if (errorMessage != null) {
            this.myOptionalData.setErrorMessage(marker.markerId, errorMessage);
        }
        int n = doneLexeme = before == null ? this.myCurrentLexeme : before.myLexemeIndex;
        if (marker.myType.isLeftBound() && this.isEmpty(marker.myLexemeIndex, doneLexeme)) {
            marker.setCustomEdgeTokenBinders(WhitespacesBinders.DEFAULT_RIGHT_BINDER, null);
        }
        marker.myDoneLexeme = doneLexeme;
        this.myProduction.addDone(marker, before);
    }

    private boolean isEmpty(int startIdx, int endIdx) {
        for (int i = startIdx; i < endIdx; ++i) {
            IElementType token = this.myLexTypes[i];
            if (this.whitespaceOrComment(token)) continue;
            return false;
        }
        return true;
    }

    private void doValidityChecks(@NotNull StartMarker marker, @Nullable StartMarker before) {
        if (marker.isDone()) {
            LOG.error("Marker already done.");
        }
        if (this.myDebugMode) {
            this.myProduction.doHeavyChecksOnMarkerDone(marker, before);
        }
    }

    public void error(@NotNull String messageText) {
        ProductionMarker lastMarker = this.myProduction.getStartMarkerAt(this.myProduction.size() - 1);
        if (lastMarker instanceof ErrorItem && lastMarker.myLexemeIndex == this.myCurrentLexeme) {
            return;
        }
        ErrorItem marker = this.myPool.allocateErrorItem();
        marker.myMessage = messageText;
        marker.myLexemeIndex = this.myCurrentLexeme;
        this.myProduction.addMarker(marker);
    }

    @NotNull
    public ASTNode getTreeBuilt() {
        return this.buildTree();
    }

    @NotNull
    private ASTNode buildTree() {
        TreeElement childNode;
        boolean possiblyTooDeep;
        StartMarker rootMarker = this.prepareLightTree();
        boolean bl = possiblyTooDeep = this.myFile != null && BlockSupport.isTooDeep((UserDataHolder)this.myFile.getOriginalFile());
        if (this.myOriginalTree != null && !possiblyTooDeep) {
            DiffLog diffLog = this.merge(this.myOriginalTree, rootMarker, this.myLastCommittedText);
            throw new BlockSupport.ReparsedSuccessfullyException(diffLog);
        }
        TreeElement rootNode = this.createRootAST(rootMarker);
        this.bind(rootMarker, (CompositeElement)rootNode);
        if (possiblyTooDeep && !(rootNode instanceof FileElement) && (childNode = rootNode.getFirstChildNode()) != null) {
            childNode.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        assert (rootNode.getTextLength() == this.myText.length()) : rootNode.getElementType();
        return rootNode;
    }

    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> getLightTree() {
        StartMarker rootMarker = this.prepareLightTree();
        return new MyTreeStructure(rootMarker, this.myParentLightTree);
    }

    @NotNull
    private TreeElement createRootAST(@NotNull StartMarker rootMarker) {
        CompositeElement rootNode;
        IElementType type = rootMarker.getTokenType();
        CompositeElement compositeElement = rootNode = type instanceof ILazyParseableElementType ? PsiBuilderImpl.createLazy((ILazyParseableElementType)type, null, this.getASTFactory()) : PsiBuilderImpl.createComposite(rootMarker, this.getASTFactory());
        if (this.myCharTable == null) {
            CharTableImpl charTableImpl = this.myCharTable = rootNode instanceof FileElement ? ((FileElement)rootNode).getCharTable() : new CharTableImpl();
        }
        if (!(rootNode instanceof FileElement)) {
            rootNode.putUserData(CharTable.CHAR_TABLE_KEY, this.myCharTable);
        }
        return rootNode;
    }

    @Nullable
    private ASTFactory getASTFactory() {
        return this.myParserDefinition instanceof ASTFactory ? (ASTFactory)this.myParserDefinition : null;
    }

    @NotNull
    private DiffLog merge(@NotNull ASTNode oldRoot, @NotNull StartMarker newRoot, @NotNull CharSequence lastCommittedText) {
        DiffLog diffLog = new DiffLog();
        ConvertFromTokensToASTBuilder builder2 = new ConvertFromTokensToASTBuilder(newRoot, diffLog, this.getASTFactory());
        MyTreeStructure treeStructure = new MyTreeStructure(newRoot, null);
        List customLanguageASTComparators = CustomLanguageASTComparator.getMatchingComparators((PsiFile)this.myFile);
        MyComparator comparator2 = new MyComparator(this.getUserData(CUSTOM_COMPARATOR), customLanguageASTComparators, treeStructure);
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        BlockSupportImpl.diffTrees(oldRoot, builder2, comparator2, treeStructure, (ProgressIndicator)(indicator == null ? new EmptyProgressIndicator() : indicator), lastCommittedText);
        return diffLog;
    }

    @NotNull
    private StartMarker prepareLightTree() {
        StartMarker rootMarker;
        if (this.myProduction.isEmpty()) {
            LOG.error("Parser produced no markers. Text:\n" + this.myText);
        }
        if ((rootMarker = (StartMarker)Objects.requireNonNull(this.myProduction.getStartMarkerAt(0))).myFirstChild != null) {
            return rootMarker;
        }
        this.myOptionalData.compact();
        this.myTokenTypeChecked = true;
        this.balanceWhiteSpaces();
        rootMarker.myNext = null;
        rootMarker.myParent = rootMarker.myFirstChild = (rootMarker.myLastChild = null);
        StartMarker curNode = rootMarker;
        Stack nodes = ContainerUtil.newStack();
        nodes.push((Object)rootMarker);
        int lastErrorIndex = -1;
        int maxDepth = 0;
        int curDepth = 0;
        boolean hasCollapsedChameleons = false;
        for (int i = 1; i < this.myProduction.size(); ++i) {
            ProductionMarker item = this.myProduction.getStartMarkerAt(i);
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                marker.myParent = curNode;
                marker.myNext = null;
                marker.myFirstChild = (marker.myLastChild = null);
                curNode.addChild(marker);
                nodes.push((Object)curNode);
                curNode = marker;
                if (++curDepth <= maxDepth) continue;
                maxDepth = curDepth;
                continue;
            }
            if (item instanceof ErrorItem) {
                ((ErrorItem)item).myParent = curNode;
                int curToken = item.myLexemeIndex;
                if (curToken == lastErrorIndex) continue;
                lastErrorIndex = curToken;
                curNode.addChild(item);
                continue;
            }
            if (PsiBuilderImpl.isCollapsedChameleon(curNode)) {
                hasCollapsedChameleons = true;
            }
            this.assertMarkersBalanced(this.myProduction.getDoneMarkerAt(i) == curNode, item);
            curNode = (StartMarker)nodes.pop();
            --curDepth;
        }
        if (this.myCurrentLexeme < this.myLexemeCount) {
            List missed = ContainerUtil.newArrayList((Object[])this.myLexTypes, (int)this.myCurrentLexeme, (int)this.myLexemeCount);
            LOG.error("Tokens " + missed + " were not inserted into the tree. " + (this.myFile != null ? this.myFile.getLanguage() + ", " : "") + "Text:\n" + this.myText);
        }
        if (rootMarker.getEndIndex() < this.myLexemeCount) {
            List missed = ContainerUtil.newArrayList((Object[])this.myLexTypes, (int)rootMarker.getEndIndex(), (int)this.myLexemeCount);
            LOG.error("Tokens " + missed + " are outside of root element \"" + rootMarker.myType + "\". Text:\n" + this.myText);
        }
        this.assertMarkersBalanced(curNode == rootMarker, curNode);
        this.checkTreeDepth(maxDepth, rootMarker.getTokenType() instanceof IFileElementType, hasCollapsedChameleons);
        this.clearCachedTokenType();
        return rootMarker;
    }

    private static boolean isCollapsedChameleon(StartMarker marker) {
        return marker.getTokenType() instanceof ILazyParseableElementTypeBase && marker.myFirstChild == null && marker.getTextLength() > 0;
    }

    private void assertMarkersBalanced(boolean condition, @Nullable ProductionMarker marker) {
        if (condition) {
            return;
        }
        this.reportUnbalancedMarkers(marker);
    }

    private void reportUnbalancedMarkers(@Nullable ProductionMarker marker) {
        int index = marker != null ? marker.getStartIndex() + 1 : this.myLexStarts.length;
        String context = index < this.myLexStarts.length ? this.myText.subSequence(Math.max(0, this.myLexStarts[index] - 1000), this.myLexStarts[index]) : "<none>";
        String language = this.myFile != null ? this.myFile.getLanguage() + ", " : "";
        LOG.error("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem\nlanguage: " + language + "\ncontext: '" + context + "'");
    }

    private void balanceWhiteSpaces() {
        RelativeTokenTypesView wsTokens = new RelativeTokenTypesView();
        RelativeTokenTextView tokenTextGetter = new RelativeTokenTextView();
        int lastIndex = 0;
        int size = this.myProduction.size() - 1;
        for (int i = 1; i < size; ++i) {
            int wsEndIndex;
            int wsStartIndex;
            ProductionMarker starting = this.myProduction.getStartMarkerAt(i);
            if (starting instanceof StartMarker) {
                this.assertMarkersBalanced(((StartMarker)starting).isDone(), starting);
            }
            boolean done = starting == null;
            ProductionMarker item = starting != null ? starting : (ProductionMarker)Objects.requireNonNull(this.myProduction.getDoneMarkerAt(i));
            WhitespacesAndCommentsBinder binder = item.getBinder(done);
            int lexemeIndex = item.getLexemeIndex(done);
            boolean recursive = binder instanceof WhitespacesAndCommentsBinder.RecursiveBinder;
            int prevProductionLexIndex = recursive ? 0 : this.myProduction.getLexemeIndexAt(i - 1);
            for (wsStartIndex = Math.max(lexemeIndex, lastIndex); wsStartIndex > prevProductionLexIndex && this.whitespaceOrComment(this.myLexTypes[wsStartIndex - 1]); --wsStartIndex) {
            }
            for (wsEndIndex = lexemeIndex; wsEndIndex < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[wsEndIndex]); ++wsEndIndex) {
            }
            if (wsStartIndex != wsEndIndex) {
                wsTokens.configure(wsStartIndex, wsEndIndex);
                tokenTextGetter.configure(wsStartIndex);
                boolean atEnd = wsStartIndex == 0 || wsEndIndex == this.myLexemeCount;
                lexemeIndex = wsStartIndex + binder.getEdgePosition((List)wsTokens, atEnd, (WhitespacesAndCommentsBinder.TokenTextGetter)tokenTextGetter);
                item.setLexemeIndex(lexemeIndex, done);
                if (recursive) {
                    this.myProduction.confineMarkersToMaxLexeme(i, lexemeIndex);
                }
            } else if (lexemeIndex < wsStartIndex) {
                lexemeIndex = wsStartIndex;
                item.setLexemeIndex(wsStartIndex, done);
            }
            lastIndex = lexemeIndex;
        }
    }

    private void checkTreeDepth(int maxDepth, boolean isFileRoot, boolean hasCollapsedChameleons) {
        if (this.myFile == null) {
            return;
        }
        PsiFile file2 = this.myFile.getOriginalFile();
        Boolean flag = (Boolean)file2.getUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED);
        if (maxDepth > BlockSupport.INCREMENTAL_REPARSE_DEPTH_LIMIT) {
            if (!Boolean.TRUE.equals(flag)) {
                file2.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, (Object)Boolean.TRUE);
            }
        } else if (isFileRoot && flag != null && !hasCollapsedChameleons) {
            file2.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, null);
        }
    }

    private void bind(@NotNull StartMarker rootMarker, @NotNull CompositeElement rootNode) {
        ASTFactory astFactory = this.getASTFactory();
        StartMarker curMarker = rootMarker;
        CompositeElement curNode = rootNode;
        int lexIndex = rootMarker.myLexemeIndex;
        ProductionMarker item = rootMarker.myFirstChild != null ? rootMarker.myFirstChild : rootMarker;
        boolean itemDone = rootMarker.myFirstChild == null;
        while (true) {
            lexIndex = this.insertLeaves(lexIndex, item.getLexemeIndex(itemDone), curNode);
            if (item == rootMarker && itemDone) break;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                if (itemDone) {
                    curMarker = (StartMarker)marker.myParent;
                    curNode = curNode.getTreeParent();
                    item = marker.myNext;
                    itemDone = false;
                } else {
                    if (!this.myOptionalData.isCollapsed(marker.markerId)) {
                        curMarker = marker;
                        CompositeElement childNode = PsiBuilderImpl.createComposite(marker, astFactory);
                        curNode.rawAddChildrenWithoutNotifications(childNode);
                        curNode = childNode;
                        item = marker.myFirstChild != null ? marker.myFirstChild : marker;
                        itemDone = marker.myFirstChild == null;
                        continue;
                    }
                    lexIndex = this.collapseLeaves(curNode, marker);
                    item = marker.myNext;
                    itemDone = false;
                }
            } else if (item instanceof ErrorItem) {
                CompositeElement errorElement = Factory.createErrorElement(((ErrorItem)item).myMessage);
                curNode.rawAddChildrenWithoutNotifications(errorElement);
                item = ((ErrorItem)item).myNext;
                itemDone = false;
            }
            if (item != null) continue;
            item = curMarker;
            itemDone = true;
        }
    }

    private int insertLeaves(int curToken, int lastIdx, CompositeElement curNode) {
        lastIdx = Math.min(lastIdx, this.myLexemeCount);
        while (curToken < lastIdx) {
            ProgressIndicatorProvider.checkCanceled();
            int start2 = this.myLexStarts[curToken];
            int end = this.myLexStarts[curToken + 1];
            if (start2 < end || this.myLexTypes[curToken] instanceof ILeafElementType) {
                IElementType type = this.myLexTypes[curToken];
                TreeElement leaf = this.createLeaf(type, start2, end);
                curNode.rawAddChildrenWithoutNotifications(leaf);
            }
            ++curToken;
        }
        return curToken;
    }

    private int collapseLeaves(@NotNull CompositeElement ast, @NotNull StartMarker startMarker) {
        int start2 = this.myLexStarts[startMarker.myLexemeIndex];
        int end = this.myLexStarts[startMarker.getEndIndex()];
        IElementType markerType = startMarker.myType;
        TreeElement leaf = this.createLeaf(markerType, start2, end);
        if (markerType instanceof ILazyParseableElementType && ((ILazyParseableElementType)markerType).reuseCollapsedTokens() && startMarker.myLexemeIndex < startMarker.getEndIndex()) {
            int length = startMarker.getEndIndex() - startMarker.myLexemeIndex;
            int[] relativeStarts = new int[length + 1];
            IElementType[] types = new IElementType[length + 1];
            for (int i = startMarker.myLexemeIndex; i < startMarker.getEndIndex(); ++i) {
                relativeStarts[i - startMarker.myLexemeIndex] = this.myLexStarts[i] - start2;
                types[i - startMarker.myLexemeIndex] = this.myLexTypes[i];
            }
            relativeStarts[length] = end - start2;
            leaf.putUserData(LAZY_PARSEABLE_TOKENS, new TokenSequence(relativeStarts, types, length));
        }
        ast.rawAddChildrenWithoutNotifications(leaf);
        return startMarker.getEndIndex();
    }

    @NotNull
    private static CompositeElement createComposite(@NotNull StartMarker marker, @Nullable ASTFactory astFactory) {
        CompositeElement composite;
        IElementType type = marker.myType;
        if (type == TokenType.ERROR_ELEMENT) {
            String error = marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
            return Factory.createErrorElement(error);
        }
        if (type == null) {
            throw new RuntimeException(UNBALANCED_MESSAGE);
        }
        if (astFactory != null && (composite = astFactory.createComposite(marker.getTokenType())) != null) {
            return composite;
        }
        return ASTFactory.composite(type);
    }

    @NotNull
    private static LazyParseableElement createLazy(@NotNull ILazyParseableElementType type, @Nullable CharSequence text, @Nullable ASTFactory astFactory) {
        LazyParseableElement element;
        if (astFactory != null && (element = astFactory.createLazy(type, text)) != null) {
            return element;
        }
        return ASTFactory.lazy(type, text);
    }

    @Nullable
    public static String getErrorMessage(@NotNull LighterASTNode node) {
        StartMarker marker;
        if (node instanceof ErrorItem) {
            return ((ErrorItem)node).myMessage;
        }
        if (node instanceof StartMarker && (marker = (StartMarker)node).myType == TokenType.ERROR_ELEMENT) {
            return marker.myBuilder.myOptionalData.getDoneError(marker.markerId);
        }
        return null;
    }

    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    public int getLexemeCount() {
        return this.myLexemeCount;
    }

    @NotNull
    public Lexer getLexer() {
        return this.myLexer;
    }

    @NotNull
    protected TreeElement createLeaf(@NotNull IElementType type, int start2, int end) {
        LeafElement element;
        CharSequence text = this.myCharTable.intern(this.myText, start2, end);
        if (this.myWhitespaces.contains(type)) {
            return new PsiWhiteSpaceImpl(text);
        }
        if (type instanceof ICustomParsingType) {
            return (TreeElement)((ICustomParsingType)type).parse(text, this.myCharTable);
        }
        ASTFactory astFactory = this.getASTFactory();
        if (type instanceof ILazyParseableElementType) {
            return PsiBuilderImpl.createLazy((ILazyParseableElementType)type, text, astFactory);
        }
        if (astFactory != null && (element = astFactory.createLeaf(type, text)) != null) {
            return element;
        }
        return ASTFactory.leaf(type, text);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            return (T)this.myFile;
        }
        return (T)super.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            this.myFile = (PsiFile)value;
            return;
        }
        super.putUserData(key, value);
    }

    private static class ASTConverter
    implements Convertor<Node, ASTNode> {
        private final StartMarker myRoot;
        private final ASTFactory myASTFactory;

        private ASTConverter(@NotNull StartMarker root, @Nullable ASTFactory astFactory) {
            this.myRoot = root;
            this.myASTFactory = astFactory;
        }

        public ASTNode convert(Node n) {
            if (n instanceof Token) {
                Token token = (Token)n;
                return token.myBuilder.createLeaf(token.getTokenType(), token.myTokenStart, token.myTokenEnd);
            }
            if (n instanceof ErrorItem) {
                return Factory.createErrorElement(((ErrorItem)n).myMessage);
            }
            StartMarker startMarker = (StartMarker)n;
            CompositeElement composite = n == this.myRoot ? (CompositeElement)this.myRoot.myBuilder.createRootAST(this.myRoot) : PsiBuilderImpl.createComposite(startMarker, this.myASTFactory);
            startMarker.myBuilder.bind(startMarker, composite);
            return composite;
        }
    }

    private static class MyTreeStructure
    implements FlyweightCapableTreeStructure<LighterASTNode> {
        private final LimitedPool<Token> myPool;
        private final LimitedPool<LazyParseableToken> myLazyPool;
        private final StartMarker myRoot;
        private int count;
        private LighterASTNode[] nodes;

        MyTreeStructure(@NotNull StartMarker root, @Nullable MyTreeStructure parentTree) {
            if (parentTree == null) {
                this.myPool = new LimitedPool(1000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<Token>(){

                    public void cleanup(@NotNull Token token) {
                        token.clean();
                    }

                    @NotNull
                    public Token create() {
                        return new TokenNode();
                    }
                });
                this.myLazyPool = new LimitedPool(200, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<LazyParseableToken>(){

                    public void cleanup(@NotNull LazyParseableToken token) {
                        token.clean();
                    }

                    @NotNull
                    public LazyParseableToken create() {
                        return new LazyParseableToken();
                    }
                });
            } else {
                this.myPool = parentTree.myPool;
                this.myLazyPool = parentTree.myLazyPool;
            }
            this.myRoot = root;
        }

        @NotNull
        public LighterASTNode getRoot() {
            return this.myRoot;
        }

        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node instanceof ProductionMarker) {
                return ((ProductionMarker)node).myParent;
            }
            if (node instanceof Token) {
                return ((Token)node).myParentNode;
            }
            throw new UnsupportedOperationException("Unknown node type: " + node);
        }

        public int getChildren(@NotNull LighterASTNode item, @NotNull Ref<LighterASTNode[]> into) {
            if (item instanceof LazyParseableToken) {
                FlyweightCapableTreeStructure<LighterASTNode> tree = ((LazyParseableToken)item).parseContents();
                LighterASTNode root = (LighterASTNode)tree.getRoot();
                if (root instanceof ProductionMarker) {
                    ((ProductionMarker)root).myParent = ((Token)item).myParentNode;
                }
                return tree.getChildren((Object)root, into);
            }
            if (item instanceof Token || item instanceof ErrorItem) {
                return 0;
            }
            StartMarker marker = (StartMarker)item;
            this.count = 0;
            ProductionMarker child2 = marker.myFirstChild;
            int lexIndex = marker.myLexemeIndex;
            while (child2 != null) {
                lexIndex = this.insertLeaves(lexIndex, child2.myLexemeIndex, marker.myBuilder, marker);
                if (child2 instanceof StartMarker && child2.myBuilder.myOptionalData.isCollapsed(child2.markerId)) {
                    int lastIndex = child2.getEndIndex();
                    this.insertLeaf(child2.getTokenType(), marker.myBuilder, child2.myLexemeIndex, lastIndex, true, marker);
                } else {
                    this.ensureCapacity();
                    this.nodes[this.count++] = child2;
                }
                if (child2 instanceof StartMarker) {
                    lexIndex = child2.getEndIndex();
                }
                child2 = child2.myNext;
            }
            this.insertLeaves(lexIndex, marker.getEndIndex(), marker.myBuilder, marker);
            into.set((Object)(this.nodes == null ? LighterASTNode.EMPTY_ARRAY : this.nodes));
            this.nodes = null;
            return this.count;
        }

        public void disposeChildren(LighterASTNode[] nodes, int count) {
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                LighterASTNode node = nodes[i];
                if (node instanceof LazyParseableToken) {
                    this.myLazyPool.recycle((Object)((LazyParseableToken)node));
                    continue;
                }
                if (!(node instanceof Token)) continue;
                this.myPool.recycle((Object)((Token)node));
            }
        }

        private void ensureCapacity() {
            LighterASTNode[] old = this.nodes;
            if (old == null) {
                this.nodes = old = new LighterASTNode[10];
            } else if (this.count >= old.length) {
                LighterASTNode[] newStore = new LighterASTNode[this.count * 3 / 2];
                System.arraycopy(old, 0, newStore, 0, this.count);
                this.nodes = newStore;
            }
        }

        private int insertLeaves(int curToken, int lastIdx, PsiBuilderImpl builder2, StartMarker parent) {
            lastIdx = Math.min(lastIdx, builder2.myLexemeCount);
            while (curToken < lastIdx) {
                this.insertLeaf(builder2.myLexTypes[curToken], builder2, curToken, curToken + 1, false, parent);
                ++curToken;
            }
            return curToken;
        }

        private void insertLeaf(@NotNull IElementType type, @NotNull PsiBuilderImpl builder2, int startLexemeIndex, int endLexemeIndex, boolean forceInsertion, StartMarker parent) {
            int end;
            int start2 = builder2.myLexStarts[startLexemeIndex];
            if (start2 > (end = builder2.myLexStarts[endLexemeIndex]) || !forceInsertion && start2 == end && !(type instanceof ILeafElementType)) {
                return;
            }
            Token lexeme = this.obtainToken(type, builder2, startLexemeIndex, endLexemeIndex, parent, start2, end);
            this.ensureCapacity();
            this.nodes[this.count++] = lexeme;
        }

        @NotNull
        private Token obtainToken(@NotNull IElementType type, @NotNull PsiBuilderImpl builder2, int startLexemeIndex, int endLexemeIndex, StartMarker parent, int start2, int end) {
            if (type instanceof ILightLazyParseableElementType) {
                return this.obtainLazyToken(type, builder2, startLexemeIndex, endLexemeIndex, parent, start2, end);
            }
            Token lexeme = (Token)this.myPool.alloc();
            lexeme.initToken(type, builder2, parent, start2, end);
            return lexeme;
        }

        @NotNull
        private Token obtainLazyToken(@NotNull IElementType type, @NotNull PsiBuilderImpl builder2, int startLexemeIndex, int endLexemeIndex, StartMarker parent, int start2, int end) {
            int startInFile = start2 + builder2.myOffset;
            LazyParseableToken token = (LazyParseableToken)builder2.myChameleonCache.get(startInFile);
            if (token == null) {
                token = (LazyParseableToken)this.myLazyPool.alloc();
                token.myStartIndex = startLexemeIndex;
                token.myEndIndex = endLexemeIndex;
                token.initToken(type, builder2, parent, start2, end);
                builder2.myChameleonCache.put(startInFile, (Object)token);
            } else if (token.myBuilder != builder2 || token.myStartIndex != startLexemeIndex || token.myEndIndex != endLexemeIndex) {
                throw new AssertionError((Object)"Wrong chameleon cached");
            }
            token.myParentStructure = this;
            return token;
        }

        @NotNull
        public CharSequence toString(@NotNull LighterASTNode node) {
            return this.myRoot.myBuilder.myText.subSequence(node.getStartOffset(), node.getEndOffset());
        }

        public int getStartOffset(@NotNull LighterASTNode node) {
            return node.getStartOffset();
        }

        public int getEndOffset(@NotNull LighterASTNode node) {
            return node.getEndOffset();
        }
    }

    private static class MyComparator
    implements ShallowNodeComparator<ASTNode, LighterASTNode> {
        private final TripleFunction<? super ASTNode, ? super LighterASTNode, ? super FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom;
        @NotNull
        private final List<? extends CustomLanguageASTComparator> myCustomLanguageASTComparators;
        private final MyTreeStructure myTreeStructure;

        private MyComparator(TripleFunction<? super ASTNode, ? super LighterASTNode, ? super FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom, @NotNull List<? extends CustomLanguageASTComparator> customLanguageASTComparators, @NotNull MyTreeStructure treeStructure) {
            this.custom = custom;
            this.myCustomLanguageASTComparators = customLanguageASTComparators;
            this.myTreeStructure = treeStructure;
        }

        @NotNull
        public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            boolean newIsErrorElement;
            ProgressIndicatorProvider.checkCanceled();
            boolean oldIsErrorElement = oldNode instanceof PsiErrorElement;
            boolean bl = newIsErrorElement = newNode.getTokenType() == TokenType.ERROR_ELEMENT;
            if (oldIsErrorElement != newIsErrorElement) {
                return ThreeState.NO;
            }
            if (oldIsErrorElement) {
                PsiErrorElement e1 = (PsiErrorElement)oldNode;
                return Comparing.equal((String)e1.getErrorDescription(), (String)PsiBuilderImpl.getErrorMessage(newNode)) ? ThreeState.UNSURE : ThreeState.NO;
            }
            ThreeState customResult = this.customCompare(oldNode, newNode);
            if (customResult != ThreeState.UNSURE) {
                return customResult;
            }
            if (newNode instanceof Token) {
                IElementType type = newNode.getTokenType();
                Token token = (Token)newNode;
                if (oldNode instanceof ForeignLeafPsiElement) {
                    return type instanceof ForeignLeafType && ((ForeignLeafType)type).getValue().equals(oldNode.getText()) ? ThreeState.YES : ThreeState.NO;
                }
                if (oldNode instanceof LeafElement) {
                    if (type instanceof ForeignLeafType) {
                        return ThreeState.NO;
                    }
                    return ((LeafElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                }
                if (type instanceof ILightLazyParseableElementType) {
                    if (((TreeElement)oldNode).textMatches(token.getText())) {
                        return PsiDocumentManagerBase.isFullReparseInProgress() ? ThreeState.UNSURE : ThreeState.YES;
                    }
                    return TreeUtil.isCollapsedChameleon(oldNode) ? ThreeState.NO : ThreeState.UNSURE;
                }
                if (oldNode.getElementType() instanceof ILazyParseableElementType && type instanceof ILazyParseableElementType || oldNode.getElementType() instanceof ICustomParsingType && type instanceof ICustomParsingType) {
                    return ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                }
            }
            return ThreeState.UNSURE;
        }

        @NotNull
        private ThreeState customCompare(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
            ThreeState customResult;
            for (CustomLanguageASTComparator customLanguageASTComparator : this.myCustomLanguageASTComparators) {
                ThreeState customComparatorResult = customLanguageASTComparator.compareAST(oldNode, newNode, (FlyweightCapableTreeStructure)this.myTreeStructure);
                if (customComparatorResult == ThreeState.UNSURE) continue;
                return customComparatorResult;
            }
            if (this.custom != null && (customResult = (ThreeState)this.custom.fun((Object)oldNode, (Object)newNode, (Object)this.myTreeStructure)) != ThreeState.UNSURE) {
                return customResult;
            }
            return ThreeState.UNSURE;
        }

        public boolean typesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            IElementType n2t;
            ForeignLeafType n1t;
            if (n1 instanceof PsiWhiteSpaceImpl) {
                return ourAnyLanguageWhitespaceTokens.contains(n2.getTokenType()) || n2 instanceof Token && ((Token)n2).myBuilder.myWhitespaces.contains(n2.getTokenType());
            }
            if (n1 instanceof ForeignLeafPsiElement) {
                n1t = ((ForeignLeafPsiElement)n1).getForeignType();
                n2t = n2.getTokenType();
            } else {
                n1t = MyComparator.dereferenceToken(n1.getElementType());
                n2t = MyComparator.dereferenceToken(n2.getTokenType());
            }
            return Comparing.equal((Object)((Object)n1t), (Object)n2t);
        }

        private static IElementType dereferenceToken(IElementType probablyWrapper) {
            if (probablyWrapper instanceof TokenWrapper) {
                return MyComparator.dereferenceToken(((TokenWrapper)probablyWrapper).getDelegate());
            }
            return probablyWrapper;
        }

        public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
            PsiErrorElement e1;
            if (n1 instanceof LeafElement && n2 instanceof Token) {
                boolean isForeign1 = n1 instanceof ForeignLeafPsiElement;
                boolean isForeign2 = n2.getTokenType() instanceof ForeignLeafType;
                if (isForeign1 != isForeign2) {
                    return false;
                }
                if (isForeign1) {
                    return n1.getText().equals(((ForeignLeafType)n2.getTokenType()).getValue());
                }
                return ((LeafElement)n1).textMatches(((Token)n2).getText());
            }
            if (n1 instanceof PsiErrorElement && n2.getTokenType() == TokenType.ERROR_ELEMENT && !Comparing.equal((String)(e1 = (PsiErrorElement)n1).getErrorDescription(), (String)PsiBuilderImpl.getErrorMessage(n2))) {
                return false;
            }
            return ((TreeElement)n1).hc() == ((Node)n2).hc();
        }
    }

    private final class RelativeTokenTextView
    implements WhitespacesAndCommentsBinder.TokenTextGetter {
        private int myStart;

        private RelativeTokenTextView() {
        }

        private void configure(int start2) {
            this.myStart = start2;
        }

        @NotNull
        public CharSequence get(int i) {
            return PsiBuilderImpl.this.myText.subSequence(PsiBuilderImpl.this.myLexStarts[this.myStart + i], PsiBuilderImpl.this.myLexStarts[this.myStart + i + 1]);
        }
    }

    private final class RelativeTokenTypesView
    extends AbstractList<IElementType> {
        private int myStart;
        private int mySize;

        private RelativeTokenTypesView() {
        }

        private void configure(int start2, int end) {
            this.myStart = start2;
            this.mySize = end - start2;
        }

        @Override
        public IElementType get(int index) {
            return PsiBuilderImpl.this.myLexTypes[this.myStart + index];
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private static class ConvertFromTokensToASTBuilder
    implements DiffTreeChangeBuilder<ASTNode, LighterASTNode> {
        private final DiffTreeChangeBuilder<? super ASTNode, ? super ASTNode> myDelegate;
        private final ASTConverter myConverter;

        private ConvertFromTokensToASTBuilder(@NotNull StartMarker rootNode, @NotNull DiffTreeChangeBuilder<? super ASTNode, ? super ASTNode> delegate, @Nullable ASTFactory astFactory) {
            this.myDelegate = delegate;
            this.myConverter = new ASTConverter(rootNode, astFactory);
        }

        public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            this.myDelegate.nodeDeleted((Object)oldParent, (Object)oldNode);
        }

        public void nodeInserted(@NotNull ASTNode oldParent, @NotNull LighterASTNode newNode, int pos) {
            this.myDelegate.nodeInserted((Object)oldParent, (Object)this.myConverter.convert((Node)newNode), pos);
        }

        public void nodeReplaced(@NotNull ASTNode oldChild, @NotNull LighterASTNode newChild) {
            ASTNode converted = this.myConverter.convert((Node)newChild);
            this.myDelegate.nodeReplaced((Object)oldChild, (Object)converted);
        }
    }

    static class ErrorItem
    extends ProductionMarker {
        private String myMessage;

        ErrorItem(int markerId, PsiBuilderImpl builder2) {
            super(markerId, builder2);
        }

        @Override
        void clean() {
            super.clean();
            this.myMessage = null;
        }

        @Override
        public WhitespacesAndCommentsBinder getBinder(boolean done) {
            assert (!done);
            return WhitespacesBinders.DEFAULT_RIGHT_BINDER;
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            assert (!done);
            this.myLexemeIndex = lexemeIndex;
        }

        @Override
        int getLexemeIndex(boolean done) {
            assert (!done);
            return this.myLexemeIndex;
        }

        @Override
        public int hc() {
            return 0;
        }

        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        @Override
        public int getEndIndex() {
            return this.getStartIndex();
        }

        @NotNull
        public IElementType getTokenType() {
            return TokenType.ERROR_ELEMENT;
        }
    }

    private static class LazyParseableToken
    extends Token
    implements LighterLazyParseableNode {
        private MyTreeStructure myParentStructure;
        private FlyweightCapableTreeStructure<LighterASTNode> myParsed;
        private int myStartIndex;
        private int myEndIndex;

        private LazyParseableToken() {
        }

        @Override
        public void clean() {
            this.myBuilder.myChameleonCache.remove(this.getStartOffset());
            super.clean();
            this.myParentStructure = null;
            this.myParsed = null;
        }

        public PsiFile getContainingFile() {
            return this.myBuilder.myFile;
        }

        public CharTable getCharTable() {
            return this.myBuilder.myCharTable;
        }

        public FlyweightCapableTreeStructure<LighterASTNode> parseContents() {
            if (this.myParsed == null) {
                this.myParsed = ((ILightLazyParseableElementType)this.getTokenType()).parseContents((LighterLazyParseableNode)this);
            }
            return this.myParsed;
        }

        public boolean accept(@NotNull LighterLazyParseableNode.Visitor visitor) {
            for (int i = this.myStartIndex; i < this.myEndIndex; ++i) {
                IElementType type = this.myBuilder.myLexTypes[i];
                if (visitor.visit(type)) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private TokenSequence getParsedTokenSequence() {
            int tokenCount = this.myEndIndex - this.myStartIndex;
            if (tokenCount == 1) {
                return null;
            }
            int[] lexStarts = new int[tokenCount + 1];
            System.arraycopy(this.myBuilder.myLexStarts, this.myStartIndex, lexStarts, 0, tokenCount);
            int diff = this.myBuilder.myLexStarts[this.myStartIndex];
            int i = 0;
            while (i < tokenCount) {
                int n = i++;
                lexStarts[n] = lexStarts[n] - diff;
            }
            lexStarts[tokenCount] = this.getEndOffset() - this.getStartOffset();
            IElementType[] lexTypes = new IElementType[tokenCount + 1];
            System.arraycopy(this.myBuilder.myLexTypes, this.myStartIndex, lexTypes, 0, tokenCount);
            return new TokenSequence(lexStarts, lexTypes, tokenCount);
        }
    }

    private static class TokenNode
    extends Token
    implements LighterASTTokenNode {
        private TokenNode() {
        }

        public String toString() {
            return this.getText().toString();
        }
    }

    private static abstract class Token
    implements Node {
        protected PsiBuilderImpl myBuilder;
        private IElementType myTokenType;
        private int myTokenStart;
        private int myTokenEnd;
        private int myHC = -1;
        private StartMarker myParentNode;

        private Token() {
        }

        public void clean() {
            this.myBuilder = null;
            this.myHC = -1;
            this.myParentNode = null;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                int hc = 0;
                if (this.myTokenType instanceof TokenWrapper) {
                    String value = ((TokenWrapper)this.myTokenType).getValue();
                    for (int i = 0; i < value.length(); ++i) {
                        hc += value.charAt(i);
                    }
                } else {
                    int start2 = this.myTokenStart;
                    int end = this.myTokenEnd;
                    CharSequence buf = this.myBuilder.myText;
                    char[] bufArray = this.myBuilder.myTextArray;
                    for (int i = start2; i < end; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        public int getEndOffset() {
            return this.myTokenEnd + this.myBuilder.myOffset;
        }

        public int getStartOffset() {
            return this.myTokenStart + this.myBuilder.myOffset;
        }

        @NotNull
        public CharSequence getText() {
            if (this.myTokenType instanceof TokenWrapper) {
                return ((TokenWrapper)this.myTokenType).getValue();
            }
            return this.myBuilder.myText.subSequence(this.myTokenStart, this.myTokenEnd);
        }

        @NotNull
        public IElementType getTokenType() {
            return this.myTokenType;
        }

        void initToken(@NotNull IElementType type, @NotNull PsiBuilderImpl builder2, StartMarker parent, int start2, int end) {
            this.myParentNode = parent;
            this.myBuilder = builder2;
            this.myTokenType = type;
            this.myTokenStart = start2;
            this.myTokenEnd = end;
        }
    }

    static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        private IElementType myType;
        private int myDoneLexeme = -1;
        private ProductionMarker myFirstChild;
        private ProductionMarker myLastChild;
        private int myHC = -1;

        StartMarker(int markerId, PsiBuilderImpl builder2) {
            super(markerId, builder2);
        }

        @Override
        void clean() {
            super.clean();
            this.myBuilder.myOptionalData.clean(this.markerId);
            this.myType = null;
            this.myDoneLexeme = -1;
            this.myLastChild = null;
            this.myFirstChild = null;
            this.myHC = -1;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                PsiBuilderImpl builder2 = this.myBuilder;
                int hc = 0;
                CharSequence buf = builder2.myText;
                char[] bufArray = builder2.myTextArray;
                ProductionMarker child2 = this.myFirstChild;
                int lexIdx = this.myLexemeIndex;
                while (child2 != null) {
                    int lastLeaf = child2.myLexemeIndex;
                    for (int i = builder2.myLexStarts[lexIdx]; i < builder2.myLexStarts[lastLeaf]; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                    lexIdx = lastLeaf;
                    hc += child2.hc();
                    if (child2 instanceof StartMarker) {
                        lexIdx = child2.getEndIndex();
                    }
                    child2 = child2.myNext;
                }
                for (int i = builder2.myLexStarts[lexIdx]; i < builder2.myLexStarts[this.getEndIndex()]; ++i) {
                    hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.getEndIndex()] + this.myBuilder.myOffset;
        }

        @Override
        public int getEndIndex() {
            return this.myDoneLexeme;
        }

        @Override
        @NotNull
        WhitespacesAndCommentsBinder getBinder(boolean done) {
            return this.myBuilder.myOptionalData.getBinder(this.markerId, done);
        }

        @Override
        void setLexemeIndex(int lexemeIndex, boolean done) {
            if (done) {
                this.myDoneLexeme = lexemeIndex;
            } else {
                this.myLexemeIndex = lexemeIndex;
            }
        }

        @Override
        int getLexemeIndex(boolean done) {
            return done ? this.myDoneLexeme : this.myLexemeIndex;
        }

        public void addChild(@NotNull ProductionMarker node) {
            if (this.myFirstChild == null) {
                this.myFirstChild = node;
                this.myLastChild = node;
            } else {
                this.myLastChild.myNext = node;
                this.myLastChild = node;
            }
        }

        @NotNull
        public PsiBuilder.Marker precede() {
            return this.myBuilder.precede(this);
        }

        public void drop() {
            this.myBuilder.myProduction.dropMarker(this);
        }

        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        public void done(@NotNull IElementType type) {
            if (type == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.error() instead", (Throwable)new RuntimeException());
            }
            this.myType = type;
            this.myBuilder.processDone(this, null, null);
        }

        public void collapse(@NotNull IElementType type) {
            this.done(type);
            this.myBuilder.myOptionalData.markCollapsed(this.markerId);
        }

        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before) {
            if (type == TokenType.ERROR_ELEMENT) {
                LOG.warn("Error elements with empty message are discouraged. Please use builder.errorBefore() instead", (Throwable)new RuntimeException());
            }
            this.myType = type;
            this.myBuilder.processDone(this, null, (StartMarker)before);
        }

        public void doneBefore(@NotNull IElementType type, @NotNull PsiBuilder.Marker before, @NotNull String errorMessage) {
            StartMarker marker = (StartMarker)before;
            ErrorItem errorItem = this.myBuilder.myPool.allocateErrorItem();
            errorItem.myMessage = errorMessage;
            errorItem.myLexemeIndex = marker.myLexemeIndex;
            this.myBuilder.myProduction.addBefore(errorItem, marker);
            this.doneBefore(type, before);
        }

        public void error(@NotNull String message) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, null);
        }

        public void errorBefore(@NotNull String message, @NotNull PsiBuilder.Marker before) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.processDone(this, message, (StartMarker)before);
        }

        public IElementType getTokenType() {
            return this.myType;
        }

        @Override
        public void remapTokenType(@NotNull IElementType type) {
            this.myType = type;
        }

        public void setCustomEdgeTokenBinders(WhitespacesAndCommentsBinder left, WhitespacesAndCommentsBinder right) {
            if (left != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, left, false);
            }
            if (right != null) {
                this.myBuilder.myOptionalData.assignBinder(this.markerId, right, true);
            }
        }

        public String toString() {
            if (this.myLexemeIndex < 0) {
                return "<dropped>";
            }
            boolean isDone = this.isDone();
            CharSequence originalText = this.myBuilder.getOriginalText();
            int startOffset = this.getStartOffset() - this.myBuilder.myOffset;
            int endOffset = isDone ? this.getEndOffset() - this.myBuilder.myOffset : this.myBuilder.getCurrentOffset();
            CharSequence text = originalText.subSequence(startOffset, endOffset);
            return isDone ? text.toString() : text + "\u2026";
        }

        boolean isDone() {
            return this.myDoneLexeme != -1;
        }
    }

    public static abstract class ProductionMarker
    implements Node {
        final int markerId;
        protected final PsiBuilderImpl myBuilder;
        protected int myLexemeIndex = -1;
        protected ProductionMarker myParent;
        protected ProductionMarker myNext;

        ProductionMarker(int markerId, @NotNull PsiBuilderImpl builder2) {
            this.markerId = markerId;
            this.myBuilder = builder2;
        }

        void clean() {
            this.myLexemeIndex = -1;
            this.myNext = null;
            this.myParent = null;
        }

        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex] + this.myBuilder.myOffset;
        }

        public void remapTokenType(@NotNull IElementType type) {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        public int getStartIndex() {
            return this.myLexemeIndex;
        }

        public int getEndIndex() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @NotNull
        abstract WhitespacesAndCommentsBinder getBinder(boolean var1);

        abstract void setLexemeIndex(int var1, boolean var2);

        abstract int getLexemeIndex(boolean var1);
    }

    private static interface Node
    extends LighterASTNode {
        public int hc();
    }
}

