/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

class TokenSequence {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.impl.TokenSequence");
    final int[] lexStarts;
    final IElementType[] lexTypes;
    final int lexemeCount;

    TokenSequence(int[] lexStarts, IElementType[] lexTypes, int lexemeCount) {
        this.lexStarts = lexStarts;
        this.lexTypes = lexTypes;
        this.lexemeCount = lexemeCount;
        assert (lexemeCount < lexStarts.length);
        assert (lexemeCount < lexTypes.length);
    }

    void assertMatches(@NotNull CharSequence text, @NotNull Lexer lexer) {
        TokenSequence sequence = new Builder(text, lexer).performLexing();
        assert (this.lexemeCount == sequence.lexemeCount);
        for (int j = 0; j <= this.lexemeCount; ++j) {
            if (sequence.lexStarts[j] != this.lexStarts[j] || sequence.lexTypes[j] != this.lexTypes[j]) assert (false);
        }
    }

    static class Builder {
        private final CharSequence myText;
        private final Lexer myLexer;
        private int[] myLexStarts;
        private IElementType[] myLexTypes;

        Builder(@NotNull CharSequence text, @NotNull Lexer lexer) {
            this.myText = text;
            this.myLexer = lexer;
            int approxLexCount = Math.max(10, this.myText.length() / 5);
            this.myLexStarts = new int[approxLexCount];
            this.myLexTypes = new IElementType[approxLexCount];
        }

        @NotNull
        TokenSequence performLexing() {
            IElementType type;
            this.myLexer.start(this.myText);
            int i = 0;
            int offset = 0;
            while ((type = this.myLexer.getTokenType()) != null) {
                int tokenStart;
                if (i % 20 == 0) {
                    ProgressIndicatorProvider.checkCanceled();
                }
                if (i >= this.myLexTypes.length - 1) {
                    this.resizeLexemes(i * 3 / 2);
                }
                if ((tokenStart = this.myLexer.getTokenStart()) < offset) {
                    this.reportDescendingOffsets(i, offset, tokenStart);
                }
                this.myLexStarts[i] = offset = tokenStart;
                this.myLexTypes[i] = type;
                ++i;
                this.myLexer.advance();
            }
            this.myLexStarts[i] = this.myText.length();
            return new TokenSequence(this.myLexStarts, this.myLexTypes, i);
        }

        private void reportDescendingOffsets(int tokenIndex, int offset, int tokenStart) {
            StringBuilder sb = new StringBuilder();
            IElementType tokenType = this.myLexer.getTokenType();
            sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
            if (tokenIndex > 0) {
                int prevStart = this.myLexStarts[tokenIndex - 1];
                sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset)).append("' (").append(this.myLexTypes[tokenIndex - 1]).append(':').append(this.myLexTypes[tokenIndex - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset);
            }
            int quoteStart = Math.max(tokenStart - 256, 0);
            int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
            sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
            LOG.error((Object)sb);
        }

        private void resizeLexemes(int newSize) {
            this.myLexStarts = ArrayUtil.realloc((int[])this.myLexStarts, (int)newSize);
            this.myLexTypes = (IElementType[])ArrayUtil.realloc((Object[])this.myLexTypes, (int)newSize, (ArrayFactory)IElementType.ARRAY_FACTORY);
        }
    }
}

