/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGithubTagDownloadedProjectGenerator
extends WebProjectTemplate<GithubTagInfo> {
    private static final Logger LOG = Logger.getInstance(AbstractGithubTagDownloadedProjectGenerator.class);

    @Override
    @NotNull
    @Nls
    public final String getName() {
        return this.getDisplayName();
    }

    @NotNull
    protected abstract String getDisplayName();

    @NotNull
    public abstract String getGithubUserName();

    @NotNull
    public abstract String getGithubRepositoryName();

    @Override
    @Nullable
    public abstract String getDescription();

    private String getTitle() {
        return this.getDisplayName();
    }

    @Override
    @Nullable
    public String getHelpId() {
        return "create.from.template." + this.getGithubUserName() + "." + this.getGithubRepositoryName();
    }

    @Override
    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull GithubTagInfo tag, @NotNull Module module) {
        try {
            this.unpackToDir(project, VfsUtilCore.virtualToIoFile((VirtualFile)baseDir), tag);
        }
        catch (GeneratorException e) {
            this.showErrorMessage(project, e.getMessage());
        }
        ApplicationManager.getApplication().runWriteAction(() -> baseDir.refresh(true, true));
    }

    @NotNull
    public GithubProjectGeneratorPeer createPeer() {
        return new GithubProjectGeneratorPeer(this);
    }

    @Override
    public boolean isPrimaryGenerator() {
        return PlatformUtils.isWebStorm();
    }

    private void unpackToDir(@Nullable Project project, @NotNull File extractToDir, @NotNull GithubTagInfo tag) throws GeneratorException {
        File zipArchiveFile = this.getCacheFile(tag);
        String primaryUrl = this.getPrimaryZipArchiveUrlForDownload(tag);
        boolean downloaded = false;
        if (primaryUrl != null) {
            try {
                this.downloadAndUnzip(project, primaryUrl, zipArchiveFile, extractToDir, false);
                downloaded = true;
            }
            catch (GeneratorException e) {
                LOG.info("Can't download " + primaryUrl, (Throwable)e);
                FileUtil.delete((File)zipArchiveFile);
            }
        }
        if (!downloaded) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new GeneratorException("Download " + tag.getZipballUrl() + " is skipped in unit test mode");
            }
            this.downloadAndUnzip(project, tag.getZipballUrl(), zipArchiveFile, extractToDir, true);
        }
    }

    private void downloadAndUnzip(@Nullable Project project, @NotNull String url, @NotNull File zipArchiveFile, @NotNull File extractToDir, boolean retryOnError) throws GeneratorException {
        GithubDownloadUtil.downloadContentToFileWithProgressSynchronously(project, url, this.getTitle(), zipArchiveFile, this.getGithubUserName(), this.getGithubRepositoryName(), retryOnError);
        LOG.info("Content of " + url + " has been successfully downloaded to " + zipArchiveFile.getAbsolutePath() + ", size " + zipArchiveFile.length() + " bytes");
        ZipUtil.unzipWithProgressSynchronously(project, this.getTitle(), zipArchiveFile, extractToDir, this.getPathConvertor(), true);
    }

    @Nullable
    protected NullableFunction<String, String> getPathConvertor() {
        return null;
    }

    @Nullable
    public abstract String getPrimaryZipArchiveUrlForDownload(@NotNull GithubTagInfo var1);

    @NotNull
    private File getCacheFile(@NotNull GithubTagInfo tag) {
        String fileName2 = tag.getName() + ".zip";
        try {
            fileName2 = URLEncoder.encode(fileName2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Can't urlEncode", (Throwable)e);
        }
        return GithubDownloadUtil.findCacheFile(this.getGithubUserName(), this.getGithubRepositoryName(), fileName2);
    }

    private void showErrorMessage(@NotNull Project project, @NotNull String message) {
        String fullMessage = "Error creating " + this.getDisplayName() + " project. " + message;
        String title = "Create " + this.getDisplayName() + " Project";
        Messages.showErrorDialog((Project)project, (String)fullMessage, (String)title);
    }

    public ActionLink createGitHubLink() {
        ActionLink link2 = new ActionLink(this.getName() + " on GitHub", (AnAction)DumbAwareAction.create(e -> BrowserUtil.open((String)("https://github.com/" + this.getGithubUserName() + "/" + this.getGithubRepositoryName()))));
        link2.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        return link2;
    }
}

