/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.util.Producer;
import com.intellij.util.net.IOExceptionDialog;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubDownloadUtil {
    private static final String PROJECT_GENERATORS = "projectGenerators";

    private GithubDownloadUtil() {
    }

    @NotNull
    private static String formatGithubRepositoryName(@NotNull String userName, @NotNull String repositoryName) {
        return "github-" + userName + "-" + repositoryName;
    }

    @NotNull
    private static String formatGithubUserName(@NotNull String userName) {
        return "github-" + userName;
    }

    @NotNull
    public static File getCacheDir(@NotNull String userName, @NotNull String repositoryName) {
        File generatorsDir = new File(PathManager.getSystemPath(), PROJECT_GENERATORS);
        String dirName = GithubDownloadUtil.formatGithubRepositoryName(userName, repositoryName);
        File dir = new File(generatorsDir, dirName);
        try {
            return dir.getCanonicalFile();
        }
        catch (IOException e) {
            return dir;
        }
    }

    @NotNull
    public static File getUserCacheDir(@NotNull String userName) {
        File generatorsDir = new File(PathManager.getSystemPath(), PROJECT_GENERATORS);
        String dirName = GithubDownloadUtil.formatGithubUserName(userName);
        File dir = new File(generatorsDir, dirName);
        try {
            return dir.getCanonicalFile();
        }
        catch (IOException e) {
            return dir;
        }
    }

    public static File findCacheFile(@NotNull String userName, @NotNull String repositoryName, @NotNull String cacheFileName) {
        File dir = GithubDownloadUtil.getCacheDir(userName, repositoryName);
        return new File(dir, cacheFileName);
    }

    public static void downloadContentToFileWithProgressSynchronously(@Nullable Project project, @NotNull String url, @NotNull String progressTitle, @NotNull File outputFile, @NotNull String userName, @NotNull String repositoryName, boolean retryOnError) throws GeneratorException {
        Outcome<File> outcome = DownloadUtil.provideDataWithProgressSynchronously(project, progressTitle, "Downloading zip archive${content-length} ...", () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            GithubDownloadUtil.downloadAtomically(progress, url, outputFile, userName, repositoryName);
            return outputFile;
        }, (Producer<Boolean>)((Producer)() -> {
            if (!retryOnError) {
                return false;
            }
            return IOExceptionDialog.showErrorDialog((String)"Download Error", (String)("Can not download '" + url + "'"));
        }));
        File out = outcome.get();
        if (out != null) {
            return;
        }
        Exception e = outcome.getException();
        if (e != null) {
            throw new GeneratorException("Can not fetch content from " + url, e);
        }
        throw new GeneratorException("Download was cancelled");
    }

    public static void downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile, @NotNull String userName, @NotNull String repositoryName) throws IOException {
        String tempFileName = String.format("github-%s-%s-%s", userName, repositoryName, outputFile.getName());
        File tempFile = FileUtil.createTempFile((String)(tempFileName + "-"), (String)".tmp");
        DownloadUtil.downloadAtomically(indicator, url, outputFile, tempFile);
    }
}

