/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.collect.Sets;
import com.intellij.BundleBase;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.lang.javascript.boilerplate.AbstractGithubTagDownloadedProjectGenerator;
import com.intellij.lang.javascript.boilerplate.GithubTagListProvider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ReloadableComboBoxPanel;
import com.intellij.util.ui.ReloadablePanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubProjectGeneratorPeer
implements WebProjectGenerator.GeneratorPeer<GithubTagInfo> {
    private final List<WebProjectGenerator.SettingsStateListener> myListeners;
    private final GithubTagInfo myMasterTag;
    private final GithubTagListProvider myTagListProvider;
    private JComponent myComponent;
    private JPanel myVersionPanel;
    private ReloadablePanel<GithubTagInfo> myReloadableComboBoxPanel;

    public static String getGithubZipballUrl(String ghUserName, String ghRepoName, String branch) {
        return String.format("https://github.com/%s/%s/zipball/%s", ghUserName, ghRepoName, branch);
    }

    private void createUIComponents() {
        this.myReloadableComboBoxPanel = new ReloadableComboBoxPanel<GithubTagInfo>(){

            @Override
            protected void doUpdateValues(@NotNull Set<GithubTagInfo> tags) {
                if (!this.shouldUpdate(tags)) {
                    return;
                }
                List sortedTags = GithubProjectGeneratorPeer.createSortedTagList(tags);
                GithubTagInfo selectedItem = (GithubTagInfo)this.getSelectedValue();
                if (selectedItem == null && sortedTags.size() > 0) {
                    selectedItem = (GithubTagInfo)sortedTags.get(0);
                }
                this.myComboBox.removeAllItems();
                this.myComboBox.addItem(GithubProjectGeneratorPeer.this.myMasterTag);
                for (GithubTagInfo tag : sortedTags) {
                    this.myComboBox.addItem(tag);
                }
                if (selectedItem != null) {
                    for (int i = 0; i < this.myComboBox.getItemCount(); ++i) {
                        GithubTagInfo item = GithubTagInfo.tryCast(this.myComboBox.getItemAt(i));
                        if (item == null || !item.getName().equals(selectedItem.getName())) continue;
                        this.myComboBox.setSelectedIndex(i);
                        break;
                    }
                }
                this.myComboBox.updateUI();
                GithubProjectGeneratorPeer.this.fireStateChanged();
            }

            private boolean shouldUpdate(Set<GithubTagInfo> newTags) {
                if (this.myComboBox.getItemCount() == 0) {
                    return true;
                }
                int count = this.myComboBox.getItemCount();
                HashSet oldTags = Sets.newHashSet();
                for (int i = 1; i < count; ++i) {
                    GithubTagInfo item = (GithubTagInfo)ObjectUtils.tryCast(this.myComboBox.getItemAt(i), GithubTagInfo.class);
                    if (item == null) continue;
                    oldTags.add(item);
                }
                return !oldTags.equals(newTags);
            }

            @Override
            @NotNull
            protected JComboBox createValuesComboBox() {
                JComboBox box = super.createValuesComboBox();
                box.setRenderer(new ListCellRendererWrapper<GithubTagInfo>(){

                    public void customize(JList list2, GithubTagInfo tag, int index, boolean selected, boolean hasFocus) {
                        String text = tag == null ? (this.isBackgroundJobRunning() ? "Loading..." : "Unavailable") : tag.getName();
                        this.setText(text);
                    }
                });
                return box;
            }
        };
        this.myVersionPanel = this.myReloadableComboBoxPanel.getMainPanel();
    }

    public GithubProjectGeneratorPeer(@NotNull AbstractGithubTagDownloadedProjectGenerator generator) {
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.newArrayList();
        String ghUserName = generator.getGithubUserName();
        String ghRepoName = generator.getGithubRepositoryName();
        this.myMasterTag = new GithubTagInfo("master", GithubProjectGeneratorPeer.getGithubZipballUrl(ghUserName, ghRepoName, "master"));
        this.myTagListProvider = new GithubTagListProvider(ghUserName, ghRepoName);
        this.myReloadableComboBoxPanel.setDataProvider(new ReloadablePanel.DataProvider<GithubTagInfo>(){

            @Override
            public Set<GithubTagInfo> getCachedValues() {
                return GithubProjectGeneratorPeer.this.myTagListProvider.getCachedTags();
            }

            @Override
            public void updateValuesAsynchronously() {
                GithubProjectGeneratorPeer.this.myTagListProvider.updateTagListAsynchronously(GithubProjectGeneratorPeer.this);
            }
        });
        this.myReloadableComboBoxPanel.reloadValuesInBackground();
    }

    void onTagsUpdated(@NotNull Set<GithubTagInfo> tags) {
        this.myReloadableComboBoxPanel.onUpdateValues(tags);
    }

    void onTagsUpdateError(@NotNull String errorMessage) {
        this.myReloadableComboBoxPanel.onValuesUpdateError(errorMessage);
    }

    @NotNull
    private static List<GithubTagInfo> createSortedTagList(@NotNull Collection<GithubTagInfo> tags) {
        ArrayList sortedTags = ContainerUtil.newArrayList(tags);
        Collections.sort(sortedTags, (tag1, tag2) -> {
            GithubTagInfo.Version v1 = tag1.getVersion();
            GithubTagInfo.Version v2 = tag2.getVersion();
            return v2.compareTo(v1);
        });
        for (GithubTagInfo tag : sortedTags) {
            tag.setRecentTag(false);
        }
        if (!sortedTags.isEmpty()) {
            ((GithubTagInfo)sortedTags.get(0)).setRecentTag(true);
        }
        return sortedTags;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public void buildUI(@NotNull SettingsStep settingsStep) {
        settingsStep.addSettingsField(BundleBase.replaceMnemonicAmpersand((String)"&Version:"), (JComponent)this.myVersionPanel);
        settingsStep.addSettingsComponent((JComponent)this.myReloadableComboBoxPanel.getErrorComponent());
    }

    @Override
    @NotNull
    public GithubTagInfo getSettings() {
        GithubTagInfo tag = this.myReloadableComboBoxPanel.getSelectedValue();
        if (tag == null) {
            throw new RuntimeException("[internal error] No versions available.");
        }
        return tag;
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        GithubTagInfo tag = this.myReloadableComboBoxPanel.getSelectedValue();
        if (tag != null) {
            return null;
        }
        String errorMessage = StringUtil.notNullize((String)this.myReloadableComboBoxPanel.getErrorComponent().getText());
        if (errorMessage.isEmpty()) {
            errorMessage = "Versions have not been loaded yet.";
        }
        return new ValidationInfo(errorMessage);
    }

    @Override
    public boolean isBackgroundJobRunning() {
        return this.myReloadableComboBoxPanel.isBackgroundJobRunning();
    }

    @Override
    public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener2) {
        this.myListeners.add(listener2);
    }

    private void fireStateChanged() {
        GithubTagInfo tag = this.myReloadableComboBoxPanel.getSelectedValue();
        for (WebProjectGenerator.SettingsStateListener listener2 : this.myListeners) {
            listener2.stateChanged(tag != null);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        this.createUIComponents();
        JPanel jPanel = new JPanel();
        this.myComponent = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = this.myVersionPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Version:");
        jLabel.setDisplayedMnemonic('V');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }
}

