/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.pratt;

import com.intellij.lang.pratt.PrattBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PathPattern {
    private final List<ElementPattern> myPath = new SmartList();

    private PathPattern() {
    }

    public static PathPattern path() {
        return new PathPattern();
    }

    public PathPattern up() {
        this.myPath.add(null);
        return this;
    }

    public PathPattern left() {
        return this.left((ElementPattern)PlatformPatterns.elementType());
    }

    public PathPattern left(@NotNull IElementType pattern) {
        return this.left((ElementPattern)PlatformPatterns.elementType().equalTo((Object)pattern));
    }

    public PathPattern left(@NotNull ElementPattern pattern) {
        this.myPath.add(pattern);
        return this;
    }

    @NonNls
    public String toString() {
        return Arrays.toString(this.myPath.toArray()).replaceAll("null", "UP");
    }

    public boolean accepts(PrattBuilder builder2) {
        ListIterator<IElementType> iterator = null;
        for (ElementPattern pattern : this.myPath) {
            if (builder2 == null) {
                return false;
            }
            if (iterator == null) {
                iterator = builder2.getBackResultIterator();
            }
            if (pattern == null) {
                if (iterator.hasPrevious()) {
                    return false;
                }
                builder2 = builder2.getParent();
                iterator = null;
                continue;
            }
            if (!iterator.hasPrevious()) {
                return false;
            }
            if (pattern.accepts((Object)iterator.previous())) continue;
            return false;
        }
        return true;
    }
}

