/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XmlEnclosingTagUnwrapper
implements Unwrapper {
    @Override
    public boolean isApplicableTo(@NotNull PsiElement e) {
        return true;
    }

    @Override
    public void collectElementsToIgnore(@NotNull PsiElement element, @NotNull Set<PsiElement> result2) {
    }

    @Override
    @NotNull
    public String getDescription(@NotNull PsiElement e) {
        return XmlBundle.message((String)"unwrap.enclosing.tag.name.action.name", (Object[])new Object[]{((XmlTag)e).getName()});
    }

    @Override
    public PsiElement collectAffectedElements(@NotNull PsiElement element, @NotNull List<PsiElement> toExtract) {
        TextRange range2 = element.getTextRange();
        ASTNode startTagNameEnd = XmlChildRole.START_TAG_END_FINDER.findChild(element.getNode());
        ASTNode endTagNameStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(element.getNode());
        int start2 = startTagNameEnd != null ? startTagNameEnd.getTextRange().getEndOffset() : range2.getStartOffset();
        int end = endTagNameStart != null ? endTagNameStart.getTextRange().getStartOffset() : range2.getEndOffset();
        for (PsiElement child2 : element.getChildren()) {
            TextRange childRange = child2.getTextRange();
            if (childRange.getStartOffset() < start2 || childRange.getEndOffset() > end) continue;
            toExtract.add(child2);
        }
        return element;
    }

    @Override
    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        TextRange range2 = element.getTextRange();
        ASTNode startTagNameEnd = XmlChildRole.START_TAG_END_FINDER.findChild(element.getNode());
        ASTNode endTagNameStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(element.getNode());
        Project project = element.getProject();
        PsiFile file2 = element.getContainingFile();
        Document document = editor.getDocument();
        RangeMarker marker = document.createRangeMarker(range2);
        if (endTagNameStart != null) {
            document.deleteString(endTagNameStart.getTextRange().getStartOffset(), range2.getEndOffset());
            document.deleteString(range2.getStartOffset(), startTagNameEnd.getTextRange().getEndOffset());
        } else {
            document.replaceString(range2.getStartOffset(), range2.getEndOffset(), (CharSequence)"");
        }
        this.deleteEmptyLine(document, marker.getStartOffset());
        this.deleteEmptyLine(document, marker.getEndOffset());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, new TextRange(marker.getStartOffset(), marker.getEndOffset()));
        return Collections.emptyList();
    }

    protected void deleteEmptyLine(Document document, int offset) {
        int line;
        int n = line = offset < document.getTextLength() ? document.getLineNumber(offset) : -1;
        if (line > 0 && DocumentUtil.isLineEmpty(document, line)) {
            int start2 = document.getLineStartOffset(line);
            int end = Math.min(document.getLineEndOffset(line) + 1, document.getTextLength() - 1);
            if (end == document.getTextLength() - 1) {
                document.deleteString(start2 - 1, end);
            } else if (start2 < end) {
                document.deleteString(start2, end);
            }
        }
    }
}

