/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.LangBundle;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class XmlFindUsagesProvider
implements FindUsagesProvider {
    public boolean canFindUsagesFor(@NotNull PsiElement element) {
        return element instanceof XmlElementDecl || element instanceof XmlAttributeDecl || element instanceof XmlEntityDecl || element instanceof XmlTag || element instanceof XmlAttributeValue || element instanceof PsiFile || element instanceof XmlComment;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element instanceof XmlTag) {
            PsiMetaData metaData = ((XmlTag)element).getMetaData();
            if (metaData != null && metaData.getDeclaration() instanceof XmlTag) {
                return ((XmlTag)metaData.getDeclaration()).getName();
            }
            return LangBundle.message("xml.terms.xml.tag", new Object[0]);
        }
        if (element instanceof XmlElementDecl) {
            return LangBundle.message("xml.terms.tag", new Object[0]);
        }
        if (element instanceof XmlAttributeDecl) {
            return LangBundle.message("xml.terms.attribute", new Object[0]);
        }
        if (element instanceof XmlAttributeValue) {
            return LangBundle.message("xml.terms.attribute.value", new Object[0]);
        }
        if (element instanceof XmlEntityDecl) {
            return LangBundle.message("xml.terms.entity", new Object[0]);
        }
        if (element instanceof XmlAttribute) {
            return LangBundle.message("xml.terms.attribute", new Object[0]);
        }
        if (element instanceof XmlComment) {
            return LangBundle.message("xml.terms.variable", new Object[0]);
        }
        throw new IllegalArgumentException("Cannot get type for " + element);
    }

    public String getHelpId(@NotNull PsiElement element) {
        return "reference.dialogs.findUsages.other";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getName();
        }
        if (element instanceof XmlAttributeValue) {
            return ((XmlAttributeValue)element).getValue();
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return element.getText();
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            PsiMetaData metaData = xmlTag.getMetaData();
            String name = metaData != null ? DescriptiveNameUtil.getMetaDataName((PsiMetaData)metaData) : xmlTag.getName();
            String presentableName = metaData == null ? "<" + name + ">" : name;
            return presentableName + " of file " + xmlTag.getContainingFile().getName();
        }
        if (element instanceof XmlAttributeValue) {
            return ((XmlAttributeValue)element).getValue();
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return element.getText();
    }

    public WordsScanner getWordsScanner() {
        return null;
    }
}

