/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.pico.DefaultPicoContainer;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager {
    private final MessageBus myMessageBus = MessageBusFactory.newMessageBus((Object)((Object)this));
    private final MutablePicoContainer myPicoContainer;
    private final Map<Class, Object> myComponents = new HashMap<Class, Object>();
    private final Set<Object> myDisposableComponents = ContainerUtil.newConcurrentSet();
    private boolean myDisposed;

    public MockComponentManager(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        this.myPicoContainer = new DefaultPicoContainer(parent){

            @Nullable
            public Object getComponentInstance(Object componentKey) {
                if (MockComponentManager.this.myDisposed) {
                    throw new IllegalStateException("Cannot get " + componentKey + " from already disposed " + (Object)((Object)this));
                }
                Object o = super.getComponentInstance(componentKey);
                MockComponentManager.this.registerComponentInDisposer(o);
                return o;
            }
        };
        this.myPicoContainer.registerComponentInstance((Object)this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    private void registerComponentInDisposer(@Nullable Object o) {
        if (o instanceof Disposable && o != this && !(o instanceof MessageBus) && this.myDisposableComponents.add(o)) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)o));
        }
    }

    public BaseComponent getComponent(@NotNull String name) {
        return null;
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull Class<? extends T> serviceImplementation) {
        this.myPicoContainer.unregisterComponent((Object)serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation((Object)serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceImplementation) {
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        this.myPicoContainer.registerComponentInstance((Object)serviceInterface.getName(), serviceImplementation);
        this.registerComponentInDisposer(serviceImplementation);
    }

    public <T> void addComponent(@NotNull Class<T> interfaceClass, @NotNull T instance) {
        this.myComponents.put(interfaceClass, instance);
        this.registerComponentInDisposer(instance);
    }

    @Nullable
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        Object o = this.myPicoContainer.getComponentInstance(interfaceClass);
        return (T)(o != null ? o : this.myComponents.get(interfaceClass));
    }

    public <T> T getComponent(@NotNull Class<T> interfaceClass, T defaultImplementation) {
        return this.getComponent(interfaceClass);
    }

    public boolean hasComponent(@NotNull Class interfaceClass) {
        return false;
    }

    @NotNull
    public <T> T[] getComponents(@NotNull Class<T> baseClass) {
        List list2 = this.myPicoContainer.getComponentInstancesOfType(baseClass);
        return list2.toArray((Object[])Array.newInstance(baseClass, 0));
    }

    @NotNull
    public MutablePicoContainer getPicoContainer() {
        return this.myPicoContainer;
    }

    @NotNull
    public MessageBus getMessageBus() {
        return this.myMessageBus;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myMessageBus);
        this.myDisposed = true;
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        throw new UnsupportedOperationException("getExtensions()");
    }

    @NotNull
    public Condition<?> getDisposed() {
        return Conditions.alwaysFalse();
    }
}

