/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NotificationConfiguration", storages={@Storage(value="notifications.xml")})
public class NotificationsConfigurationImpl
extends NotificationsConfiguration
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(NotificationsConfiguration.class);
    private static final String SHOW_BALLOONS_ATTRIBUTE = "showBalloons";
    private static final String SYSTEM_NOTIFICATIONS_ATTRIBUTE = "systemNotifications";
    private static final Comparator<NotificationSettings> NOTIFICATION_SETTINGS_COMPARATOR = (o1, o2) -> o1.getGroupId().compareToIgnoreCase(o2.getGroupId());
    private final Map<String, NotificationSettings> myIdToSettingsMap = new THashMap();
    private final Map<String, String> myToolWindowCapable = new THashMap();
    public boolean SHOW_BALLOONS = true;
    public boolean SYSTEM_NOTIFICATIONS = true;

    public NotificationsConfigurationImpl(@NotNull MessageBus bus) {
        bus.connect((Disposable)this).subscribe(TOPIC, (Object)this);
    }

    public static NotificationsConfigurationImpl getInstanceImpl() {
        return (NotificationsConfigurationImpl)NotificationsConfigurationImpl.getNotificationsConfiguration();
    }

    public synchronized boolean hasToolWindowCapability(@NotNull String groupId) {
        return this.getToolWindowId(groupId) != null || this.myToolWindowCapable.containsKey(groupId);
    }

    @Nullable
    public String getToolWindowId(@NotNull String groupId) {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId);
        return group == null ? null : group.getToolWindowId();
    }

    public synchronized NotificationSettings[] getAllSettings() {
        THashSet settings = new THashSet(this.myIdToSettingsMap.values());
        for (NotificationGroup group : NotificationGroup.getAllRegisteredGroups()) {
            if (group.getDisplayId().startsWith("LIGHTWEIGHT")) continue;
            settings.add(NotificationsConfigurationImpl.getSettings(group.getDisplayId()));
        }
        NotificationSettings[] result2 = settings.toArray(new NotificationSettings[0]);
        Arrays.sort(result2, NOTIFICATION_SETTINGS_COMPARATOR);
        return result2;
    }

    public static void remove(String ... toRemove2) {
        NotificationsConfigurationImpl.getInstanceImpl().doRemove(toRemove2);
    }

    private synchronized void doRemove(String ... toRemove2) {
        for (String groupId : toRemove2) {
            this.myIdToSettingsMap.remove(groupId);
            this.myToolWindowCapable.remove(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NotificationSettings getSettings(@NotNull String groupId) {
        NotificationSettings settings;
        NotificationsConfigurationImpl impl;
        NotificationsConfigurationImpl notificationsConfigurationImpl = impl = NotificationsConfigurationImpl.getInstanceImpl();
        synchronized (notificationsConfigurationImpl) {
            settings = impl.myIdToSettingsMap.get(groupId);
        }
        return settings == null ? NotificationsConfigurationImpl.getDefaultSettings(groupId) : settings;
    }

    @NotNull
    private static NotificationSettings getDefaultSettings(String groupId) {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId);
        if (group != null) {
            return new NotificationSettings(groupId, group.getDisplayType(), group.isLogByDefault(), false);
        }
        return new NotificationSettings(groupId, NotificationDisplayType.BALLOON, true, false);
    }

    public synchronized void dispose() {
        this.myIdToSettingsMap.clear();
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType) {
        this.register(groupDisplayName, displayType, true);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog) {
        this.register(groupDisplayName, displayType, shouldLog, false);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        if (!this.isRegistered(groupDisplayName)) {
            new NotificationGroup(groupDisplayName, displayType, shouldLog);
            this.changeSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud);
        } else if (displayType == NotificationDisplayType.TOOL_WINDOW && !this.hasToolWindowCapability(groupDisplayName)) {
            this.changeSettings(NotificationsConfigurationImpl.getSettings(groupDisplayName).withDisplayType(NotificationDisplayType.TOOL_WINDOW));
            this.myToolWindowCapable.put(groupDisplayName, null);
        }
    }

    public void changeSettings(String groupDisplayName, NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        this.changeSettings(new NotificationSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud));
    }

    public synchronized void changeSettings(NotificationSettings settings) {
        String groupDisplayName = settings.getGroupId();
        if (settings.equals(NotificationsConfigurationImpl.getDefaultSettings(groupDisplayName))) {
            this.myIdToSettingsMap.remove(groupDisplayName);
        } else {
            this.myIdToSettingsMap.put(groupDisplayName, settings);
        }
    }

    public synchronized boolean isRegistered(@NotNull String id) {
        return this.myIdToSettingsMap.containsKey(id) || NotificationGroup.findRegisteredGroup((String)id) != null;
    }

    public synchronized Element getState() {
        Element element = new Element("NotificationsConfiguration");
        NotificationSettings[] sortedNotifications = this.myIdToSettingsMap.values().toArray(new NotificationSettings[0]);
        Arrays.sort(sortedNotifications, NOTIFICATION_SETTINGS_COMPARATOR);
        for (NotificationSettings settings : sortedNotifications) {
            element.addContent(settings.save());
        }
        if (!this.SHOW_BALLOONS) {
            element.setAttribute(SHOW_BALLOONS_ATTRIBUTE, "false");
        }
        if (!this.SYSTEM_NOTIFICATIONS) {
            element.setAttribute(SYSTEM_NOTIFICATIONS_ATTRIBUTE, "false");
        }
        return element;
    }

    public synchronized void loadState(@NotNull Element state) {
        this.myIdToSettingsMap.clear();
        for (Element child2 : state.getChildren("notification")) {
            NotificationSettings settings = NotificationSettings.load(child2);
            if (settings == null) continue;
            String id = settings.getGroupId();
            LOG.assertTrue(!this.myIdToSettingsMap.containsKey(id), (Object)String.format("Settings for '%s' already loaded!", id));
            this.myIdToSettingsMap.put(id, settings);
        }
        this.doRemove("Log Only");
        if ("false".equals(state.getAttributeValue(SHOW_BALLOONS_ATTRIBUTE))) {
            this.SHOW_BALLOONS = false;
        }
        if ("false".equals(state.getAttributeValue(SYSTEM_NOTIFICATIONS_ATTRIBUTE))) {
            this.SYSTEM_NOTIFICATIONS = false;
        }
    }
}

