/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.actionSystem.impl.Win10ActionButtonLook;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ActionButtonLook {
    public static final ActionButtonLook SYSTEM_LOOK = new ActionButtonLook(){
        private ActionButtonLook delegate;
        {
            this.updateUI();
        }

        @Override
        public void updateUI() {
            this.delegate = UIUtil.isUnderWin10LookAndFeel() ? new Win10ActionButtonLook() : new IdeaActionButtonLook();
        }

        @Override
        public void paintBackground(Graphics g, JComponent component, int state) {
            this.delegate.paintBackground(g, component, state);
        }

        @Override
        public void paintBackground(Graphics g, JComponent component, Color color) {
            this.delegate.paintBackground(g, component, color);
        }

        @Override
        public void paintBorder(Graphics g, JComponent component, int state) {
            this.delegate.paintBorder(g, component, state);
        }

        @Override
        public void paintBorder(Graphics g, JComponent component, Color color) {
            this.delegate.paintBorder(g, component, color);
        }

        @Override
        public void paintLookBackground(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
            this.delegate.paintLookBackground(g, rect, color);
        }

        @Override
        public void paintLookBorder(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
            this.delegate.paintLookBorder(g, rect, color);
        }
    };
    public static final ActionButtonLook INPLACE_LOOK = new ActionButtonLook(){

        @Override
        public void paintBackground(Graphics g, JComponent component, int state) {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component, int state) {
        }

        @Override
        public void paintBackground(Graphics g, JComponent component, Color color) {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component, Color color) {
        }
    };

    public <ButtonType extends JComponent> void paintBackground(Graphics g, ButtonType button2) {
        this.paintBackground(g, button2, this.getState((ActionButtonComponent)button2));
    }

    public <ButtonType extends JComponent> void paintBorder(Graphics g, ButtonType button2) {
        this.paintBorder(g, button2, this.getState((ActionButtonComponent)button2));
    }

    public void paintBackground(Graphics g, JComponent component, @ActionButtonComponent.ButtonState int state) {
        if (state != 0) {
            Rectangle rect = new Rectangle(component.getSize());
            Color color = state == -1 ? JBUI.CurrentTheme.ActionButton.pressedBackground() : JBUI.CurrentTheme.ActionButton.hoverBackground();
            this.paintLookBackground(g, rect, color);
        }
    }

    public void paintBackground(Graphics g, JComponent component, Color color) {
        Rectangle rect = new Rectangle(component.getSize());
        this.paintLookBackground(g, rect, color);
    }

    public void paintBorder(Graphics g, JComponent component, @ActionButtonComponent.ButtonState int state) {
        if (state != 0) {
            Rectangle rect = new Rectangle(component.getSize());
            Color color = state == -1 ? JBUI.CurrentTheme.ActionButton.pressedBorder() : JBUI.CurrentTheme.ActionButton.hoverBorder();
            this.paintLookBorder(g, rect, color);
        }
    }

    public void paintBorder(Graphics g, JComponent component, Color color) {
        Rectangle rect = new Rectangle(component.getSize());
        this.paintLookBorder(g, rect, color);
    }

    public void paintLookBackground(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
    }

    public void paintLookBorder(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
    }

    public void updateUI() {
    }

    @ActionButtonComponent.ButtonState
    protected int getState(ActionButtonComponent button2) {
        return button2.getPopState();
    }

    public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int x = (actionButton.getWidth() - width) / 2;
        int y = (actionButton.getHeight() - height) / 2;
        this.paintIconAt(g, icon, x, y);
    }

    public void paintIconAt(Graphics g, Icon icon, int x, int y) {
        icon.paintIcon(null, g, x, y);
    }
}

