/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.InvokeQuickListAction;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.BundledQuickListsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/actionSystem/ex/QuickListsManager;", "Lcom/intellij/openapi/components/BaseComponent;", "myActionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "schemeManagerFactory", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "(Lcom/intellij/openapi/actionSystem/ActionManager;Lcom/intellij/openapi/options/SchemeManagerFactory;)V", "allQuickLists", "", "Lcom/intellij/openapi/actionSystem/ex/QuickList;", "getAllQuickLists", "()[Lcom/intellij/openapi/actionSystem/ex/QuickList;", "mySchemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "schemeManager", "getSchemeManager", "()Lcom/intellij/openapi/options/SchemeManager;", "initComponent", "", "registerActions", "setQuickLists", "quickLists", "", "unregisterActions", "Companion", "intellij.platform.ide.impl"})
public final class QuickListsManager
implements BaseComponent {
    private final SchemeManager<QuickList> mySchemeManager;
    private final ActionManager myActionManager;
    public static final Companion Companion = new Companion(null);

    public void initComponent() {
        for (BundledQuickListsProvider provider : BundledQuickListsProvider.EP_NAME.getExtensionList()) {
            for (String path : provider.getBundledListsRelativePaths()) {
                this.mySchemeManager.loadBundledScheme(path, provider);
            }
        }
        this.mySchemeManager.loadSchemes();
        this.registerActions();
    }

    @NotNull
    public final SchemeManager<QuickList> getSchemeManager() {
        return this.mySchemeManager;
    }

    @NotNull
    public final QuickList[] getAllQuickLists() {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)this.mySchemeManager.getAllSchemes();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        QuickList[] quickListArray = thisCollection$iv.toArray(new QuickList[0]);
        if (quickListArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return quickListArray;
    }

    private final void registerActions() {
        THashSet registeredIds = new THashSet();
        for (QuickList scheme2 : this.mySchemeManager.getAllSchemes()) {
            String actionId = scheme2.getActionId();
            if (!registeredIds.add((Object)actionId)) continue;
            this.myActionManager.registerAction(actionId, (AnAction)new InvokeQuickListAction(scheme2));
        }
    }

    private final void unregisterActions() {
        for (String oldId : this.myActionManager.getActionIds("QuickList.")) {
            this.myActionManager.unregisterAction(oldId);
        }
    }

    public final void setQuickLists(@NotNull List<? extends QuickList> quickLists) {
        this.unregisterActions();
        SchemeManager.setSchemes$default(this.mySchemeManager, quickLists, null, null, 6, null);
        this.registerActions();
    }

    public QuickListsManager(@NotNull ActionManager myActionManager, @NotNull SchemeManagerFactory schemeManagerFactory) {
        this.myActionManager = myActionManager;
        this.mySchemeManager = SchemeManagerFactory.create$default(schemeManagerFactory, "quicklists", new LazySchemeProcessor<QuickList, QuickList>("display"){

            @Override
            @NotNull
            public QuickList createScheme(@NotNull SchemeDataHolder<? super QuickList> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider2, boolean isBundled) {
                QuickList item = new QuickList();
                item.readExternal(dataHolder.read());
                dataHolder.updateDigest(item);
                return item;
            }
        }, IdeBundle.message((String)"quick.lists.presentable.name", (Object[])new Object[0]), null, 8, null);
    }

    @NotNull
    public static final QuickListsManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/actionSystem/ex/QuickListsManager$Companion;", "", "()V", "instance", "Lcom/intellij/openapi/actionSystem/ex/QuickListsManager;", "instance$annotations", "getInstance", "()Lcom/intellij/openapi/actionSystem/ex/QuickListsManager;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void instance$annotations() {
        }

        @NotNull
        public final QuickListsManager getInstance() {
            return (QuickListsManager)ApplicationManager.getApplication().getComponent(QuickListsManager.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

