/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.AndroidStudioSystemHealthMonitorAdapter;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.IdeaLogger;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PreloadableAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.AbbreviationManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ButtonToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ChameleonAction;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actions.BackspaceAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionManagerImpl
extends ActionManagerEx
implements Disposable {
    private static final String ACTION_ELEMENT_NAME = "action";
    private static final String GROUP_ELEMENT_NAME = "group";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String ID_ATTR_NAME = "id";
    private static final String INTERNAL_ATTR_NAME = "internal";
    private static final String ICON_ATTR_NAME = "icon";
    private static final String ADD_TO_GROUP_ELEMENT_NAME = "add-to-group";
    private static final String SHORTCUT_ELEMENT_NAME = "keyboard-shortcut";
    private static final String MOUSE_SHORTCUT_ELEMENT_NAME = "mouse-shortcut";
    private static final String DESCRIPTION = "description";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String POPUP_ATTR_NAME = "popup";
    private static final String COMPACT_ATTR_NAME = "compact";
    private static final String SEPARATOR_ELEMENT_NAME = "separator";
    private static final String REFERENCE_ELEMENT_NAME = "reference";
    private static final String ABBREVIATION_ELEMENT_NAME = "abbreviation";
    private static final String GROUPID_ATTR_NAME = "group-id";
    private static final String ANCHOR_ELEMENT_NAME = "anchor";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String SECONDARY = "secondary";
    private static final String RELATIVE_TO_ACTION_ATTR_NAME = "relative-to-action";
    private static final String FIRST_KEYSTROKE_ATTR_NAME = "first-keystroke";
    private static final String SECOND_KEYSTROKE_ATTR_NAME = "second-keystroke";
    private static final String REMOVE_SHORTCUT_ATTR_NAME = "remove";
    private static final String REPLACE_SHORTCUT_ATTR_NAME = "replace-all";
    private static final String KEYMAP_ATTR_NAME = "keymap";
    private static final String KEYSTROKE_ATTR_NAME = "keystroke";
    private static final String REF_ATTR_NAME = "ref";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String ACTIONS_BUNDLE = "messages.ActionsBundle";
    private static final String USE_SHORTCUT_OF_ATTR_NAME = "use-shortcut-of";
    private static final String OVERRIDES_ATTR_NAME = "overrides";
    private static final String KEEP_CONTENT_ATTR_NAME = "keep-content";
    private static final String PROJECT_TYPE = "project-type";
    private static final String UNREGISTER_ELEMENT_NAME = "unregister";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.ActionManagerImpl");
    private static final int DEACTIVATED_TIMER_DELAY = 5000;
    private static final int TIMER_DELAY = 500;
    private static final int UPDATE_DELAY_AFTER_TYPING = 500;
    private final Object myLock = new Object();
    private final Map<String, AnAction> myId2Action = new THashMap();
    private final MultiMap<PluginId, String> myPlugin2Id = new MultiMap();
    private final TObjectIntHashMap<String> myId2Index = new TObjectIntHashMap();
    private final Map<Object, String> myAction2Id = new THashMap();
    private final MultiMap<String, String> myId2GroupId = new MultiMap();
    private final List<String> myNotRegisteredInternalActionIds = new ArrayList<String>();
    private final List<AnActionListener> myActionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ActionPopupMenuListener> myActionPopupMenuListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final KeymapManagerEx myKeymapManager;
    private final DataManager myDataManager;
    private final List<Object> myPopups = new ArrayList<Object>();
    private MyTimer myTimer;
    private int myRegisteredActionsCount;
    private String myLastPreformedActionId;
    private String myPrevPerformedActionId;
    private long myLastTimeEditorWasTypedIn;
    private boolean myTransparentOnlyUpdate;
    private final Map<OverridingAction, AnAction> myBaseActions = new HashMap<OverridingAction, AnAction>();
    private final AnActionListener messageBusPublisher;
    private int myAnonymousGroupIdCounter;
    private static final Map<Class<?>, Boolean> ourActionsExcludedFromTracking = new IdentityHashMap();

    ActionManagerImpl(@NotNull KeymapManager keymapManager2, DataManager dataManager, @NotNull MessageBus messageBus) {
        this.myKeymapManager = (KeymapManagerEx)keymapManager2;
        this.myDataManager = dataManager;
        this.registerPluginActions();
        this.messageBusPublisher = (AnActionListener)messageBus.syncPublisher(AnActionListener.TOPIC);
    }

    @Nullable
    static AnAction convertStub(ActionStub stub) {
        Object obj;
        String className = stub.getClassName();
        try {
            Class<?> aClass = Class.forName(className, true, stub.getLoader());
            obj = ReflectionUtil.newInstance(aClass);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Throwable)new PluginException(e, stub.getPluginId()));
            return null;
        }
        if (!(obj instanceof AnAction)) {
            LOG.error((Throwable)new PluginException("class with name '" + className + "' must be an instance of '" + AnAction.class.getName() + "'; got " + obj, stub.getPluginId()));
            return null;
        }
        AnAction anAction = (AnAction)obj;
        stub.initAction(anAction);
        String iconPath = stub.getIconPath();
        if (iconPath != null) {
            Class<?> actionClass = anAction.getClass();
            ActionManagerImpl.setIconFromClass(actionClass, actionClass.getClassLoader(), iconPath, anAction.getTemplatePresentation(), stub.getPluginId());
        }
        return anAction;
    }

    private static void processAbbreviationNode(Element e, String id) {
        String abbr = e.getAttributeValue(VALUE_ATTR_NAME);
        if (!StringUtil.isEmpty((String)abbr)) {
            AbbreviationManagerImpl abbreviationManager = (AbbreviationManagerImpl)AbbreviationManager.getInstance();
            abbreviationManager.register(abbr, id, true);
        }
    }

    @Nullable
    private static ResourceBundle getActionsResourceBundle(ClassLoader loader, IdeaPluginDescriptor plugin) {
        String resBundleName = plugin != null && !"com.intellij".equals(plugin.getPluginId().getIdString()) ? plugin.getResourceBundleBaseName() : ACTIONS_BUNDLE;
        ResourceBundle bundle = null;
        if (resBundleName != null) {
            bundle = AbstractBundle.getResourceBundle((String)resBundleName, (ClassLoader)loader);
        }
        return bundle;
    }

    private static boolean isSecondary(Element element) {
        return "true".equalsIgnoreCase(element.getAttributeValue(SECONDARY));
    }

    private static void setIcon(@Nullable String iconPath, @NotNull String className, @NotNull ClassLoader loader, @NotNull Presentation presentation, PluginId pluginId) {
        if (iconPath == null) {
            return;
        }
        try {
            Class<?> actionClass = Class.forName(className, true, loader);
            ActionManagerImpl.setIconFromClass(actionClass, loader, iconPath, presentation, pluginId);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.error(e);
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
        }
    }

    private static void setIconFromClass(final @NotNull Class actionClass, final @NotNull ClassLoader classLoader, final @NotNull String iconPath, @NotNull Presentation presentation, final PluginId pluginId) {
        IconLoader.LazyIcon lazyIcon = new IconLoader.LazyIcon(){

            protected Icon compute() {
                Icon icon = IconLoader.findIcon((String)iconPath, (Class)actionClass, (boolean)true, (boolean)false);
                if (icon == null) {
                    icon = IconLoader.findIcon((String)iconPath, (ClassLoader)classLoader);
                }
                if (icon == null) {
                    ActionManagerImpl.reportActionError(pluginId, "Icon cannot be found in '" + iconPath + "', action '" + actionClass + "'");
                }
                return icon;
            }

            public String toString() {
                return "LazyIcon@ActionManagerImpl (path: " + iconPath + ", action class: " + actionClass + ")";
            }
        };
        if (!Registry.is((String)"ide.lazyIconLoading")) {
            lazyIcon.load();
        }
        presentation.setIcon((Icon)lazyIcon);
    }

    private static String loadDescriptionForElement(Element element, ResourceBundle bundle, String id, String elementType) {
        String value = element.getAttributeValue(DESCRIPTION);
        if (bundle != null) {
            String key = elementType + "." + id + ".description";
            return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)key, (String)(value == null ? "" : value), (Object[])new Object[0]);
        }
        return value;
    }

    private static String loadTextForElement(Element element, ResourceBundle bundle, String id, String elementType) {
        String value = element.getAttributeValue(TEXT_ATTR_NAME);
        return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)(elementType + "." + id + "." + TEXT_ATTR_NAME), (String)(value == null ? "" : value), (Object[])new Object[0]);
    }

    private static boolean checkRelativeToAction(String relativeToActionId, @NotNull Anchor anchor2, @NotNull String actionName, @Nullable PluginId pluginId) {
        if ((Anchor.BEFORE == anchor2 || Anchor.AFTER == anchor2) && relativeToActionId == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": \"relative-to-action\" cannot be null if anchor is \"after\" or \"before\"");
            return false;
        }
        return true;
    }

    @Nullable
    private static Anchor parseAnchor(String anchorStr, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (anchorStr == null) {
            return Anchor.LAST;
        }
        if (FIRST.equalsIgnoreCase(anchorStr)) {
            return Anchor.FIRST;
        }
        if (LAST.equalsIgnoreCase(anchorStr)) {
            return Anchor.LAST;
        }
        if (BEFORE.equalsIgnoreCase(anchorStr)) {
            return Anchor.BEFORE;
        }
        if (AFTER.equalsIgnoreCase(anchorStr)) {
            return Anchor.AFTER;
        }
        ActionManagerImpl.reportActionError(pluginId, actionName + ": anchor should be one of the following constants: \"first\", \"last\", \"before\" or \"after\"");
        return null;
    }

    private void processMouseShortcutNode(Element element, String actionId, PluginId pluginId) {
        MouseShortcut shortcut;
        String keystrokeString = element.getAttributeValue(KEYSTROKE_ATTR_NAME);
        if (keystrokeString == null || keystrokeString.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        try {
            shortcut = KeymapUtil.parseMouseShortcut((String)keystrokeString);
        }
        catch (Exception ex) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = this.myKeymapManager.getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionError(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        ActionManagerImpl.processRemoveAndReplace(element, actionId, keymap, (Shortcut)shortcut);
    }

    private static void assertActionIsGroupOrStub(AnAction action) {
        if (!(action instanceof ActionGroup || action instanceof ActionStub || action instanceof ChameleonAction)) {
            LOG.error("Action : " + action + "; class: " + action.getClass());
        }
    }

    private static void reportActionError(PluginId pluginId, @NotNull String message) {
        ActionManagerImpl.reportActionError(pluginId, message, null);
    }

    private static void reportActionError(PluginId pluginId, @NotNull String message, @Nullable Throwable cause) {
        if (pluginId != null) {
            LOG.error((Throwable)new PluginException(message, cause, pluginId));
        } else if (cause != null) {
            LOG.error(message, cause);
        } else {
            LOG.error(message);
        }
    }

    private static void reportActionWarning(PluginId pluginId, @NotNull String message) {
        if (pluginId == null) {
            LOG.warn(message);
        } else {
            LOG.warn(new PluginException(message, null, pluginId).getMessage());
        }
    }

    private static String getPluginInfo(@Nullable PluginId id) {
        IdeaPluginDescriptor plugin;
        if (id != null && (plugin = PluginManager.getPlugin(id)) != null) {
            String name = plugin.getName();
            if (name == null) {
                name = id.getIdString();
            }
            return " Plugin: " + name;
        }
        return "";
    }

    @NotNull
    private static DataContext getContextBy(Component contextComponent) {
        DataManager dataManager = DataManager.getInstance();
        return contextComponent != null ? dataManager.getDataContext(contextComponent) : dataManager.getDataContext();
    }

    public void dispose() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    public void addTimerListener(int delay, @NotNull TimerListener listener2) {
        this._addTimerListener(listener2, false);
    }

    public void removeTimerListener(@NotNull TimerListener listener2) {
        this._removeTimerListener(listener2, false);
    }

    public void addTransparentTimerListener(int delay, @NotNull TimerListener listener2) {
        this._addTimerListener(listener2, true);
    }

    public void removeTransparentTimerListener(@NotNull TimerListener listener2) {
        this._removeTimerListener(listener2, true);
    }

    private void _addTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myTimer == null) {
            this.myTimer = new MyTimer();
            this.myTimer.start();
        }
        this.myTimer.addTimerListener(listener2, transparent);
    }

    private void _removeTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (LOG.assertTrue(this.myTimer != null)) {
            this.myTimer.removeTimerListener(listener2, transparent);
        }
    }

    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group, @Nullable PresentationFactory presentationFactory) {
        return new ActionPopupMenuImpl(place, group, this, presentationFactory);
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group) {
        return new ActionPopupMenuImpl(place, group, this, null);
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group, boolean horizontal) {
        return this.createActionToolbar(place, group, horizontal, false);
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group, boolean horizontal, boolean decorateButtons) {
        return new ActionToolbarImpl(place, group, horizontal, decorateButtons, this.myDataManager, this, this.myKeymapManager);
    }

    private void registerPluginActions() {
        List<IdeaPluginDescriptor> plugins2 = PluginManagerCore.getLoadedPlugins(null);
        for (IdeaPluginDescriptor plugin : plugins2) {
            List elementList = plugin.getActionsDescriptionElements();
            if (elementList == null) continue;
            for (Element e : elementList) {
                this.processActionsChildElement(plugin.getPluginClassLoader(), plugin.getPluginId(), e);
            }
        }
    }

    @Nullable
    public AnAction getAction(@NotNull String id) {
        return this.getActionImpl(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AnAction getActionImpl(@NotNull String id, boolean canReturnStub) {
        AnAction action;
        Object object = this.myLock;
        synchronized (object) {
            action = this.myId2Action.get(id);
            if (canReturnStub || !(action instanceof ActionStub)) {
                return action;
            }
        }
        AnAction converted = ActionManagerImpl.convertStub((ActionStub)action);
        if (converted == null) {
            this.unregisterAction(id);
            return null;
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            action = this.myId2Action.get(id);
            if (action instanceof ActionStub) {
                action = this.replaceStub((ActionStub)action, converted);
            }
            return action;
        }
    }

    @NotNull
    private AnAction replaceStub(@NotNull ActionStub stub, AnAction anAction) {
        LOG.assertTrue(this.myAction2Id.containsKey(stub));
        this.myAction2Id.remove(stub);
        LOG.assertTrue(this.myId2Action.containsKey(stub.getId()));
        AnAction action = this.myId2Action.remove(stub.getId());
        LOG.assertTrue(action != null);
        LOG.assertTrue(action.equals(stub));
        this.myAction2Id.put(anAction, stub.getId());
        return this.addToMap(stub.getId(), anAction, stub.getPluginId(), stub.getProjectType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(@NotNull AnAction action) {
        if (action instanceof ActionStub) {
            return ((ActionStub)action).getId();
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myAction2Id.get(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String[] getActionIds(@NotNull String idPrefix) {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<String> idList = new ArrayList<String>();
            for (String id : this.myId2Action.keySet()) {
                if (!id.startsWith(idPrefix)) continue;
                idList.add(id);
            }
            return ArrayUtil.toStringArray(idList);
        }
    }

    public boolean isGroup(@NotNull String actionId) {
        return this.getActionImpl(actionId, true) instanceof ActionGroup;
    }

    @NotNull
    public JComponent createButtonToolbar(@NotNull String actionPlace, @NotNull ActionGroup messageActionGroup) {
        return new ButtonToolbarImpl(actionPlace, messageActionGroup, this.myDataManager, this);
    }

    public AnAction getActionOrStub(@NotNull String id) {
        return this.getActionImpl(id, true);
    }

    @Nullable
    private AnAction processActionElement(Element element, ClassLoader loader, PluginId pluginId) {
        String className = element.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null || className.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "action element should have specified \"class\" attribute");
            return null;
        }
        String id = ActionManagerImpl.obtainActionId(element, className);
        if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
            this.myNotRegisteredInternalActionIds.add(id);
            return null;
        }
        String iconPath = element.getAttributeValue(ICON_ATTR_NAME);
        String projectType = element.getAttributeValue(PROJECT_TYPE);
        ActionStub stub = new ActionStub(className, id, loader, pluginId, iconPath, projectType, () -> {
            IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
            ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
            String text = ActionManagerImpl.loadTextForElement(element, bundle, id, ACTION_ELEMENT_NAME);
            if (text == null) {
                ActionManagerImpl.reportActionError(pluginId, "'text' attribute is mandatory (action ID=" + id + ";" + (plugin == null ? "" : " plugin path: " + plugin.getPath()) + ")");
            }
            Presentation presentation = new Presentation();
            presentation.setText(text);
            presentation.setDescription(ActionManagerImpl.loadDescriptionForElement(element, bundle, id, ACTION_ELEMENT_NAME));
            return presentation;
        });
        for (Element e : element.getChildren()) {
            if (ADD_TO_GROUP_ELEMENT_NAME.equals(e.getName())) {
                this.processAddToGroupNode((AnAction)stub, e, pluginId, ActionManagerImpl.isSecondary(e));
                continue;
            }
            if (SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                this.processKeyboardShortcutNode(e, id, pluginId);
                continue;
            }
            if (MOUSE_SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                this.processMouseShortcutNode(e, id, pluginId);
                continue;
            }
            if (ABBREVIATION_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processAbbreviationNode(e, id);
                continue;
            }
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + e.getName() + "\"");
            return null;
        }
        if (element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME) != null) {
            this.myKeymapManager.bindShortcuts(element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME), id);
        }
        this.registerOrReplaceActionInner(element, id, (AnAction)stub, pluginId);
        return stub;
    }

    private static String obtainActionId(Element element, String className) {
        String id = element.getAttributeValue(ID_ATTR_NAME);
        return StringUtil.isEmpty((String)id) ? StringUtil.getShortName((String)className) : id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOrReplaceActionInner(@NotNull Element element, @NotNull String id, @NotNull AnAction action, @Nullable PluginId pluginId) {
        Object object = this.myLock;
        synchronized (object) {
            if (Boolean.valueOf(element.getAttributeValue(OVERRIDES_ATTR_NAME)).booleanValue()) {
                if (this.getActionOrStub(id) == null) {
                    throw new RuntimeException(element.getName() + " '" + id + "' doesn't override anything");
                }
                AnAction prev2 = this.replaceAction(id, action, pluginId);
                if (action instanceof DefaultActionGroup && prev2 instanceof DefaultActionGroup && Boolean.valueOf(element.getAttributeValue(KEEP_CONTENT_ATTR_NAME)).booleanValue()) {
                    ((DefaultActionGroup)action).copyFromGroup((DefaultActionGroup)prev2);
                }
            } else {
                this.registerAction(id, action, pluginId, element.getAttributeValue(PROJECT_TYPE));
            }
        }
    }

    private AnAction processGroupElement(Element element, ClassLoader loader, PluginId pluginId) {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
        if (!GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String className = element.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null) {
            className = "true".equals(element.getAttributeValue(COMPACT_ATTR_NAME)) ? DefaultCompactActionGroup.class.getName() : DefaultActionGroup.class.getName();
        }
        try {
            String description;
            DefaultActionGroup group;
            boolean customClass = false;
            if (DefaultActionGroup.class.getName().equals(className)) {
                group = new DefaultActionGroup();
            } else if (DefaultCompactActionGroup.class.getName().equals(className)) {
                group = new DefaultCompactActionGroup();
            } else {
                Class<?> aClass = Class.forName(className, true, loader);
                Object obj = new CachingConstructorInjectionComponentAdapter((Object)className, aClass).getComponentInstance(ApplicationManager.getApplication().getPicoContainer());
                if (!(obj instanceof ActionGroup)) {
                    ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + ActionGroup.class.getName());
                    return null;
                }
                if (element.getChildren().size() != element.getChildren(ADD_TO_GROUP_ELEMENT_NAME).size() && !(obj instanceof DefaultActionGroup)) {
                    ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + DefaultActionGroup.class.getName() + " because there are children specified");
                    return null;
                }
                customClass = true;
                group = (ActionGroup)obj;
            }
            String id = element.getAttributeValue(ID_ATTR_NAME);
            if (id != null && id.isEmpty()) {
                ActionManagerImpl.reportActionError(pluginId, "ID of the group cannot be an empty string");
                return null;
            }
            if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
                this.myNotRegisteredInternalActionIds.add(id);
                return null;
            }
            if (id == null) {
                id = "<anonymous-group-" + this.myAnonymousGroupIdCounter++ + ">";
            }
            this.registerOrReplaceActionInner(element, id, (AnAction)group, pluginId);
            Presentation presentation = group.getTemplatePresentation();
            String text = ActionManagerImpl.loadTextForElement(element, bundle, id, GROUP_ELEMENT_NAME);
            if (!StringUtil.isEmpty((String)text) || presentation.getText() == null) {
                presentation.setText(text);
            }
            if (!StringUtil.isEmpty((String)(description = ActionManagerImpl.loadDescriptionForElement(element, bundle, id, GROUP_ELEMENT_NAME))) || presentation.getDescription() == null) {
                presentation.setDescription(description);
            }
            ActionManagerImpl.setIcon(element.getAttributeValue(ICON_ATTR_NAME), className, loader, presentation, pluginId);
            String popup2 = element.getAttributeValue(POPUP_ATTR_NAME);
            if (popup2 != null) {
                group.setPopup(Boolean.valueOf(popup2).booleanValue());
            }
            if (customClass && element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME) != null) {
                this.myKeymapManager.bindShortcuts(element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME), id);
            }
            for (Element child2 : element.getChildren()) {
                AnAction action;
                String name = child2.getName();
                if (ACTION_ELEMENT_NAME.equals(name)) {
                    action = this.processActionElement(child2, loader, pluginId);
                    if (action == null) continue;
                    ActionManagerImpl.assertActionIsGroupOrStub(action);
                    this.addToGroupInner((AnAction)group, action, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (SEPARATOR_ELEMENT_NAME.equals(name)) {
                    this.processSeparatorNode(group, child2, pluginId);
                    continue;
                }
                if (GROUP_ELEMENT_NAME.equals(name)) {
                    action = this.processGroupElement(child2, loader, pluginId);
                    if (action == null) continue;
                    this.addToGroupInner((AnAction)group, action, Constraints.LAST, false);
                    continue;
                }
                if (ADD_TO_GROUP_ELEMENT_NAME.equals(name)) {
                    this.processAddToGroupNode((AnAction)group, child2, pluginId, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (REFERENCE_ELEMENT_NAME.equals(name)) {
                    action = this.processReferenceElement(child2, pluginId);
                    if (action == null) continue;
                    this.addToGroupInner((AnAction)group, action, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
                return null;
            }
            return group;
        }
        catch (Exception e) {
            String message = "cannot create class \"" + className + "\"";
            ActionManagerImpl.reportActionError(pluginId, message, e);
            return null;
        }
    }

    private void processReferenceNode(Element element, PluginId pluginId) {
        AnAction action = this.processReferenceElement(element, pluginId);
        if (action == null) {
            return;
        }
        for (Element child2 : element.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) continue;
            this.processAddToGroupNode(action, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    private void processAddToGroupNode(AnAction action, Element element, PluginId pluginId, boolean secondary) {
        if (!(action instanceof Separator)) {
            ActionManagerImpl.assertActionIsGroupOrStub(action);
        }
        String actionName = String.format("%s (%s)", action instanceof ActionStub ? ((ActionStub)action).getClassName() : action.getClass().getName(), action instanceof ActionStub ? ((ActionStub)action).getId() : this.myAction2Id.get(action));
        if (!ADD_TO_GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        AnAction parentGroup = this.getParentGroup(element.getAttributeValue(GROUPID_ATTR_NAME), actionName, pluginId);
        if (parentGroup == null) {
            return;
        }
        Anchor anchor2 = ActionManagerImpl.parseAnchor(element.getAttributeValue(ANCHOR_ELEMENT_NAME), actionName, pluginId);
        if (anchor2 == null) {
            return;
        }
        String relativeToActionId = element.getAttributeValue(RELATIVE_TO_ACTION_ATTR_NAME);
        if (!ActionManagerImpl.checkRelativeToAction(relativeToActionId, anchor2, actionName, pluginId)) {
            return;
        }
        this.addToGroupInner(parentGroup, action, new Constraints(anchor2, relativeToActionId), secondary);
    }

    private void addToGroupInner(AnAction group, AnAction action, Constraints constraints, boolean secondary) {
        String actionId = action instanceof ActionStub ? ((ActionStub)action).getId() : this.myAction2Id.get(action);
        ((DefaultActionGroup)group).addAction(action, constraints, (ActionManager)this).setAsSecondary(secondary);
        this.myId2GroupId.putValue((Object)actionId, (Object)this.myAction2Id.get(group));
    }

    @Nullable
    public AnAction getParentGroup(String groupId, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (groupId == null || groupId.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"group-id\" should be defined");
            return null;
        }
        AnAction parentGroup = this.getActionImpl(groupId, true);
        if (parentGroup == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId + "\" isn't registered; action will be added to the \"Other\" group");
            parentGroup = this.getActionImpl("OtherMenu", true);
        }
        if (!(parentGroup instanceof DefaultActionGroup)) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId + "\" should be instance of " + DefaultActionGroup.class.getName() + " but was " + parentGroup.getClass());
            return null;
        }
        return parentGroup;
    }

    private void processSeparatorNode(@Nullable DefaultActionGroup parentGroup, Element element, PluginId pluginId) {
        Separator separator;
        if (!SEPARATOR_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        String text = element.getAttributeValue(TEXT_ATTR_NAME);
        Separator separator2 = separator = text != null ? new Separator(text) : Separator.getInstance();
        if (parentGroup != null) {
            parentGroup.add((AnAction)separator, (ActionManager)this);
        }
        for (Element child2 : element.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) continue;
            this.processAddToGroupNode((AnAction)separator, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    private void processUnregisterNode(Element element, PluginId pluginId) {
        String id = element.getAttributeValue(ID_ATTR_NAME);
        if (id == null) {
            ActionManagerImpl.reportActionError(pluginId, "'id' attribute is required for 'unregister' elements");
            return;
        }
        AnAction action = this.getAction(id);
        if (action == null) {
            ActionManagerImpl.reportActionError(pluginId, "Trying to unregister non-existing action " + id);
            return;
        }
        AbbreviationManager.getInstance().removeAllAbbreviations(id);
        for (AnAction anAction : this.myId2Action.values()) {
            if (!(anAction instanceof DefaultActionGroup)) continue;
            ((DefaultActionGroup)anAction).remove(action, id);
        }
        this.unregisterAction(id);
    }

    private void processKeyboardShortcutNode(Element element, String actionId, PluginId pluginId) {
        String firstStrokeString = element.getAttributeValue(FIRST_KEYSTROKE_ATTR_NAME);
        if (firstStrokeString == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        KeyStroke firstKeyStroke = ActionManagerImpl.getKeyStroke((String)firstStrokeString);
        if (firstKeyStroke == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = element.getAttributeValue(SECOND_KEYSTROKE_ATTR_NAME);
        if (secondStrokeString != null && (secondKeyStroke = ActionManagerImpl.getKeyStroke((String)secondStrokeString)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = this.myKeymapManager.getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionWarning(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        KeyboardShortcut shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
        ActionManagerImpl.processRemoveAndReplace(element, actionId, keymap, (Shortcut)shortcut);
    }

    private static void processRemoveAndReplace(@NotNull Element element, String actionId, @NotNull Keymap keymap, @NotNull Shortcut shortcut) {
        boolean remove = Boolean.parseBoolean(element.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME));
        boolean replace = Boolean.parseBoolean(element.getAttributeValue(REPLACE_SHORTCUT_ATTR_NAME));
        if (remove) {
            keymap.removeShortcut(actionId, shortcut);
        }
        if (replace) {
            keymap.removeAllActionShortcuts(actionId);
        }
        if (!remove) {
            keymap.addShortcut(actionId, shortcut);
        }
    }

    @Nullable
    private AnAction processReferenceElement(Element element, PluginId pluginId) {
        if (!REFERENCE_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String ref = element.getAttributeValue(REF_ATTR_NAME);
        if (ref == null) {
            ref = element.getAttributeValue(ID_ATTR_NAME);
        }
        if (ref == null || ref.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "ID of reference element should be defined");
            return null;
        }
        AnAction action = this.getActionImpl(ref, true);
        if (action == null) {
            if (!this.myNotRegisteredInternalActionIds.contains(ref)) {
                ActionManagerImpl.reportActionError(pluginId, "action specified by reference isn't registered (ID=" + ref + ")");
            }
            return null;
        }
        ActionManagerImpl.assertActionIsGroupOrStub(action);
        return action;
    }

    private void processActionsChildElement(ClassLoader loader, PluginId pluginId, Element child2) {
        String name = child2.getName();
        if (ACTION_ELEMENT_NAME.equals(name)) {
            AnAction action = this.processActionElement(child2, loader, pluginId);
            if (action != null) {
                ActionManagerImpl.assertActionIsGroupOrStub(action);
            }
        } else if (GROUP_ELEMENT_NAME.equals(name)) {
            this.processGroupElement(child2, loader, pluginId);
        } else if (SEPARATOR_ELEMENT_NAME.equals(name)) {
            this.processSeparatorNode(null, child2, pluginId);
        } else if (REFERENCE_ELEMENT_NAME.equals(name)) {
            this.processReferenceNode(child2, pluginId);
        } else if (UNREGISTER_ELEMENT_NAME.equals(name)) {
            this.processUnregisterNode(child2, pluginId);
        } else {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
        }
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action, @Nullable PluginId pluginId) {
        this.registerAction(actionId, action, pluginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAction(@NotNull String actionId, @NotNull AnAction action, @Nullable PluginId pluginId, @Nullable String projectType) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.addToMap(actionId, action, pluginId, projectType) == null) {
                return;
            }
            if (this.myAction2Id.containsKey(action)) {
                ActionManagerImpl.reportActionError(pluginId, "action was already registered for another ID. ID is " + this.myAction2Id.get(action) + ActionManagerImpl.getPluginInfo(pluginId));
                return;
            }
            this.myId2Index.put((Object)actionId, this.myRegisteredActionsCount++);
            this.myAction2Id.put(action, actionId);
            if (pluginId != null && !(action instanceof ActionGroup)) {
                this.myPlugin2Id.putValue((Object)pluginId, (Object)actionId);
            }
            action.registerCustomShortcutSet((ShortcutSet)new ProxyShortcutSet(actionId, this.myKeymapManager), null);
        }
    }

    private AnAction addToMap(String actionId, AnAction action, PluginId pluginId, String projectType) {
        if (projectType != null || this.myId2Action.containsKey(actionId)) {
            return this.registerChameleon(actionId, action, pluginId, projectType);
        }
        this.myId2Action.put(actionId, action);
        return action;
    }

    private AnAction registerChameleon(String actionId, AnAction action, PluginId pluginId, String projectType) {
        ChameleonAction chameleonAction;
        ProjectType type = projectType == null ? null : new ProjectType(projectType);
        AnAction o = this.myId2Action.get(actionId);
        if (o == null) {
            ChameleonAction chameleonAction2 = new ChameleonAction(action, type);
            this.myId2Action.put(actionId, chameleonAction2);
            return chameleonAction2;
        }
        if (o instanceof ChameleonAction) {
            chameleonAction = (ChameleonAction)o;
        } else {
            chameleonAction = new ChameleonAction(o, type);
            this.myId2Action.put(actionId, chameleonAction);
        }
        AnAction old = chameleonAction.addAction(action, type);
        if (old != null) {
            ActionManagerImpl.reportActionError(pluginId, "action with the ID \"" + actionId + "\" was already registered. Action being registered is " + action + "; Registered action is " + this.myId2Action.get(actionId) + ActionManagerImpl.getPluginInfo(pluginId));
            return null;
        }
        return chameleonAction;
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action) {
        this.registerAction(actionId, action, null);
    }

    public void unregisterAction(@NotNull String actionId) {
        this.unregisterAction(actionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAction(@NotNull String actionId, boolean removeFromGroups) {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myId2Action.containsKey(actionId) && LOG.isDebugEnabled()) {
                LOG.debug("action with ID " + actionId + " wasn't registered");
                return;
            }
            AnAction oldValue = this.myId2Action.remove(actionId);
            this.myAction2Id.remove(oldValue);
            this.myId2Index.remove((Object)actionId);
            for (Map.Entry entry : this.myPlugin2Id.entrySet()) {
                Collection pluginActions = (Collection)entry.getValue();
                pluginActions.remove(actionId);
            }
            if (removeFromGroups) {
                for (String groupId : this.myId2GroupId.get((Object)actionId)) {
                    DefaultActionGroup group = (DefaultActionGroup)ObjectUtils.assertNotNull((Object)((DefaultActionGroup)this.getActionOrStub(groupId)));
                    group.remove(oldValue, actionId);
                }
            }
            if (oldValue instanceof ActionGroup) {
                this.myId2GroupId.values().remove(actionId);
            }
        }
    }

    @NotNull
    public Comparator<String> getRegistrationOrderComparator() {
        return Comparator.comparingInt(arg_0 -> this.myId2Index.get(arg_0));
    }

    @NotNull
    public String[] getPluginActions(@NotNull PluginId pluginName) {
        return ArrayUtilRt.toStringArray((Collection)this.myPlugin2Id.get((Object)pluginName));
    }

    public void addActionPopup(Object menu2) {
        boolean added = this.myPopups.add(menu2);
        if (added && menu2 instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuCreated((ActionPopupMenu)menu2);
            }
        }
    }

    void removeActionPopup(Object menu2) {
        boolean removed = this.myPopups.remove(menu2);
        if (removed && menu2 instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuReleased((ActionPopupMenu)menu2);
            }
        }
    }

    public void queueActionPerformedEvent(@NotNull AnAction action, @NotNull DataContext context, @NotNull AnActionEvent event) {
        if (this.myPopups.isEmpty()) {
            this.fireAfterActionPerformed(action, context, event);
        }
    }

    public boolean isToolWindowContextMenuVisible() {
        for (Object popup2 : this.myPopups) {
            if (!(popup2 instanceof ActionPopupMenuImpl) || !((ActionPopupMenuImpl)popup2).isToolWindowContextMenu()) continue;
            return true;
        }
        return false;
    }

    public boolean isActionPopupStackEmpty() {
        return this.myPopups.isEmpty();
    }

    public boolean isTransparentOnlyActionsUpdateNow() {
        return this.myTransparentOnlyUpdate;
    }

    public void addActionPopupMenuListener(@NotNull ActionPopupMenuListener listener2, @NotNull Disposable parentDisposable) {
        this.myActionPopupMenuListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myActionPopupMenuListeners.remove(listener2));
    }

    public void replaceAction(@NotNull String actionId, @NotNull AnAction newAction) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        PluginId pluginId = callerClass != null ? PluginManagerCore.getPluginByClassName(callerClass.getName()) : null;
        this.replaceAction(actionId, newAction, pluginId);
    }

    private AnAction replaceAction(@NotNull String actionId, @NotNull AnAction newAction, @Nullable PluginId pluginId) {
        AnAction oldAction;
        AnAction anAction = oldAction = newAction instanceof OverridingAction ? this.getAction(actionId) : this.getActionOrStub(actionId);
        if (oldAction != null) {
            boolean isGroup;
            if (newAction instanceof OverridingAction) {
                this.myBaseActions.put((OverridingAction)newAction, oldAction);
            }
            if ((isGroup = oldAction instanceof ActionGroup) != newAction instanceof ActionGroup) {
                throw new IllegalStateException("cannot replace a group with an action and vice versa: " + actionId);
            }
            for (String groupId : this.myId2GroupId.get((Object)actionId)) {
                DefaultActionGroup group = (DefaultActionGroup)this.getActionOrStub(groupId);
                if (group == null) {
                    throw new IllegalStateException("Trying to replace action which has been added to a non-existing group " + groupId);
                }
                group.replaceAction(oldAction, newAction);
            }
            this.unregisterAction(actionId, false);
        }
        this.registerAction(actionId, newAction, pluginId);
        return oldAction;
    }

    public AnAction getBaseAction(OverridingAction overridingAction) {
        return this.myBaseActions.get(overridingAction);
    }

    public void addAnActionListener(AnActionListener listener2) {
        this.myActionListeners.add(listener2);
    }

    public void removeAnActionListener(AnActionListener listener2) {
        this.myActionListeners.remove(listener2);
    }

    public void fireBeforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (!ourActionsExcludedFromTracking.containsKey(action.getClass())) {
            AndroidStudioSystemHealthMonitorAdapter.countActionInvocation(action.getClass(), action.getTemplatePresentation(), event);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        this.myLastPreformedActionId = this.getId(action);
        if (this.myLastPreformedActionId == null && action instanceof ActionIdProvider) {
            this.myLastPreformedActionId = ((ActionIdProvider)action).getId();
        }
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId;
        ActionsCollector.getInstance().record((Project)CommonDataKeys.PROJECT.getData(dataContext), action, event);
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeActionPerformed(action, dataContext, event);
        }
        this.messageBusPublisher.beforeActionPerformed(action, dataContext, event);
    }

    public void fireAfterActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action);
        for (AnActionListener listener2 : this.myActionListeners) {
            try {
                listener2.afterActionPerformed(action, dataContext, event);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        this.messageBusPublisher.afterActionPerformed(action, dataContext, event);
    }

    public KeyboardShortcut getKeyboardShortcut(@NotNull String actionId) {
        Shortcut[] shortcuts;
        AnAction action = ActionManager.getInstance().getAction(actionId);
        ShortcutSet shortcutSet = action.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyboardShortcut kb;
            if (!(shortcut instanceof KeyboardShortcut) || (kb = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            return (KeyboardShortcut)shortcut;
        }
        return null;
    }

    public void fireBeforeEditorTyping(char c, @NotNull DataContext dataContext) {
        this.myLastTimeEditorWasTypedIn = System.currentTimeMillis();
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeEditorTyping(c, dataContext);
        }
        this.messageBusPublisher.beforeEditorTyping(c, dataContext);
    }

    public String getLastPreformedActionId() {
        return this.myLastPreformedActionId;
    }

    public String getPrevPreformedActionId() {
        return this.myPrevPerformedActionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getActionIds() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashSet<String>(this.myId2Action.keySet());
        }
    }

    public void preloadActions(ProgressIndicator indicator) {
        Application application = ApplicationManager.getApplication();
        for (String id : this.getActionIds()) {
            indicator.checkCanceled();
            if (application.isDisposeInProgress() || application.isDisposed()) {
                return;
            }
            AnAction action = this.getAction(id);
            if (!(action instanceof PreloadableAction)) continue;
            ((PreloadableAction)action).preload();
        }
    }

    @NotNull
    public ActionCallback tryToExecute(@NotNull AnAction action, @NotNull InputEvent inputEvent, @Nullable Component contextComponent, @Nullable String place, boolean now) {
        Application app = ApplicationManager.getApplication();
        assert (app.isDispatchThread());
        ActionCallback result2 = new ActionCallback();
        Runnable doRunnable = () -> this.tryToExecuteNow(action, inputEvent, contextComponent, place, result2);
        if (now) {
            doRunnable.run();
        } else {
            SwingUtilities.invokeLater(doRunnable);
        }
        return result2;
    }

    private void tryToExecuteNow(@NotNull AnAction action, InputEvent inputEvent, Component contextComponent, String place, ActionCallback result2) {
        Presentation presentation = action.getTemplatePresentation().clone();
        IdeFocusManager.findInstanceByContext((DataContext)ActionManagerImpl.getContextBy(contextComponent)).doWhenFocusSettlesDown(() -> ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> {
            DataContext context = ActionManagerImpl.getContextBy(contextComponent);
            AnActionEvent event = new AnActionEvent(inputEvent, context, place != null ? place : "unknown", presentation, (ActionManager)this, inputEvent.getModifiersEx());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
            if (component != null && !component.isShowing() && !"TouchBarGeneral".equals(place)) {
                result2.setRejected();
                return;
            }
            this.fireBeforeActionPerformed(action, context, event);
            UIUtil.addAwtListener(event1 -> {
                if (!(event1.getID() != 200 && event1.getID() != 205 || result2.isProcessed())) {
                    WindowEvent we = (WindowEvent)event1;
                    IdeFocusManager.findInstanceByComponent((Component)we.getWindow()).doWhenFocusSettlesDown(result2.createSetDoneRunnable(), ModalityState.defaultModalityState());
                }
            }, (long)64L, (Disposable)result2);
            ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
            result2.setDone();
            this.queueActionPerformedEvent(action, context, event);
        }), ModalityState.defaultModalityState());
    }

    static {
        ourActionsExcludedFromTracking.put(BackspaceAction.class, Boolean.TRUE);
    }

    private class MyTimer
    extends Timer
    implements ActionListener {
        private final List<TimerListener> myTimerListeners;
        private final List<TimerListener> myTransparentTimerListeners;
        private int myLastTimePerformed;

        private MyTimer() {
            super(500, null);
            this.myTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.myTransparentTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.addActionListener(this);
            this.setRepeats(true);
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    MyTimer.this.setDelay(500);
                    MyTimer.this.restart();
                }

                public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                    MyTimer.this.setDelay(5000);
                }
            });
        }

        public String toString() {
            return "Action manager timer";
        }

        void addTimerListener(@NotNull TimerListener listener2, boolean transparent) {
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).add(listener2);
        }

        void removeTimerListener(@NotNull TimerListener listener2, boolean transparent) {
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).remove(listener2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionManagerImpl.this.myLastTimeEditorWasTypedIn + 500L > System.currentTimeMillis()) {
                return;
            }
            int lastEventCount = this.myLastTimePerformed;
            this.myLastTimePerformed = ActivityTracker.getInstance().getCount();
            if (this.myLastTimePerformed == lastEventCount && !Registry.is((String)"actionSystem.always.update.toolbar.actions")) {
                return;
            }
            boolean transparentOnly = this.myLastTimePerformed == lastEventCount;
            try {
                ActionManagerImpl.this.myTransparentOnlyUpdate = transparentOnly;
                HashSet notified = new HashSet();
                this.notifyListeners(this.myTransparentTimerListeners, notified);
                if (transparentOnly) {
                    return;
                }
                this.notifyListeners(this.myTimerListeners, notified);
            }
            finally {
                ActionManagerImpl.this.myTransparentOnlyUpdate = false;
            }
        }

        private void notifyListeners(List<? extends TimerListener> timerListeners, Set<? super TimerListener> notified) {
            for (TimerListener timerListener : timerListeners) {
                if (!notified.add((TimerListener)timerListener)) continue;
                this.runListenerAction(timerListener);
            }
        }

        private void runListenerAction(@NotNull TimerListener listener2) {
            ModalityState modalityState = listener2.getModalityState();
            if (modalityState == null) {
                return;
            }
            LOG.debug("notify ", new Object[]{listener2});
            if (!ModalityState.current().dominates(modalityState)) {
                try {
                    listener2.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }
}

