/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ActionMenuItemUpdateCollector", storages={@Storage(value="menu.item.text.update.xml", roamingType=RoamingType.DISABLED)})
public class ActionMenuItemUpdateCollector
implements PersistentStateComponent<State> {
    private State state = new State();
    private final Map<String, Map<String, Integer>> myLocalState = new HashMap<String, Map<String, Integer>>();

    public <T> void record(@NotNull AnAction action, @NotNull String place, @NotNull String sourceKey) {
        String actionId = ActionManager.getInstance().getId(action);
        State state = this.getState();
        if (state == null) {
            return;
        }
        String key = ConvertUsagesUtil.escapeDescriptorName(place) + "@" + (actionId != null ? actionId : action.toString());
        Map sourceIntegerMap = this.myLocalState.computeIfAbsent(sourceKey, k -> new HashMap());
        Integer count = (Integer)sourceIntegerMap.get(key);
        int value = count == null ? 1 : count + 1;
        sourceIntegerMap.put(key, value);
        Integer stateCount = state.myValues.get(key);
        if (stateCount == null || stateCount < value) {
            state.myValues.put(key, value);
        }
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        this.state = state;
    }

    public static ActionMenuItemUpdateCollector getInstance() {
        return (ActionMenuItemUpdateCollector)ServiceManager.getService(ActionMenuItemUpdateCollector.class);
    }

    public static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="actionItem", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

