/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.actionSystem.BackgroundableDataProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionUpdateEdtExecutor;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AsyncDataContext
extends DataManagerImpl.MyDataContext {
    private static final Logger LOG = Logger.getInstance(AsyncDataContext.class);
    private final List<WeakReference<Component>> myHierarchy;
    private final Map<Component, DataProvider> myProviders = new ConcurrentFactoryMap<Component, DataProvider>(){

        @Nullable
        protected DataProvider create(Component key) {
            return ActionUpdateEdtExecutor.computeOnEdt(() -> {
                DataProvider provider = DataManagerImpl.getDataProviderEx(key);
                if (provider == null) {
                    return null;
                }
                if (provider instanceof BackgroundableDataProvider) {
                    return ((BackgroundableDataProvider)provider).createBackgroundDataProvider();
                }
                return dataKey -> {
                    boolean bg = !ApplicationManager.getApplication().isDispatchThread();
                    return ActionUpdateEdtExecutor.computeOnEdt(() -> {
                        long start2 = System.currentTimeMillis();
                        try {
                            Object object = provider.getData(dataKey);
                            return object;
                        }
                        finally {
                            long elapsed = System.currentTimeMillis() - start2;
                            if (elapsed > 100L && bg) {
                                LOG.warn("Slow data provider " + provider + " took " + elapsed + "ms on " + dataKey + ". Consider speeding it up and/or implementing BackgroundableDataProvider.");
                            }
                        }
                    });
                };
            });
        }

        @NotNull
        protected ConcurrentMap<Component, DataProvider> createMap() {
            return ContainerUtil.createConcurrentWeakKeySoftValueMap();
        }
    };

    AsyncDataContext(DataContext syncContext) {
        super((Component)syncContext.getData(PlatformDataKeys.CONTEXT_COMPONENT));
        ApplicationManager.getApplication().assertIsDispatchThread();
        Component component = (Component)this.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        List hierarchy = JBIterable.generate((Object)component, Component::getParent).toList();
        for (Component each : hierarchy) {
            this.myProviders.get(each);
        }
        this.myHierarchy = ContainerUtil.map((Collection)hierarchy, WeakReference::new);
    }

    @Override
    protected Object calcData(@NotNull String dataId, Component focused) {
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            for (WeakReference<Component> reference : this.myHierarchy) {
                DataProvider dataProvider;
                Component component = (Component)SoftReference.dereference(reference);
                if (component == null || (dataProvider = this.myProviders.get(component)) == null) continue;
                Object data = ((DataManagerImpl)DataManager.getInstance()).getDataFromProvider(dataProvider, dataId, null);
                if (data == null) continue;
                Object object = data;
                return object;
            }
        }
        return null;
    }
}

