/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.PathKt;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigImportHelper {
    private static final String FIRST_SESSION_KEY = "intellij.first.ide.session";
    private static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    public static final String CONFIG = "config";
    private static final String[] OPTIONS = new String[]{"options/other.xml", "options/ide.general.xml", "options/options.xml"};
    private static final String BIN = "bin";
    private static final String CONTENTS = "Contents";
    private static final String PLIST = "Info.plist";
    private static final String PLUGINS = "plugins";

    private ConfigImportHelper() {
    }

    public static void importConfigsTo(@NotNull String newConfigPath, @NotNull Logger log2) {
        CloudConfigProvider provider;
        System.setProperty(FIRST_SESSION_KEY, Boolean.TRUE.toString());
        ConfigImportSettings settings = ConfigImportHelper.getConfigImportSettings();
        Path newConfigDir = Paths.get(newConfigPath, new String[0]);
        List<Path> guessedOldConfigDirs = ConfigImportHelper.findConfigDirectories(newConfigDir, SystemInfo.isMac, true);
        ImportOldConfigsPanel dialog2 = new ImportOldConfigsPanel(guessedOldConfigDirs, f -> ConfigImportHelper.findConfigDirectoryByPath(f));
        dialog2.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        AppUIUtil.updateWindowIcon(dialog2);
        dialog2.setVisible(true);
        Pair<Path, Path> result2 = dialog2.getSelectedFile();
        if (result2 != null) {
            ConfigImportHelper.doImport((Path)result2.first, newConfigDir, (Path)result2.second, log2);
            settings.importFinished(newConfigPath);
            System.setProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY, Boolean.TRUE.toString());
        }
        if ((provider = CloudConfigProvider.getProvider()) != null) {
            provider.importFinished(newConfigDir);
        }
    }

    public static boolean isFirstSession() {
        return Boolean.getBoolean(FIRST_SESSION_KEY);
    }

    public static boolean isSettingsFile(@NotNull VirtualFile file2) {
        return ArchiveFileType.INSTANCE.equals(file2.getFileType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidSettingsFile(@NotNull File file2) {
        try (ZipFile zip = new ZipFile(file2);){
            boolean bl = zip.getEntry("IntelliJ IDEA Global Settings") != null;
            return bl;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isConfigImported() {
        return Boolean.getBoolean(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
    }

    public static boolean isConfigDirectory(@NotNull Path candidate) {
        for (String name : OPTIONS) {
            if (!Files.exists(candidate.resolve(name), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static ConfigImportSettings getConfigImportSettings() {
        try {
            String customProviderName = "com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings";
            Class<?> customProviderClass = Class.forName(customProviderName);
            if (ConfigImportSettings.class.isAssignableFrom(customProviderClass)) {
                return (ConfigImportSettings)ReflectionUtil.newInstance(customProviderClass);
            }
        }
        catch (ClassNotFoundException | RuntimeException exception) {
            // empty catch block
        }
        return new ConfigImportSettings();
    }

    @NotNull
    public static List<Path> findConfigDirectories(@NotNull Path newConfigDir, boolean isMacOs, boolean checkDefaultLocation) {
        ArrayList homes = ContainerUtilRt.newArrayListWithCapacity((int)2);
        homes.add((isMacOs ? newConfigDir : newConfigDir.getParent()).getParent());
        String nameWithSelector = StringUtil.notNullize((String)PathManager.getPathsSelector(), (String)(isMacOs ? newConfigDir : newConfigDir.getParent()).getFileName().toString());
        String prefix = ConfigImportHelper.getPrefixFromSelector(nameWithSelector, isMacOs);
        String defaultPrefix = StringUtil.replace((String)StringUtil.notNullize((String)ApplicationNamesInfo.getInstance().getFullProductName(), (String)PlatformUtils.getPlatformPrefix()), (String)" ", (String)"");
        if (checkDefaultLocation) {
            Path configDir = Paths.get(PathManager.getDefaultConfigPathFor((String)defaultPrefix), new String[0]);
            Path configHome = (isMacOs ? configDir : configDir.getParent()).getParent();
            if (!homes.contains(configHome)) {
                homes.add(configHome);
            }
        }
        ArrayList candidates = ContainerUtil.newArrayList();
        for (Object dir : homes) {
            if (dir == null || !Files.isDirectory((Path)dir, new LinkOption[0])) continue;
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream((Path)dir, it -> {
                    String fileName2 = it.getFileName().toString();
                    if (!(prefix != null && StringUtil.startsWithIgnoreCase((String)fileName2, (String)prefix) || StringUtil.startsWithIgnoreCase((String)fileName2, (String)defaultPrefix))) {
                        return false;
                    }
                    if (!Files.isDirectory(it, new LinkOption[0])) {
                        return false;
                    }
                    return !it.equals(isMacOs ? newConfigDir : newConfigDir.getParent());
                });
                Throwable throwable = null;
                try {
                    for (Path path : stream) {
                        candidates.add(path);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException stream) {}
        }
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Path, FileTime> lastModified = new HashMap<Path, FileTime>();
        for (Path child2 : candidates) {
            Path candidate = isMacOs ? child2 : child2.resolve(CONFIG);
            FileTime max = null;
            for (String name : OPTIONS) {
                try {
                    FileTime cur = Files.getLastModifiedTime(candidate.resolve(name), new LinkOption[0]);
                    if (max != null && cur.compareTo(max) <= 0) continue;
                    max = cur;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            lastModified.put(candidate, max != null ? max : FileTime.fromMillis(0L));
        }
        ArrayList<Path> result2 = new ArrayList<Path>(lastModified.keySet());
        result2.sort((o1, o2) -> {
            int diff = ((FileTime)lastModified.get(o2)).compareTo((FileTime)lastModified.get(o1));
            if (diff == 0) {
                diff = StringUtil.naturalCompare((String)o2.toString(), (String)o1.toString());
            }
            return diff;
        });
        return result2;
    }

    @Nullable
    private static String getPrefixFromSelector(@NotNull String nameWithSelector, boolean isMacOs) {
        String selector;
        Matcher m = Pattern.compile("\\.?([^\\d]+)\\d+(\\.\\d+)?").matcher(nameWithSelector);
        String string = selector = m.matches() ? m.group(1) : null;
        return StringUtil.isEmpty((String)selector) ? null : (isMacOs ? selector : '.' + selector);
    }

    @Nullable
    private static Pair<Path, Path> findConfigDirectoryByPath(@NotNull Path selectedDir) {
        Path configDir;
        if (ConfigImportHelper.isConfigDirectory(selectedDir)) {
            return Pair.pair((Object)selectedDir, null);
        }
        Path config2 = selectedDir.resolve(CONFIG);
        if (ConfigImportHelper.isConfigDirectory(config2)) {
            return Pair.pair((Object)config2, null);
        }
        if (Files.isDirectory(selectedDir.resolve(SystemInfo.isMac ? CONTENTS : BIN), new LinkOption[0]) && (configDir = ConfigImportHelper.getSettingsPath(selectedDir, "idea.config.path", PathManager::getDefaultConfigPathFor)) != null && ConfigImportHelper.isConfigDirectory(configDir)) {
            return Pair.pair((Object)configDir, (Object)selectedDir);
        }
        return null;
    }

    @Nullable
    private static Path getSettingsPath(@NotNull Path ideHome, String propertyName, Function<? super String, String> pathBySelector) {
        Path candidate;
        ArrayList<Path> files2 = new ArrayList<Path>();
        if (SystemInfo.isMac) {
            files2.add(ideHome.resolve("Contents/bin/idea.properties"));
            files2.add(ideHome.resolve("Contents/Info.plist"));
        } else {
            files2.add(ideHome.resolve("bin/idea.properties"));
            String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
            files2.add(ideHome.resolve("bin/" + scriptName + ".bat"));
            files2.add(ideHome.resolve("bin/" + scriptName + ".sh"));
        }
        for (Path file2 : files2) {
            String candidatePath;
            if (!Files.isRegularFile(file2, new LinkOption[0]) || (candidatePath = PathManager.substituteVars((String)ConfigImportHelper.getPropertyFromFile(file2, propertyName), (String)ideHome.toString())) == null || !Files.isDirectory(candidate = Paths.get(candidatePath, new String[0]), new LinkOption[0])) continue;
            return candidate.toAbsolutePath();
        }
        for (Path file2 : files2) {
            String selector;
            if (!Files.isRegularFile(file2, new LinkOption[0]) || (selector = ConfigImportHelper.getPropertyFromFile(file2, "idea.paths.selector")) == null || !Files.isDirectory(candidate = Paths.get(pathBySelector.apply(selector), new String[0]), new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static String getPropertyFromFile(@NotNull Path file2, String propertyName) {
        try {
            String propertyValue;
            String fileContent = PathKt.readText((Path)file2);
            String fileName2 = file2.getFileName().toString();
            if (fileName2.endsWith(".properties")) {
                PropertyResourceBundle bundle = new PropertyResourceBundle(new StringReader(fileContent));
                return bundle.containsKey(propertyName) ? bundle.getString(propertyName) : null;
            }
            if (fileName2.endsWith(".plist") && !StringUtil.isEmpty((String)(propertyValue = ConfigImportHelper.findPListKey(propertyName, fileContent)))) {
                return propertyValue;
            }
            propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
            if (!StringUtil.isEmpty((String)propertyValue)) {
                return propertyValue;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String findPListKey(String propertyName, String fileContent) {
        String key = "<key>" + propertyName + "</key>";
        int idx = fileContent.indexOf(key);
        if (idx > 0 && (idx = fileContent.indexOf("<string>", idx + key.length())) != -1) {
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)));
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String prefix = propertyName + "=";
        int idx = fileContent.indexOf(prefix);
        if (idx >= 0) {
            StringBuilder configDir = new StringBuilder();
            if (fileContent.length() > (idx += prefix.length())) {
                boolean quoted;
                boolean bl = quoted = fileContent.charAt(idx) == '\"';
                if (quoted) {
                    ++idx;
                }
                while (fileContent.length() > idx && (quoted ? fileContent.charAt(idx) != '\"' : fileContent.charAt(idx) != ' ' && fileContent.charAt(idx) != '\t') && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir.append(fileContent.charAt(idx));
                    ++idx;
                }
            }
            if ((configDir = new StringBuilder(ConfigImportHelper.fixDirName(configDir.toString()))).length() > 0) {
                configDir = new StringBuilder(new File(configDir.toString()).getPath());
            }
            return configDir.toString();
        }
        return null;
    }

    private static String fixDirName(String dir) {
        return FileUtil.expandUserHome((String)StringUtil.unquoteString((String)dir, (char)'\"'));
    }

    private static void doImport(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @Nullable Path oldIdeHome, @NotNull Logger log2) {
        if (oldConfigDir.equals(newConfigDir)) {
            return;
        }
        try {
            if (Files.isRegularFile(oldConfigDir, new LinkOption[0])) {
                new Decompressor.Zip(oldConfigDir.toFile()).extract(newConfigDir.toFile());
                return;
            }
            FileUtil.copyDir((File)oldConfigDir.toFile(), (File)newConfigDir.toFile(), path -> !ConfigImportHelper.blockImport(path.toPath(), oldConfigDir, newConfigDir));
            Path oldPluginsDir = oldConfigDir.resolve(PLUGINS);
            if (SystemInfo.isMac && !Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
                oldPluginsDir = null;
                if (oldIdeHome != null) {
                    oldPluginsDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.plugins.path", PathManager::getDefaultPluginPathFor);
                }
                if (oldPluginsDir == null) {
                    oldPluginsDir = Paths.get(PathManager.getDefaultPluginPathFor((String)oldConfigDir.getFileName().toString()), new String[0]);
                }
                if (Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
                    Path newPluginsDir = Paths.get(PathManager.getPluginsPath(), new String[0]);
                    FileUtil.copyDir((File)oldPluginsDir.toFile(), (File)newPluginsDir.toFile());
                }
            }
            if (Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
                Path script;
                Path oldSystemDir = null;
                if (oldIdeHome != null) {
                    oldSystemDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.system.path", PathManager::getDefaultSystemPathFor);
                }
                if (oldSystemDir == null) {
                    String selector = SystemInfo.isMac ? oldConfigDir.getFileName().toString() : StringUtil.trimLeading((String)oldConfigDir.getParent().getFileName().toString(), (char)'.');
                    oldSystemDir = Paths.get(PathManager.getDefaultSystemPathFor((String)selector), new String[0]);
                }
                if (Files.isRegularFile(script = oldSystemDir.resolve("plugins/action.script"), new LinkOption[0])) {
                    File newPluginsDir = new File(PathManager.getPluginsPath());
                    StartupActionScriptManager.executeActionScript((Path)script, (Path)oldPluginsDir, (File)newPluginsDir);
                }
            }
            ConfigImportHelper.updateVMOptions(newConfigDir, log2);
        }
        catch (IOException e) {
            log2.warn((Throwable)e);
            String message = ApplicationBundle.message((String)"error.unable.to.import.settings", (Object[])new Object[]{e.getMessage()});
            Main.showMessage((String)ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), (String)message, (boolean)false);
        }
    }

    private static void updateVMOptions(@NotNull Path newConfigDir, Logger log2) {
        Path vmOptionsFile = newConfigDir.resolve(VMOptions.getCustomVMOptionsFileName());
        if (Files.exists(vmOptionsFile, new LinkOption[0])) {
            try {
                List<String> lines2 = Files.readAllLines(vmOptionsFile);
                List updatedLines = ContainerUtil.map(lines2, line -> line.trim().equals("-XX:MaxJavaStackTraceDepth=-1") ? "-XX:MaxJavaStackTraceDepth=10000" : line);
                if (!updatedLines.equals(lines2)) {
                    PathKt.write((Path)vmOptionsFile, (String)StringUtil.join((Collection)updatedLines, (String)"\n"));
                }
            }
            catch (IOException e) {
                log2.warn("Failed to update custom VM options file " + vmOptionsFile, (Throwable)e);
            }
        }
    }

    private static boolean blockImport(@NotNull Path path, Path oldConfig, Path newConfig) {
        return path.getParent() == oldConfig && ("user.web.token".equals(path.getFileName().toString()) || Files.exists(newConfig.resolve(path.getFileName()), new LinkOption[0]));
    }
}

