/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeDirectoriesInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.sun.jna.platform.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class DeleteOldDirectoriesDialog
extends JDialog {
    private JPanel myTopLevelPanel;
    private JLabel myFoundUnusedLabel;
    private JPanel myTableUIPanel;
    private AsyncProcessIcon myBusyAnimationIcon;
    private JButton myDeleteButton;
    private JButton myCancelButton;
    private JBScrollPane myScrollPane;
    private List<IdeDirectoriesInfo> myDirsInfoList;
    private JCheckBox myAggregateCheckBox;
    private List<JCheckBox> myCheckBoxList;
    private List<JLabel> myLastUsedLabelList;
    private List<JLabel> mySizeLabelList;
    private List<SwingWorker> mySizeCalculationWorkers;
    private SwingWorker myDeletionWorker;

    public DeleteOldDirectoriesDialog(List<IdeDirectoriesInfo> dirsInfoList) {
        this.$$$setupUI$$$();
        JBDimension size = JBUI.size((int)600, (int)400);
        this.setBorders();
        this.setLabelTexts((Dimension)size);
        this.createTableUI(dirsInfoList);
        this.setLastUsedLabels();
        this.addListeners();
        this.setDialogProperties();
        this.runSizeCalculationWorkers();
        this.setPreferredSize((Dimension)size);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void createUIComponents() {
        this.myBusyAnimationIcon = new AsyncProcessIcon("delete old directories");
        this.myBusyAnimationIcon.setVisible(false);
    }

    private void setBorders() {
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane.setViewportBorder(null);
        this.myTableUIPanel.setBorder((Border)JBUI.Borders.empty());
    }

    private void setLabelTexts(Dimension dialogSize) {
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.myFoundUnusedLabel.setFont((Font)JBUI.Fonts.label());
        this.myFoundUnusedLabel.setText(DeleteOldDirectoriesDialog.html(ApplicationBundle.message((String)"label.found.unused", (Object[])new Object[]{productName})));
        DeleteOldDirectoriesDialog.setPreferredSize(this.myFoundUnusedLabel, dialogSize.width - 50, 2);
    }

    private static String html(String text) {
        return "<html><body><p style=\"margin-top: 0\">" + text + "</p></body></html>";
    }

    private static String bold(String text) {
        return "<b>" + text + "</b>";
    }

    private static String linebreak(String text) {
        return text.replace("\n", "<br>");
    }

    private static void setPreferredSize(JComponent component, int width, int numberOfLines) {
        int lineHeight = component.getFontMetrics(component.getFont()).getHeight();
        component.setPreferredSize(new Dimension(width, numberOfLines * lineHeight));
    }

    private void createTableUI(List<IdeDirectoriesInfo> dirsInfoList) {
        this.myTableUIPanel.setFont((Font)JBUI.Fonts.label());
        this.myDirsInfoList = dirsInfoList;
        int size = this.myDirsInfoList.size();
        this.myCheckBoxList = new ArrayList<JCheckBox>(size);
        this.myLastUsedLabelList = new ArrayList<JLabel>(size);
        this.mySizeLabelList = new ArrayList<JLabel>(size);
        int rowCount = this.myDirsInfoList.size() + 1;
        int columnCount = 5;
        this.myTableUIPanel.setLayout((LayoutManager)new GridLayoutManager(rowCount, 5));
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        constraints.setFill(0);
        constraints.setHSizePolicy(0);
        constraints.setVSizePolicy(0);
        this.myAggregateCheckBox = new JCheckBox();
        constraints.setRow(0);
        constraints.setColumn(0);
        this.myTableUIPanel.add((Component)this.myAggregateCheckBox, constraints);
        JLabel directoryTitle = new JLabel(DeleteOldDirectoriesDialog.html(DeleteOldDirectoriesDialog.bold(ApplicationBundle.message((String)"label.column.title.directory", (Object[])new Object[0]))), 10);
        DeleteOldDirectoriesDialog.setPreferredSize(directoryTitle, 270, 1);
        constraints.setRow(0);
        constraints.setColumn(1);
        this.myTableUIPanel.add((Component)directoryTitle, constraints);
        JLabel lastUsedTitle = new JLabel(DeleteOldDirectoriesDialog.html(DeleteOldDirectoriesDialog.bold(ApplicationBundle.message((String)"label.column.title.lastused", (Object[])new Object[0]))), 10);
        DeleteOldDirectoriesDialog.setPreferredSize(lastUsedTitle, 100, 1);
        constraints.setRow(0);
        constraints.setColumn(2);
        this.myTableUIPanel.add((Component)lastUsedTitle, constraints);
        JLabel sizeTitle = new JLabel(DeleteOldDirectoriesDialog.html(DeleteOldDirectoriesDialog.bold(ApplicationBundle.message((String)"label.column.title.size", (Object[])new Object[0]))), 11);
        DeleteOldDirectoriesDialog.setPreferredSize(sizeTitle, 90, 1);
        constraints.setRow(0);
        constraints.setColumn(3);
        this.myTableUIPanel.add((Component)sizeTitle, constraints);
        for (int i = 0; i < size; ++i) {
            IdeDirectoriesInfo dirsInfo = this.myDirsInfoList.get(i);
            int row2 = i + 1;
            final JCheckBox checkBox2 = new JCheckBox();
            this.myCheckBoxList.add(checkBox2);
            constraints.setRow(row2);
            constraints.setColumn(0);
            this.myTableUIPanel.add((Component)checkBox2, constraints);
            JLabel directoryLabel = new JLabel(dirsInfo.getTopLevelDirectory().getDescriptor(), 10);
            DeleteOldDirectoriesDialog.setPreferredSize(directoryLabel, 270, 1);
            DeleteOldDirectoriesDialog.setDirectoryLabelToolTip(directoryLabel, dirsInfo);
            constraints.setRow(row2);
            constraints.setColumn(1);
            this.myTableUIPanel.add((Component)directoryLabel, constraints);
            directoryLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (checkBox2.isEnabled()) {
                        checkBox2.setSelected(!checkBox2.isSelected());
                    }
                }
            });
            JLabel lastUsedLabel = new JLabel("", 10);
            DeleteOldDirectoriesDialog.setPreferredSize(lastUsedLabel, 100, 1);
            this.myLastUsedLabelList.add(lastUsedLabel);
            constraints.setRow(row2);
            constraints.setColumn(2);
            this.myTableUIPanel.add((Component)lastUsedLabel, constraints);
            JLabel sizeLabel = new JLabel("", 11);
            DeleteOldDirectoriesDialog.setPreferredSize(sizeLabel, 90, 1);
            this.mySizeLabelList.add(sizeLabel);
            constraints.setRow(row2);
            constraints.setColumn(3);
            this.myTableUIPanel.add((Component)sizeLabel, constraints);
        }
        GridConstraints spacerConstraints = new GridConstraints();
        spacerConstraints.setRow(0);
        spacerConstraints.setColumn(4);
        spacerConstraints.setRowSpan(size);
        spacerConstraints.setFill(1);
        spacerConstraints.setHSizePolicy(6);
        spacerConstraints.setVSizePolicy(0);
        this.myTableUIPanel.add((Component)new Spacer(), spacerConstraints);
    }

    private static void setDirectoryLabelToolTip(JLabel directoryLabel, IdeDirectoriesInfo dirsInfo) {
        String toolTip = dirsInfo.getTopLevelDirectory().getDirectory() != null ? dirsInfo.getTopLevelDirectory().getDirectory().toString() : dirsInfo.getSubDirectories().stream().map(dirInfo -> dirInfo.getDirectory().toString()).collect(Collectors.joining("\n"));
        directoryLabel.setToolTipText(DeleteOldDirectoriesDialog.html(DeleteOldDirectoriesDialog.linebreak(toolTip)));
    }

    private void setLastUsedLabels() {
        LocalDate today = LocalDate.now();
        for (int i = 0; i < this.myDirsInfoList.size(); ++i) {
            Instant lastUsedTime = this.myDirsInfoList.get(i).calculateLastUsedTime();
            LocalDate lastUsedDate = LocalDateTime.ofInstant(lastUsedTime, ZoneId.systemDefault()).toLocalDate();
            Period periodSinceLastUsed = Period.between(lastUsedDate, today);
            this.myLastUsedLabelList.get(i).setText(DeleteOldDirectoriesDialog.formatPeriod(periodSinceLastUsed));
        }
    }

    private static String formatPeriod(Period period) {
        int days;
        int months = 12 * period.getYears() + period.getMonths();
        int weeks = months == 0 ? period.getDays() / 7 : 0;
        int n = days = months == 0 ? period.getDays() % 7 : 0;
        if (months > 0) {
            return months > 300 ? ApplicationBundle.message((String)"label.format.period.never", (Object[])new Object[0]) : (months > 1 ? ApplicationBundle.message((String)"label.format.period.months.ago", (Object[])new Object[]{months}) : ApplicationBundle.message((String)"label.format.period.month.ago", (Object[])new Object[]{months}));
        }
        if (weeks > 0) {
            return weeks > 1 ? ApplicationBundle.message((String)"label.format.period.weeks.ago", (Object[])new Object[]{weeks}) : ApplicationBundle.message((String)"label.format.period.week.ago", (Object[])new Object[]{weeks});
        }
        if (days > 0) {
            return days > 1 ? ApplicationBundle.message((String)"label.format.period.days.ago", (Object[])new Object[]{days}) : ApplicationBundle.message((String)"label.format.period.yesterday", (Object[])new Object[0]);
        }
        return ApplicationBundle.message((String)"label.format.period.today", (Object[])new Object[0]);
    }

    private void addListeners() {
        this.myAggregateCheckBox.addItemListener(this::aggregateCheckBoxStateChanged);
        this.myCheckBoxList.forEach(cb -> cb.addItemListener(this::individualCheckBoxStateChanged));
        this.myDeleteButton.addActionListener(e -> this.onDelete());
        this.myCancelButton.addActionListener(e -> this.onCancel());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DeleteOldDirectoriesDialog.this.onCancel();
            }
        });
        this.myTopLevelPanel.registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void aggregateCheckBoxStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.myCheckBoxList.forEach(cb -> cb.setSelected(true));
        } else {
            this.myCheckBoxList.forEach(cb -> cb.setSelected(false));
        }
    }

    private void individualCheckBoxStateChanged(ItemEvent e) {
        long selectedCount = this.myCheckBoxList.stream().filter(cb -> cb.isSelected()).count();
        if (selectedCount == (long)this.myCheckBoxList.size()) {
            this.myAggregateCheckBox.setSelected(true);
        } else if (selectedCount == 0L) {
            this.myAggregateCheckBox.setSelected(false);
        }
    }

    private void setDialogProperties() {
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.setTitle(ApplicationBundle.message((String)"title.delete.unused.directories", (Object[])new Object[]{productName}));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.myTopLevelPanel);
        this.getRootPane().setDefaultButton(this.myDeleteButton);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void onDelete() {
        this.myAggregateCheckBox.setEnabled(false);
        this.myCheckBoxList.forEach(cb -> cb.setEnabled(false));
        this.myDeleteButton.setEnabled(false);
        this.myBusyAnimationIcon.setVisible(true);
        this.cancelSizeCalculationWorkers();
        this.runDeletionWorker();
    }

    private void onCancel() {
        this.cancelSizeCalculationWorkers();
        this.cancelDeletionWorker();
        this.close();
    }

    private void close() {
        if (this.myBusyAnimationIcon != null) {
            this.myBusyAnimationIcon.setVisible(false);
            Disposer.dispose((Disposable)this.myBusyAnimationIcon);
            this.myBusyAnimationIcon = null;
        }
        this.dispose();
    }

    private void runSizeCalculationWorkers() {
        int size = this.myDirsInfoList.size();
        this.mySizeCalculationWorkers = new ArrayList<SwingWorker>(size);
        for (int i = 0; i < size; ++i) {
            IdeDirectoriesInfo dirsInfo = this.myDirsInfoList.get(i);
            JLabel sizeLabel = this.mySizeLabelList.get(i);
            Iterable directories = dirsInfo.getSubDirectories().stream().map(subDir -> subDir.getDirectory()).collect(Collectors.toList());
            this.mySizeCalculationWorkers.add(new SizeCalculationWorker(directories, sizeLabel));
        }
        this.mySizeCalculationWorkers.forEach(worker -> worker.execute());
    }

    private void cancelSizeCalculationWorkers() {
        if (this.mySizeCalculationWorkers != null) {
            this.mySizeCalculationWorkers.forEach(worker -> worker.cancel(true));
        }
    }

    private void runDeletionWorker() {
        ArrayList<IdeDirectoriesInfo> deleteDirsInfoList = new ArrayList<IdeDirectoriesInfo>();
        for (int i = 0; i < this.myDirsInfoList.size(); ++i) {
            if (!this.myCheckBoxList.get(i).isSelected()) continue;
            deleteDirsInfoList.add(this.myDirsInfoList.get(i));
        }
        this.myDeletionWorker = new DeletionWorker(deleteDirsInfoList);
        this.myDeletionWorker.addPropertyChangeListener(event -> {
            if (event.getPropertyName().equals("state") && event.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                this.close();
            }
        });
        this.myDeletionWorker.execute();
    }

    private void cancelDeletionWorker() {
        if (this.myDeletionWorker != null) {
            this.myDeletionWorker.cancel(true);
        }
    }

    private static void deleteDirectory(Path directory) {
        if (directory == null || !directory.isAbsolute() || Files.isSymbolicLink(directory) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try {
            if (FileUtils.getInstance().hasTrash()) {
                FileUtils.getInstance().moveToTrash(new File[]{directory.toFile()});
            } else {
                MoreFiles.deleteRecursively((Path)directory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        JBScrollPane jBScrollPane;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myTopLevelPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFoundUnusedLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.found.unused"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 10), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 7, null, null, null));
        this.myTableUIPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel);
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 7, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, new Dimension(18, 18), new Dimension(18, 18)));
        AsyncProcessIcon asyncProcessIcon = this.myBusyAnimationIcon;
        jPanel6.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCancelButton = jButton2 = new JButton();
        jButton2.setMargin(new Insets(2, 10, 2, 10));
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.cancel.delete.directories"));
        jPanel7.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDeleteButton = jButton = new JButton();
        jButton.setMargin(new Insets(2, 10, 2, 10));
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.delete.directories"));
        jPanel7.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopLevelPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class DeletionWorker
    extends SwingWorker<Void, Void> {
        private final List<IdeDirectoriesInfo> myDeleteDirsInfoList;

        public DeletionWorker(@NotNull List<IdeDirectoriesInfo> deleteDirsInfoList) {
            this.myDeleteDirsInfoList = deleteDirsInfoList;
        }

        @Override
        protected Void doInBackground() {
            for (IdeDirectoriesInfo dirsInfo : this.myDeleteDirsInfoList) {
                for (IdeDirectoriesInfo.DirectoryInfo subDirInfo : dirsInfo.getSubDirectories()) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    DeleteOldDirectoriesDialog.deleteDirectory(subDirInfo.getDirectory());
                }
                DeleteOldDirectoriesDialog.deleteDirectory(dirsInfo.getTopLevelDirectory().getDirectory());
            }
            return null;
        }
    }

    private static class SizeCalculationWorker
    extends SwingWorker<Long, Long> {
        private final Iterable<Path> myDirectories;
        private final JLabel mySizeLabel;

        public SizeCalculationWorker(Iterable<Path> directories, JLabel sizeLabel) {
            this.myDirectories = directories;
            this.mySizeLabel = sizeLabel;
        }

        @Override
        protected Long doInBackground() throws Exception {
            SizeCalculator sizeCalculator = new SizeCalculator();
            for (Path directory : this.myDirectories) {
                Files.walkFileTree(directory, sizeCalculator);
            }
            return sizeCalculator.getTotalSize();
        }

        @Override
        protected void process(List<Long> chunks) {
            long totalSize = chunks.get(chunks.size() - 1);
            this.mySizeLabel.setText(SizeCalculationWorker.formatSize(totalSize));
        }

        @Override
        protected void done() {
            try {
                long totalSize = (Long)this.get();
                this.mySizeLabel.setText(SizeCalculationWorker.formatSize(totalSize));
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }

        private static String formatSize(long size) {
            if (size <= 0L) {
                return "0 MB";
            }
            if (size <= 0x100000L) {
                return "1 MB";
            }
            return String.format("%d MB", size / 0x100000L);
        }

        private class SizeCalculator
        implements FileVisitor<Path> {
            private long totalSize = 0L;

            private SizeCalculator() {
            }

            public long getTotalSize() {
                return this.totalSize;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return SizeCalculationWorker.this.isCancelled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                this.totalSize += attrs.size();
                return SizeCalculationWorker.this.isCancelled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file2, IOException exc) {
                return SizeCalculationWorker.this.isCancelled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                SizeCalculationWorker.this.publish(new Long[]{this.totalSize});
                return SizeCalculationWorker.this.isCancelled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }
        }
    }
}

