/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class DeleteOldDirectoriesSettings {
    private final Path userHome = Paths.get(SystemProperties.getUserHome(), new String[0]);
    private final String selector;
    private final boolean isMac;
    private final boolean isEAP;
    private final List<PathWithTransformations> ideDirectories;
    private final String applicationInfoFilePath;

    public DeleteOldDirectoriesSettings() {
        String sel = PathManager.getPathsSelector();
        this.selector = sel != null ? sel : "";
        this.isMac = SystemInfo.isMac;
        this.isEAP = ApplicationInfoImpl.getShadowInstance().isEAP();
        this.ideDirectories = Stream.of(PathManager.getConfigPath(), PathManager.getSystemPath(), PathManager.getPluginsPath(), PathManager.getLogPath()).map(PathWithTransformations::new).collect(Collectors.toList());
        this.applicationInfoFilePath = "idea/" + ApplicationNamesInfo.getComponentName() + ".xml";
    }

    @NotNull
    public Path getUserHome() {
        return this.userHome;
    }

    @NotNull
    public String getSelector() {
        return this.selector;
    }

    public boolean isMac() {
        return this.isMac;
    }

    public boolean isEAP() {
        return this.isEAP;
    }

    @NotNull
    public List<PathWithTransformations> getIdeDirectories() {
        return this.ideDirectories;
    }

    @NotNull
    public String getApplicationInfoFilePath() {
        return this.applicationInfoFilePath;
    }

    public static class PathWithTransformations
    implements Iterable<String> {
        private final Set<String> pathWithTransformations = new HashSet<String>();

        public PathWithTransformations(@NotNull String path) {
            this.pathWithTransformations.add(path);
            Path p = Paths.get(path, new String[0]);
            this.pathWithTransformations.add(p.toString());
            this.pathWithTransformations.add(p.normalize().toString());
            try {
                this.pathWithTransformations.add(p.toAbsolutePath().toString());
                this.pathWithTransformations.add(p.toAbsolutePath().normalize().toString());
            }
            catch (IOError | SecurityException throwable) {
                // empty catch block
            }
            try {
                this.pathWithTransformations.add(p.toRealPath(new LinkOption[0]).toString());
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
            try {
                this.pathWithTransformations.add(p.toFile().getCanonicalPath());
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
        }

        @Override
        @NotNull
        public Iterator<String> iterator() {
            return this.pathWithTransformations.iterator();
        }
    }
}

