/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class ImportOldConfigsUsagesCollector {

    public static enum ImportOldConfigType {
        FROM_PREVIOUS,
        FROM_CUSTOM,
        DO_NOT_IMPORT,
        OTHER,
        NOT_INITIALIZED;

    }

    public static class ImportOldConfigsState {
        private static final ImportOldConfigsState ourInstance = new ImportOldConfigsState();
        private volatile boolean myOldConfigPanelWasOpened = false;
        @NotNull
        private ImportOldConfigType myType = ImportOldConfigType.NOT_INITIALIZED;

        public static ImportOldConfigsState getInstance() {
            return ourInstance;
        }

        public void saveImportOldConfigType(@NotNull JRadioButton previous, @NotNull JRadioButton custom, @NotNull JRadioButton doNotImport) {
            this.myOldConfigPanelWasOpened = true;
            this.myType = ImportOldConfigsState.getOldImportType(previous, custom, doNotImport);
        }

        @NotNull
        private static ImportOldConfigType getOldImportType(@NotNull JRadioButton previous, @NotNull JRadioButton custom, @NotNull JRadioButton doNotImport) {
            if (previous.isSelected()) {
                return ImportOldConfigType.FROM_PREVIOUS;
            }
            if (custom.isSelected()) {
                return ImportOldConfigType.FROM_CUSTOM;
            }
            if (doNotImport.isSelected()) {
                return ImportOldConfigType.DO_NOT_IMPORT;
            }
            return ImportOldConfigType.OTHER;
        }

        public boolean isOldConfigPanelWasOpened() {
            return this.myOldConfigPanelWasOpened;
        }

        @NotNull
        public ImportOldConfigType getType() {
            return this.myType;
        }
    }

    public static class Trigger
    implements ApplicationInitializedListener {
        public void componentsInitialized() {
            ImportOldConfigsState state = ImportOldConfigsState.getInstance();
            if (state.isOldConfigPanelWasOpened()) {
                FUCounterUsageLogger.getInstance().logEvent("import.old.config", state.getType().name());
            }
        }
    }
}

