/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PluginPathManager {
    private PluginPathManager() {
    }

    public static File getPluginHome(String pluginName) {
        File subrepo = PluginPathManager.findSubrepo(pluginName);
        if (subrepo != null) {
            return subrepo;
        }
        return new File(PathManager.getHomePath(), "plugins/" + pluginName);
    }

    private static File findSubrepo(String pluginName) {
        for (File subrepo : SubrepoHolder.subrepos) {
            File candidate = new File(subrepo, pluginName);
            if (!candidate.isDirectory()) continue;
            return candidate;
        }
        return null;
    }

    public static String getPluginHomePath(String pluginName) {
        return PluginPathManager.getPluginHome(pluginName).getPath();
    }

    public static String getPluginHomePathRelative(String pluginName) {
        File subrepo = PluginPathManager.findSubrepo(pluginName);
        if (subrepo != null) {
            String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
            return "/" + FileUtil.getRelativePath((String)homePath, (String)FileUtil.toSystemIndependentName((String)subrepo.getPath()), (char)'/');
        }
        return "/plugins/" + pluginName;
    }

    private static class SubrepoHolder {
        public static List<File> subrepos = SubrepoHolder.findSubrepos();

        private SubrepoHolder() {
        }

        private static List<File> findSubrepos() {
            File[] gitRoots;
            ArrayList<File> result2 = new ArrayList<File>();
            for (File subdir : gitRoots = SubrepoHolder.getSortedGitRoots(new File(PathManager.getHomePath()))) {
                File pluginsDir = new File(subdir, "plugins");
                if (pluginsDir.exists()) {
                    result2.add(pluginsDir);
                } else {
                    result2.add(subdir);
                }
                result2.addAll(Arrays.asList(SubrepoHolder.getSortedGitRoots(subdir)));
            }
            return result2;
        }

        @NotNull
        private static File[] getSortedGitRoots(@NotNull File dir) {
            THashSet names = ContainerUtil.newTroveSet((Object[])new String[]{"community", "contrib", "android", "CIDR"});
            File[] gitRoots = dir.listFiles(arg_0 -> SubrepoHolder.lambda$getSortedGitRoots$0((Set)names, arg_0));
            if (gitRoots == null) {
                return new File[0];
            }
            Arrays.sort(gitRoots, (file2, file22) -> FileUtil.compareFiles((File)file2, (File)file22));
            return gitRoots;
        }

        private static /* synthetic */ boolean lambda$getSortedGitRoots$0(Set names, File child2) {
            return child2.isDirectory() && names.contains(child2.getName());
        }
    }
}

