/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApplicationUtil {
    public static <T> T tryRunReadAction(@NotNull Computable<T> computable) throws CannotRunReadActionException {
        Ref result2 = new Ref();
        ApplicationUtil.tryRunReadAction(() -> result2.set(computable.compute()));
        return (T)result2.get();
    }

    public static void tryRunReadAction(@NotNull Runnable computable) throws CannotRunReadActionException {
        if (!((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(computable)) {
            throw CannotRunReadActionException.create();
        }
    }

    public static <T> T runWithCheckCanceled(@NotNull Callable<T> callable, @NotNull ProgressIndicator indicator) throws Exception {
        Ref result2 = Ref.create();
        Ref error = Ref.create();
        Future<?> future2 = PooledThreadExecutor.INSTANCE.submit(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                result2.set(callable.call());
            }
            catch (Throwable t) {
                error.set((Object)t);
            }
        }, indicator));
        try {
            ApplicationUtil.runWithCheckCanceled(future2, indicator);
            ExceptionUtil.rethrowAll((Throwable)((Throwable)error.get()));
        }
        catch (ProcessCanceledException e) {
            future2.cancel(true);
            throw e;
        }
        return (T)result2.get();
    }

    public static void runWithCheckCanceled(@NotNull Future<?> future2, @NotNull ProgressIndicator indicator) throws Exception {
        while (true) {
            indicator.checkCanceled();
            try {
                future2.get(25L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public static void showDialogAfterWriteAction(@NotNull Runnable runnable2) {
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            application.invokeLater(runnable2);
        } else {
            runnable2.run();
        }
    }

    public static class CannotRunReadActionException
    extends ProcessCanceledException {
        public static CannotRunReadActionException create() {
            return new CannotRunReadActionException();
        }

        private CannotRunReadActionException() {
        }
    }
}

