/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaterInvocator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.impl.LaterInvocator");
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final Object LOCK = new Object();
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Map<Project, List<Dialog>> projectToModalEntities = ContainerUtil.createWeakMap();
    private static final Map<Project, Stack<ModalityState>> projectToModalEntitiesStack = ContainerUtil.createWeakMap();
    private static final Stack<ModalityStateEx> ourModalityStack = new Stack((Object[])new ModalityStateEx[]{(ModalityStateEx)ModalityState.NON_MODAL});
    private static final List<RunnableInfo> ourSkippedItems = new ArrayList<RunnableInfo>();
    private static final ArrayDeque<RunnableInfo> ourQueue = new ArrayDeque();
    private static final FlushQueue ourFlushQueueRunnable = new FlushQueue();
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
    private static final ConcurrentMap<Window, ModalityStateEx> ourWindowModalities = ContainerUtil.createConcurrentWeakMap();
    private static final AtomicBoolean FLUSHER_SCHEDULED = new AtomicBoolean(false);

    private LaterInvocator() {
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener2, @NotNull Disposable parentDisposable) {
        if (!ourModalityStateMulticaster.getListeners().contains(listener2)) {
            ourModalityStateMulticaster.addListener((EventListener)listener2, parentDisposable);
        }
    }

    public static void removeModalityStateListener(@NotNull ModalityStateListener listener2) {
        ourModalityStateMulticaster.removeListener((EventListener)listener2);
    }

    @NotNull
    static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        return ourWindowModalities.computeIfAbsent(window, __ -> {
            for (ModalityStateEx state : ourModalityStack) {
                if (!state.getModalEntities().contains(window)) continue;
                return state;
            }
            Window owner = window.getOwner();
            ModalityStateEx ownerState = owner == null ? (ModalityStateEx)ModalityState.NON_MODAL : LaterInvocator.modalityStateForWindow(owner);
            return LaterInvocator.isModalDialog(window) ? ownerState.appendEntity(window) : ownerState;
        });
    }

    private static boolean isModalDialog(@NotNull Object window) {
        return window instanceof Dialog && ((Dialog)window).isModal();
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull Condition<?> expired) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        return LaterInvocator.invokeLater(runnable2, modalityState, expired);
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        return LaterInvocator.invokeLater(runnable2, modalityState, Conditions.FALSE);
    }

    @NotNull
    static ActionCallback invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired) {
        ActionCallback callback2 = new ActionCallback();
        LaterInvocator.invokeLaterWithCallback(runnable2, modalityState, expired, callback2);
        return callback2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invokeLaterWithCallback(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @Nullable ActionCallback callback2) {
        if (expired.value(null)) {
            if (callback2 != null) {
                callback2.setRejected();
            }
            return;
        }
        RunnableInfo runnableInfo = new RunnableInfo(runnable2, modalityState, expired, callback2);
        Object object = LOCK;
        synchronized (object) {
            ourQueue.add(runnableInfo);
        }
        LaterInvocator.requestFlush();
    }

    static void invokeAndWait(final @NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        LOG.assertTrue(!LaterInvocator.isDispatchThread());
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref exception = Ref.create();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (Throwable e) {
                    exception.set((Object)e);
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                return "InvokeAndWait[" + runnable2 + "]";
            }
        };
        LaterInvocator.invokeLaterWithCallback(runnable1, modalityState, Conditions.FALSE, null);
        semaphore.waitFor();
        if (!exception.isNull()) {
            Throwable cause = (Throwable)exception.get();
            if (SystemPropertyUtil.getBoolean((String)"invoke.later.wrap.error", (boolean)true)) {
                throw new RuntimeException(cause);
            }
            ExceptionUtil.rethrow((Throwable)cause);
        }
    }

    public static void enterModal(@NotNull Object modalEntity) {
        ModalityStateEx state = LaterInvocator.getCurrentModalityState().appendEntity(modalEntity);
        if (LaterInvocator.isModalDialog(modalEntity)) {
            List<Object> currentEntities = state.getModalEntities();
            state = LaterInvocator.modalityStateForWindow((Window)modalEntity);
            state.forceModalEntities(currentEntities);
        }
        LaterInvocator.enterModal(modalEntity, state);
    }

    public static void enterModal(@NotNull Object modalEntity, @NotNull ModalityStateEx appendedState) {
        TransactionGuardImpl guard;
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        ourModalEntities.add(modalEntity);
        ourModalityStack.push((Object)appendedState);
        TransactionGuardImpl transactionGuardImpl = guard = IdeaApplication.isLoaded() ? (TransactionGuardImpl)TransactionGuard.getInstance() : null;
        if (guard != null) {
            guard.enteredModality(appendedState);
        }
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    public static void enterModal(Project project, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"enterModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + dialog2.getName() + " ; for project: " + project.getName());
        }
        if (project == null) {
            LaterInvocator.enterModal(dialog2);
            return;
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(true);
        List<Dialog> modalEntitiesList = projectToModalEntities.getOrDefault(project, ContainerUtil.createLockFreeCopyOnWriteList());
        projectToModalEntities.put(project, modalEntitiesList);
        modalEntitiesList.add(dialog2);
        Stack<ModalityState> modalEntitiesStack = projectToModalEntitiesStack.getOrDefault(project, (Stack<ModalityState>)new Stack((Object[])new ModalityState[]{ModalityState.NON_MODAL}));
        projectToModalEntitiesStack.put(project, modalEntitiesStack);
        modalEntitiesStack.push((Object)new ModalityStateEx(ArrayUtil.toObjectArray(ourModalEntities)));
    }

    public static void leaveModal(Project project, Dialog dialog2) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + dialog2.getName() + " ; for project: " + project.getName());
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(dialog2);
        if (index != -1) {
            ourModalEntities.remove(index);
            ourModalityStack.remove(index + 1);
            for (int i = 1; i < ourModalityStack.size(); ++i) {
                ((ModalityStateEx)((Object)ourModalityStack.get(i))).removeModality(dialog2);
            }
        } else if (project != null) {
            List<Dialog> dialogs = projectToModalEntities.get(project);
            int perProjectIndex = dialogs.indexOf(dialog2);
            LOG.assertTrue(perProjectIndex >= 0);
            dialogs.remove(perProjectIndex);
            Stack<ModalityState> states = projectToModalEntitiesStack.get(project);
            states.remove(perProjectIndex + 1);
            for (int i = 1; i < states.size(); ++i) {
                ((ModalityStateEx)((Object)states.get(i))).removeModality(dialog2);
            }
        }
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reincludeSkippedItems() {
        Object object = LOCK;
        synchronized (object) {
            for (int i = ourSkippedItems.size() - 1; i >= 0; --i) {
                ourQueue.addFirst(ourSkippedItems.get(i));
            }
            ourSkippedItems.clear();
        }
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        LOG.assertTrue(LaterInvocator.isDispatchThread(), (Object)"leaveModal() should be invoked in event-dispatch thread");
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        ((ModalityStateListener)ourModalityStateMulticaster.getMulticaster()).beforeModalityStateChanged(false);
        int index = ourModalEntities.indexOf(modalEntity);
        LOG.assertTrue(index >= 0);
        ourModalEntities.remove(index);
        ourModalityStack.remove(index + 1);
        for (int i = 1; i < ourModalityStack.size(); ++i) {
            ((ModalityStateEx)((Object)ourModalityStack.get(i))).removeModality(modalEntity);
        }
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    public static void leaveAllModals() {
        while (!ourModalEntities.isEmpty()) {
            LaterInvocator.leaveModal(ourModalEntities.get(ourModalEntities.size() - 1));
        }
        LOG.assertTrue(LaterInvocator.getCurrentModalityState() == ModalityState.NON_MODAL, (Object)LaterInvocator.getCurrentModalityState());
        LaterInvocator.reincludeSkippedItems();
        LaterInvocator.requestFlush();
    }

    @NotNull
    public static Object[] getCurrentModalEntities() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return ArrayUtil.toObjectArray(ourModalEntities);
    }

    @NotNull
    public static ModalityStateEx getCurrentModalityState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return (ModalityStateEx)((Object)ourModalityStack.peek());
    }

    public static boolean isInModalContextForProject(Project project) {
        LOG.assertTrue(LaterInvocator.isDispatchThread());
        if (ourModalEntities.isEmpty()) {
            return false;
        }
        List<Dialog> modalEntitiesForProject = projectToModalEntities.get(project);
        return modalEntitiesForProject == null || modalEntitiesForProject.isEmpty();
    }

    public static boolean isInModalContext() {
        return LaterInvocator.isInModalContextForProject(null);
    }

    private static boolean isDispatchThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    private static void requestFlush() {
        if (FLUSHER_SCHEDULED.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
        }
    }

    public static boolean ensureFlushRequested() {
        if (LaterInvocator.getNextEvent(false) != null) {
            SwingUtilities.invokeLater(ourFlushQueueRunnable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static RunnableInfo getNextEvent(boolean remove) {
        Object object = LOCK;
        synchronized (object) {
            ModalityStateEx currentModality = LaterInvocator.getCurrentModalityState();
            while (!ourQueue.isEmpty()) {
                RunnableInfo info = ourQueue.getFirst();
                if (info.expired.value(null)) {
                    ourQueue.removeFirst();
                    info.markDone();
                    continue;
                }
                if (!currentModality.dominates(info.modalityState)) {
                    if (remove) {
                        ourQueue.removeFirst();
                    }
                    return info;
                }
                ourSkippedItems.add(ourQueue.removeFirst());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<RunnableInfo> getLaterInvocatorQueue() {
        Object object = LOCK;
        synchronized (object) {
            return Collections.unmodifiableCollection(ourQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeExpiredItems() {
        Object object = LOCK;
        synchronized (object) {
            LaterInvocator.reincludeSkippedItems();
            ArrayList<RunnableInfo> alive = new ArrayList<RunnableInfo>(ourQueue.size());
            for (RunnableInfo info : ourQueue) {
                if (info.expired.value(null)) {
                    info.markDone();
                    continue;
                }
                alive.add(info);
            }
            if (alive.size() < ourQueue.size()) {
                ourQueue.clear();
                ourQueue.addAll(alive);
            }
        }
    }

    public static void dispatchPendingFlushes() {
        if (!LaterInvocator.isDispatchThread()) {
            throw new IllegalStateException("Must call from EDT");
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        LaterInvocator.invokeLater(() -> ((Semaphore)semaphore).up(), ModalityState.any());
        while (!semaphore.isUp()) {
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    private static class FlushQueue
    implements Runnable {
        private RunnableInfo myLastInfo;

        private FlushQueue() {
        }

        @Override
        public void run() {
            FLUSHER_SCHEDULED.set(false);
            long startTime = System.currentTimeMillis();
            do {
                if (this.runNextEvent()) continue;
                return;
            } while (System.currentTimeMillis() - startTime <= 5L);
            LaterInvocator.requestFlush();
        }

        private boolean runNextEvent() {
            RunnableInfo lastInfo;
            this.myLastInfo = lastInfo = LaterInvocator.getNextEvent(true);
            if (lastInfo != null) {
                try {
                    FlushQueue.doRun(lastInfo);
                    lastInfo.markDone();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                finally {
                    if (!DEBUG) {
                        this.myLastInfo = null;
                    }
                }
            }
            return lastInfo != null;
        }

        private static void doRun(@Async.Execute RunnableInfo info) {
            info.runnable.run();
        }

        public String toString() {
            return "LaterInvocator.FlushQueue" + (this.myLastInfo == null ? "" : " lastInfo=" + this.myLastInfo);
        }
    }

    private static class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        @Nullable
        private final ActionCallback callback;

        @Async.Schedule
        RunnableInfo(@NotNull Runnable runnable2, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @Nullable ActionCallback callback2) {
            this.runnable = runnable2;
            this.modalityState = modalityState;
            this.expired = expired;
            this.callback = callback2;
        }

        void markDone() {
            if (this.callback != null) {
                this.callback.setDone();
            }
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "] ";
        }
    }
}

