/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.WeakList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModalityStateEx
extends ModalityState {
    private final WeakList<Object> myModalEntities = new WeakList();

    public ModalityStateEx() {
    }

    ModalityStateEx(Object ... modalEntities) {
        Collections.addAll(this.myModalEntities, modalEntities);
    }

    List<Object> getModalEntities() {
        return this.myModalEntities.toStrongList();
    }

    @NotNull
    public ModalityState appendProgress(@NotNull ProgressIndicator progress) {
        return this.appendEntity(progress);
    }

    @NotNull
    ModalityStateEx appendEntity(@NotNull Object anEntity) {
        List<Object> modalEntities = this.getModalEntities();
        ArrayList<Object> list2 = new ArrayList<Object>(modalEntities.size() + 1);
        list2.addAll(modalEntities);
        list2.add(anEntity);
        return new ModalityStateEx(list2.toArray());
    }

    void forceModalEntities(List<Object> entities) {
        this.myModalEntities.clear();
        this.myModalEntities.addAll(entities);
    }

    public boolean dominates(@NotNull ModalityState anotherState) {
        if (anotherState == ModalityState.any()) {
            return false;
        }
        if (this.myModalEntities.isEmpty()) {
            return false;
        }
        List<Object> otherEntities = ((ModalityStateEx)anotherState).getModalEntities();
        for (Object entity : this.getModalEntities()) {
            if (otherEntities.contains(entity)) continue;
            return true;
        }
        return false;
    }

    @NonNls
    public String toString() {
        return this == NON_MODAL ? "ModalityState.NON_MODAL" : "ModalityState:{" + StringUtil.join(this.getModalEntities(), it -> "[" + it + "]", (String)", ") + "}";
    }

    void removeModality(Object modalEntity) {
        this.myModalEntities.remove(modalEntity);
    }
}

