/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.async.AsyncExecution;
import com.intellij.openapi.application.async.InSmartMode;
import com.intellij.openapi.application.async.WithDocumentsCommitted;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

@VisibleForTesting
public class NonBlockingReadActionImpl<T>
implements NonBlockingReadAction<T> {
    @Nullable
    private final Pair<ModalityState, Consumer<T>> myEdtFinish;
    private final List<AsyncExecution.ExpirableContextConstraint> myConstraints;
    private final BooleanSupplier myExpireCondition;
    private final Callable<T> myComputation;
    private static final Set<CancellablePromise<?>> ourTasks = ContainerUtil.newConcurrentSet();

    NonBlockingReadActionImpl(@Nullable Pair<ModalityState, Consumer<T>> edtFinish, @NotNull List<AsyncExecution.ExpirableContextConstraint> constraints, @NotNull BooleanSupplier expireCondition, @NotNull Callable<T> computation) {
        this.myEdtFinish = edtFinish;
        this.myConstraints = constraints;
        this.myExpireCondition = expireCondition;
        this.myComputation = computation;
    }

    public NonBlockingReadAction<T> inSmartMode(@NotNull Project project) {
        return new NonBlockingReadActionImpl<T>(this.myEdtFinish, ContainerUtil.append(this.myConstraints, (Object[])new AsyncExecution.ExpirableContextConstraint[]{new InSmartMode(project)}), this.myExpireCondition, this.myComputation).expireWhen(() -> ((Project)project).isDisposed());
    }

    public NonBlockingReadAction<T> withDocumentsCommitted(@NotNull Project project) {
        return new NonBlockingReadActionImpl<T>(this.myEdtFinish, ContainerUtil.append(this.myConstraints, (Object[])new AsyncExecution.ExpirableContextConstraint[]{new WithDocumentsCommitted(project, ModalityState.any())}), this.myExpireCondition, this.myComputation).expireWhen(() -> ((Project)project).isDisposed());
    }

    public NonBlockingReadAction<T> expireWhen(@NotNull BooleanSupplier expireCondition) {
        return new NonBlockingReadActionImpl<T>(this.myEdtFinish, this.myConstraints, () -> this.myExpireCondition.getAsBoolean() || expireCondition.getAsBoolean(), this.myComputation);
    }

    public NonBlockingReadAction<T> expireWith(@NotNull Disposable parentDisposable) {
        return this.expireWhen(() -> Disposer.isDisposed((Disposable)parentDisposable));
    }

    public NonBlockingReadAction<T> finishOnUiThread(@NotNull ModalityState modality, @NotNull Consumer<T> uiThreadAction) {
        return new NonBlockingReadActionImpl<T>(Pair.create((Object)modality, uiThreadAction), this.myConstraints, this.myExpireCondition, this.myComputation);
    }

    public CancellablePromise<T> submit(@NotNull Executor backgroundThreadExecutor) {
        AsyncPromise promise = new AsyncPromise();
        new Submission(promise, backgroundThreadExecutor).transferToBgThread();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourTasks.add((CancellablePromise<?>)promise);
            promise.onProcessed(__ -> ourTasks.remove(promise));
        }
        return promise;
    }

    public static void cancelAllTasks() {
        while (!ourTasks.isEmpty()) {
            for (CancellablePromise<?> task2 : ourTasks) {
                task2.cancel();
            }
            WriteAction.run(() -> {});
        }
    }

    public static void waitForAsyncTaskCompletion() {
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        for (CancellablePromise<?> task2 : ourTasks) {
            NonBlockingReadActionImpl.waitForTask(task2);
        }
    }

    private static void waitForTask(@NotNull CancellablePromise<?> task2) {
        int iteration = 0;
        while (!task2.isDone() && iteration++ < 60000) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                task2.blockingGet(1, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!task2.isDone()) {
            System.err.println(ThreadDumper.dumpThreadsToString());
            throw new AssertionError((Object)"Too long async task");
        }
    }

    private class Submission {
        private final AsyncPromise<? super T> promise;
        @NotNull
        private final Executor backendExecutor;
        private volatile ProgressIndicator currentIndicator;
        private final ModalityState creationModality = ModalityState.defaultModalityState();

        Submission(@NotNull AsyncPromise<? super T> promise, Executor backgroundThreadExecutor) {
            this.promise = promise;
            this.backendExecutor = backgroundThreadExecutor;
            promise.onError(__ -> {
                ProgressIndicator indicator = this.currentIndicator;
                if (indicator != null) {
                    indicator.cancel();
                }
            });
        }

        void transferToBgThread() {
            this.backendExecutor.execute(() -> {
                try {
                    EmptyProgressIndicator indicator = new EmptyProgressIndicator(this.creationModality);
                    this.currentIndicator = indicator;
                    ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> this.lambda$null$1((ProgressIndicator)indicator), (ProgressIndicator)indicator);
                }
                finally {
                    this.currentIndicator = null;
                }
                if (Promises.isPending(this.promise)) {
                    this.rescheduleLater();
                }
            });
        }

        private void rescheduleLater() {
            for (AsyncExecution.ExpirableContextConstraint constraint : NonBlockingReadActionImpl.this.myConstraints) {
                if (constraint.isCorrectContext()) continue;
                constraint.scheduleExpirable(this::transferToBgThread);
                return;
            }
            ApplicationManager.getApplication().invokeLater(this::transferToBgThread, ModalityState.any());
        }

        void insideReadAction(ProgressIndicator indicator) {
            block5: {
                try {
                    if (this.checkObsolete() || !this.constraintsAreSatisfied()) {
                        return;
                    }
                    Object result2 = NonBlockingReadActionImpl.this.myComputation.call();
                    if (NonBlockingReadActionImpl.this.myEdtFinish != null) {
                        this.safeTransferToEdt(result2, NonBlockingReadActionImpl.this.myEdtFinish, indicator);
                    } else {
                        this.promise.setResult(result2);
                    }
                }
                catch (Throwable e) {
                    if (indicator.isCanceled()) break block5;
                    this.promise.setError(e);
                }
            }
        }

        private boolean constraintsAreSatisfied() {
            return ContainerUtil.all((Collection)NonBlockingReadActionImpl.this.myConstraints, AsyncExecution.ContextConstraint::isCorrectContext);
        }

        private boolean checkObsolete() {
            if (NonBlockingReadActionImpl.this.myExpireCondition.getAsBoolean()) {
                this.promise.cancel();
                return true;
            }
            return false;
        }

        void safeTransferToEdt(T result2, Pair<? extends ModalityState, ? extends Consumer<T>> edtFinish, ProgressIndicator indicator) {
            if (Promises.isRejected(this.promise)) {
                return;
            }
            Semaphore semaphore = new Semaphore(1);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (indicator.isCanceled()) {
                    return;
                }
                if (this.checkObsolete()) {
                    semaphore.up();
                    return;
                }
                this.promise.setResult(result2);
                semaphore.up();
                if (this.promise.isSucceeded()) {
                    ((Consumer)edtFinish.second).accept(result2);
                }
            }, (ModalityState)edtFinish.first);
            while (!semaphore.waitFor(10L)) {
                if (!indicator.isCanceled()) continue;
                throw new ProcessCanceledException();
            }
        }

        private /* synthetic */ void lambda$null$1(ProgressIndicator indicator) {
            this.insideReadAction(indicator);
        }
    }
}

