/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CommandProcessorImpl
extends CoreCommandProcessor {
    CommandProcessorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishCommand(@NotNull CommandToken command, @Nullable Throwable throwable) {
        boolean failed;
        if (this.myCurrentCommand != command) {
            return;
        }
        try {
            if (throwable != null) {
                failed = true;
                ExceptionUtil.rethrowUnchecked((Throwable)throwable);
                CommandLog.LOG.error(throwable);
            } else {
                failed = false;
            }
        }
        finally {
            try {
                super.finishCommand(command, throwable);
            }
            catch (Throwable e) {
                if (throwable != null) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        if (failed) {
            Project project = command.getProject();
            if (project != null) {
                FileEditor editor = new FocusBasedCurrentEditorProvider().getCurrentEditor();
                UndoManager undoManager = UndoManager.getInstance((Project)project);
                if (undoManager.isUndoAvailable(editor)) {
                    undoManager.undo(editor);
                }
            }
            Messages.showErrorDialog((Project)project, (String)"Cannot perform operation. Too complex, sorry.", (String)"Failed to Perform Operation");
        }
    }

    @Override
    public void markCurrentCommandAsGlobal(Project project) {
        CommandProcessorImpl.getUndoManager(project).markCurrentCommandAsGlobal();
    }

    private static UndoManagerImpl getUndoManager(Project project) {
        return (UndoManagerImpl)(project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance());
    }

    @Override
    public void addAffectedDocuments(Project project, Document ... docs) {
        CommandProcessorImpl.getUndoManager(project).addAffectedDocuments(docs);
    }

    @Override
    public void addAffectedFiles(Project project, VirtualFile ... files2) {
        CommandProcessorImpl.getUndoManager(project).addAffectedFiles(files2);
    }
}

