/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreCommandProcessor
extends CommandProcessorEx {
    protected CommandDescriptor myCurrentCommand;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myUndoTransparentCount;
    private final CommandListener eventPublisher;

    public CoreCommandProcessor() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        messageBus.connect().subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void commandStarted(@NotNull CommandEvent event) {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.commandStarted(event);
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void beforeCommandFinished(@NotNull CommandEvent event) {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.beforeCommandFinished(event);
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void commandFinished(@NotNull CommandEvent event) {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.commandFinished(event);
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void undoTransparentActionStarted() {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.undoTransparentActionStarted();
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void beforeUndoTransparentActionFinished() {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.beforeUndoTransparentActionFinished();
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }

            public void undoTransparentActionFinished() {
                for (CommandListener listener2 : CoreCommandProcessor.this.myListeners) {
                    try {
                        listener2.undoTransparentActionFinished();
                    }
                    catch (Throwable e) {
                        CommandLog.LOG.error(e);
                    }
                }
            }
        });
        this.eventPublisher = (CommandListener)messageBus.syncPublisher(CommandListener.TOPIC);
    }

    public void executeCommand(@NotNull Runnable runnable2, String name, Object groupId) {
        this.executeCommand(null, runnable2, name, groupId);
    }

    public void executeCommand(Project project, @NotNull Runnable runnable2, String name, Object groupId) {
        this.executeCommand(project, runnable2, name, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    public void executeCommand(Project project, @NotNull Runnable runnable2, String name, Object groupId, Document document) {
        this.executeCommand(project, runnable2, name, groupId, UndoConfirmationPolicy.DEFAULT, document);
    }

    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy) {
        this.executeCommand(project, command, name, groupId, confirmationPolicy, null);
    }

    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, Document document) {
        this.executeCommand(project, command, name, groupId, confirmationPolicy, true, document);
    }

    public void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean shouldRecordCommandForActiveDocument) {
        this.executeCommand(project, command, name, groupId, confirmationPolicy, shouldRecordCommandForActiveDocument, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean shouldRecordCommandForActiveDocument, @Nullable Document document) {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            CommandLog.LOG.error("Project " + project + " already disposed");
            return;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("executeCommand: " + command + ", name = " + name + ", groupId = " + groupId + ", in command = " + (this.myCurrentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (this.myCurrentCommand != null) {
            command.run();
            return;
        }
        Throwable throwable = null;
        try {
            this.myCurrentCommand = new CommandDescriptor(command, project, name, groupId, confirmationPolicy, shouldRecordCommandForActiveDocument, document);
            this.fireCommandStarted();
            command.run();
        }
        catch (Throwable th) {
            throwable = th;
        }
        finally {
            this.finishCommand(this.myCurrentCommand, throwable);
        }
    }

    @Override
    @Nullable
    public CommandToken startCommand(@Nullable Project project, @Nls String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            return null;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("startCommand: name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            return null;
        }
        Document document = groupId instanceof Document ? (Document)groupId : (groupId instanceof Ref && ((Ref)groupId).get() instanceof Document ? (Document)((Ref)groupId).get() : null);
        this.myCurrentCommand = new CommandDescriptor(EmptyRunnable.INSTANCE, project, name, groupId, undoConfirmationPolicy, true, document);
        this.fireCommandStarted();
        return this.myCurrentCommand;
    }

    @Override
    public void finishCommand(@NotNull CommandToken command, @Nullable Throwable throwable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null, (Object)"no current command in progress");
        this.fireCommandFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCommandFinished() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        CommandListener publisher = this.eventPublisher;
        try {
            publisher.beforeCommandFinished(event);
        }
        finally {
            this.myCurrentCommand = null;
            publisher.commandFinished(event);
        }
    }

    @Override
    public void enterModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        this.myInterruptedCommands.push(currentCommand);
        if (currentCommand != null) {
            this.fireCommandFinished();
        }
    }

    @Override
    public void leaveModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand == null, (Object)("Command must not run: " + this.myCurrentCommand));
        this.myCurrentCommand = this.myInterruptedCommands.pop();
        if (this.myCurrentCommand != null) {
            this.fireCommandStarted();
        }
    }

    public void setCurrentCommandName(String name) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myName = name;
    }

    public void setCurrentCommandGroupId(Object groupId) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myGroupId = groupId;
    }

    @Nullable
    public Runnable getCurrentCommand() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myCommand : null;
    }

    @Nullable
    public String getCurrentCommandName() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myName;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myName : null;
        }
        return null;
    }

    @Nullable
    public Object getCurrentCommandGroupId() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myGroupId;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myGroupId : null;
        }
        return null;
    }

    @Nullable
    public Project getCurrentCommandProject() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myProject : null;
    }

    public void addCommandListener(@NotNull CommandListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeCommandListener(@NotNull CommandListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void runUndoTransparentAction(@NotNull Runnable action) {
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("runUndoTransparentAction: " + action + ", in command = " + (this.myCurrentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (this.myUndoTransparentCount++ == 0) {
            this.eventPublisher.undoTransparentActionStarted();
        }
        try {
            action.run();
        }
        finally {
            if (this.myUndoTransparentCount == 1) {
                this.eventPublisher.beforeUndoTransparentActionFinished();
            }
            if (--this.myUndoTransparentCount == 0) {
                this.eventPublisher.undoTransparentActionFinished();
            }
        }
    }

    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    public void markCurrentCommandAsGlobal(@Nullable Project project) {
    }

    public void addAffectedDocuments(@Nullable Project project, Document ... docs) {
    }

    public void addAffectedFiles(@Nullable Project project, VirtualFile ... files2) {
    }

    private void fireCommandStarted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        this.eventPublisher.commandStarted(event);
    }

    private static class CommandDescriptor
    implements CommandToken {
        @NotNull
        public final Runnable myCommand;
        public final Project myProject;
        public String myName;
        public Object myGroupId;
        public final Document myDocument;
        @NotNull
        public final UndoConfirmationPolicy myUndoConfirmationPolicy;
        public final boolean myShouldRecordActionForActiveDocument;

        CommandDescriptor(@NotNull Runnable command, Project project, String name, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, Document document) {
            this.myCommand = command;
            this.myProject = project;
            this.myName = name;
            this.myGroupId = groupId;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myShouldRecordActionForActiveDocument = shouldRecordActionForActiveDocument;
            this.myDocument = document;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }

        public String toString() {
            return "'" + this.myName + "', group: '" + this.myGroupId + "'";
        }
    }
}

