/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CompressionUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorChangeAction
extends BasicUndoableAction {
    private final int myOffset;
    private final Object myOldString;
    private final Object myNewString;
    private final long myOldTimeStamp;
    private final long myNewTimeStamp;
    private final int myOldLength;
    private final int myNewLength;

    public EditorChangeAction(DocumentEvent e) {
        this((DocumentEx)e.getDocument(), e.getOffset(), e.getOldFragment(), e.getNewFragment(), e.getOldTimeStamp());
    }

    public EditorChangeAction(@NotNull DocumentEx document, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp) {
        super(new Document[]{document});
        this.myOffset = offset;
        this.myOldString = CompressionUtil.compressStringRawBytes((CharSequence)oldString);
        this.myNewString = CompressionUtil.compressStringRawBytes((CharSequence)newString);
        this.myOldTimeStamp = oldTimeStamp;
        this.myNewTimeStamp = document.getModificationStamp();
        this.myNewLength = document.getTextLength();
        this.myOldLength = this.myNewLength - newString.length() + oldString.length();
    }

    public void undo() throws UnexpectedUndoException {
        this.validateDocumentLength(this.myNewLength);
        DocumentUndoProvider.startDocumentUndo(this.getDocument());
        try {
            this.performUndo();
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo(this.getDocument());
        }
        this.getDocument().setModificationStamp(this.myOldTimeStamp);
        this.refreshFileStatus();
    }

    public void performUndo() {
        CharSequence oldString = CompressionUtil.uncompressStringRawBytes((Object)this.myOldString);
        CharSequence newString = CompressionUtil.uncompressStringRawBytes((Object)this.myNewString);
        this.exchangeStrings(newString, oldString);
    }

    public void redo() throws UnexpectedUndoException {
        this.validateDocumentLength(this.myOldLength);
        DocumentUndoProvider.startDocumentUndo(this.getDocument());
        try {
            CharSequence oldString = CompressionUtil.uncompressStringRawBytes((Object)this.myOldString);
            CharSequence newString = CompressionUtil.uncompressStringRawBytes((Object)this.myNewString);
            this.exchangeStrings(oldString, newString);
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo(this.getDocument());
        }
        this.getDocument().setModificationStamp(this.myNewTimeStamp);
        this.refreshFileStatus();
    }

    private void exchangeStrings(@NotNull CharSequence newString, @NotNull CharSequence oldString) {
        DocumentEx d = this.getDocument();
        if (newString.length() > 0 && oldString.length() == 0) {
            d.deleteString(this.myOffset, this.myOffset + newString.length());
        } else if (oldString.length() > 0 && newString.length() == 0) {
            d.insertString(this.myOffset, oldString);
        } else if (oldString.length() > 0 && newString.length() > 0) {
            d.replaceString(this.myOffset, this.myOffset + newString.length(), oldString);
        }
    }

    private void validateDocumentLength(int expectedLength) throws UnexpectedUndoException {
        if (this.getDocument().getTextLength() != expectedLength) {
            throw new UnexpectedUndoException("Unexpected document state");
        }
    }

    private void refreshFileStatus() {
        VirtualFile f = this.getAffectedDocuments()[0].getFile();
        if (f == null || f instanceof LightVirtualFile) {
            return;
        }
        for (Project each : ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManagerImpl statusManager = (FileStatusManagerImpl)FileStatusManager.getInstance((Project)each);
            statusManager.refreshFileStatusFromDocument(f, this.getDocument());
        }
    }

    private DocumentEx getDocument() {
        return (DocumentEx)this.getAffectedDocuments()[0].getDocument();
    }

    @NonNls
    public String toString() {
        return "editor change: '" + this.myOldString + "' to '" + this.myNewString + "' at: " + this.myOffset;
    }
}

