/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.impl.ChangeRange;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileUndoProvider
implements UndoProvider,
VirtualFileListener {
    public static final Logger LOG = Logger.getInstance(FileUndoProvider.class);
    private final Key<DocumentReference> DELETION_WAS_UNDOABLE = new Key(FileUndoProvider.class.getName() + ".DeletionWasUndoable");
    private final Project myProject;
    private boolean myIsInsideCommand;
    private LocalHistoryFacade myLocalHistory;
    private IdeaGateway myGateway;
    private long myLastChangeId;

    public FileUndoProvider() {
        this(null);
    }

    private FileUndoProvider(Project project) {
        this.myProject = project;
        if (this.myProject == null) {
            return;
        }
        LocalHistoryImpl localHistory = LocalHistoryImpl.getInstanceImpl();
        this.myLocalHistory = localHistory.getFacade();
        this.myGateway = localHistory.getGateway();
        if (this.myLocalHistory == null || this.myGateway == null) {
            return;
        }
        localHistory.addVFSListenerAfterLocalHistoryOne(this, (Disposable)project);
        this.myLocalHistory.addListener(new LocalHistoryFacade.Listener(){

            @Override
            public void changeAdded(Change c) {
                if (!(c instanceof StructuralChange) || c instanceof ContentChange) {
                    return;
                }
                FileUndoProvider.this.myLastChangeId = c.getId();
            }
        }, (Disposable)this.myProject);
    }

    @Override
    public void commandStarted(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = true;
    }

    @Override
    public void commandFinished(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = false;
    }

    public void fileCreated(@NotNull VirtualFileEvent e) {
        this.processEvent(e);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent e) {
        if (!e.getPropertyName().equals("name")) {
            return;
        }
        this.processEvent((VirtualFileEvent)e);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent e) {
        this.processEvent((VirtualFileEvent)e);
    }

    private void processEvent(VirtualFileEvent e) {
        if (!this.shouldProcess(e)) {
            return;
        }
        if (FileUndoProvider.isUndoable(e)) {
            this.registerUndoableAction(e);
        } else {
            this.registerNonUndoableAction(e);
        }
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent e) {
        if (!this.shouldProcess(e)) {
            return;
        }
        if (FileUndoProvider.isUndoable(e)) {
            return;
        }
        this.registerNonUndoableAction(e);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent e) {
        if (!this.shouldProcess(e)) {
            this.invalidateActionsFor(e);
            return;
        }
        if (FileUndoProvider.isUndoable(e)) {
            VirtualFile file2 = e.getFile();
            file2.putUserData(this.DELETION_WAS_UNDOABLE, (Object)FileUndoProvider.createDocumentReference(e));
        } else {
            this.registerNonUndoableAction(e);
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent e) {
        if (!this.shouldProcess(e)) {
            return;
        }
        VirtualFile f = e.getFile();
        DocumentReference ref = (DocumentReference)f.getUserData(this.DELETION_WAS_UNDOABLE);
        if (ref != null) {
            this.registerUndoableAction(ref);
            f.putUserData(this.DELETION_WAS_UNDOABLE, null);
        }
    }

    private boolean shouldProcess(VirtualFileEvent e) {
        return !this.myProject.isDisposed() && LocalHistory.getInstance().isUnderControl(e.getFile()) && this.myIsInsideCommand && !"FileContentUtilCore.saveOrReload".equals(e.getRequestor());
    }

    private static boolean isUndoable(VirtualFileEvent e) {
        return !e.isFromRefresh() || e.getFile().getUserData(UndoConstants.FORCE_RECORD_UNDO) == Boolean.TRUE;
    }

    private void registerUndoableAction(VirtualFileEvent e) {
        this.registerUndoableAction(FileUndoProvider.createDocumentReference(e));
    }

    private void registerUndoableAction(DocumentReference ref) {
        this.getUndoManager().undoableActionPerformed((UndoableAction)new MyUndoableAction(ref));
    }

    private void registerNonUndoableAction(VirtualFileEvent e) {
        this.getUndoManager().nonundoableActionPerformed(FileUndoProvider.createDocumentReference(e), true);
    }

    private void invalidateActionsFor(VirtualFileEvent e) {
        if (this.myProject == null || !this.myProject.isDisposed()) {
            this.getUndoManager().invalidateActionsFor(FileUndoProvider.createDocumentReference(e));
        }
    }

    private static DocumentReference createDocumentReference(VirtualFileEvent e) {
        return DocumentReferenceManager.getInstance().create(e.getFile());
    }

    private UndoManagerImpl getUndoManager() {
        if (this.myProject != null) {
            return (UndoManagerImpl)UndoManager.getInstance((Project)this.myProject);
        }
        return (UndoManagerImpl)UndoManager.getGlobalInstance();
    }

    private class MyUndoableAction
    extends GlobalUndoableAction {
        private ChangeRange myActionChangeRange;
        private ChangeRange myUndoChangeRange;

        MyUndoableAction(DocumentReference r) {
            super(new DocumentReference[]{r});
            this.myActionChangeRange = new ChangeRange(FileUndoProvider.this.myGateway, FileUndoProvider.this.myLocalHistory, FileUndoProvider.this.myLastChangeId);
        }

        public void undo() throws UnexpectedUndoException {
            try {
                this.myUndoChangeRange = this.myActionChangeRange.revert(this.myUndoChangeRange);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new UnexpectedUndoException(e.getMessage());
            }
        }

        public void redo() throws UnexpectedUndoException {
            try {
                this.myActionChangeRange = this.myUndoChangeRange.revert(this.myActionChangeRange);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new UnexpectedUndoException(e.getMessage());
            }
        }
    }
}

