/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class PathMacroManager
implements PathMacroSubstitutor {
    private PathMacrosImpl myPathMacros;
    private ReplacePathToMacroMap myReplacePathToMacroMap;
    private long myPathMacrosModificationCount;

    @NotNull
    public static PathMacroManager getInstance(@NotNull ComponentManager componentManager) {
        return (PathMacroManager)componentManager.getPicoContainer().getComponentInstance(PathMacroManager.class);
    }

    public PathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    @NotNull
    public PathMacroFilter getMacroFilter() {
        return Holder.FILTER;
    }

    protected static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result2, @NotNull String macroName, @Nullable @SystemIndependent String path) {
        if (path != null) {
            PathMacroManager.doAddFileHierarchyReplacements(result2, StringUtil.trimEnd((String)path, (String)"/"), '$' + macroName + '$');
        }
    }

    private static void doAddFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result2, @NotNull String path, @NotNull String macro) {
        String parentPath = PathUtilRt.getParentPath((String)path);
        if (!parentPath.isEmpty()) {
            PathMacroManager.doAddFileHierarchyReplacements(result2, parentPath, macro + "/..");
        }
        result2.put(macro, path);
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result2, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro = '$' + macroName + '$';
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (String)"/");
        boolean overwrite = true;
        while (StringUtil.isNotEmpty((String)path) && path.contains("/")) {
            result2.addReplacement(path, macro, overwrite);
            if (path.equals(stopAt)) break;
            macro = macro + "/..";
            overwrite = false;
            path = StringUtil.getPackageName((String)path, (char)'/');
        }
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result2 = new ExpandMacroToPathMap();
        this.getPathMacros().addMacroExpands(result2);
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result2.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
        }
        return result2;
    }

    @NotNull
    public final synchronized ReplacePathToMacroMap getReplacePathMap() {
        long pathMacrosModificationCount = this.getPathMacros().getModificationCount();
        if (this.myReplacePathToMacroMap != null && pathMacrosModificationCount == this.myPathMacrosModificationCount) {
            return this.myReplacePathToMacroMap;
        }
        this.myReplacePathToMacroMap = this.computeReplacePathMap();
        this.myPathMacrosModificationCount = pathMacrosModificationCount;
        return this.myReplacePathToMacroMap;
    }

    @NotNull
    protected ReplacePathToMacroMap computeReplacePathMap() {
        ReplacePathToMacroMap result2 = new ReplacePathToMacroMap();
        this.getPathMacros().addMacroReplacements(result2);
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result2.addMacroReplacement((String)entry.getValue(), (String)entry.getKey());
        }
        return result2;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    public String expandPath(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            return text;
        }
        return this.getExpandMacroMap().substitute(text, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public String collapsePath(@Nullable String text, boolean recursively) {
        if (StringUtil.isEmpty((String)text)) {
            return text;
        }
        return this.getReplacePathMap().substitute(text, SystemInfo.isFileSystemCaseSensitive, recursively);
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element, boolean recursively) {
        PathMacroManager.collapsePaths(element, recursively, this.getReplacePathMap());
    }

    public static void collapsePaths(@NotNull Element element, boolean recursively, @NotNull ReplacePathToMacroMap map2) {
        map2.substitute(element, SystemInfo.isFileSystemCaseSensitive, recursively, Holder.FILTER);
    }

    @NotNull
    private PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        return this.myPathMacros;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path1), (String)FileUtil.toSystemIndependentName((String)path2));
    }

    private static class Holder {
        private static final CompositePathMacroFilter FILTER = new CompositePathMacroFilter(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.getExtensionList());

        private Holder() {
        }
    }
}

