/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.StartupProgress;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;

public abstract class ComponentManagerImpl
extends UserDataHolderBase
implements ComponentManagerEx,
org.picocontainer.Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.components.ComponentManager");
    private volatile MutablePicoContainer myPicoContainer;
    private volatile boolean myDisposed;
    private volatile boolean myDisposeCompleted;
    private MessageBus myMessageBus;
    private final Map<String, BaseComponent> myNameToComponent = new THashMap();
    private int myComponentConfigCount;
    private int myInstantiatedComponentCount = -1;
    private boolean myComponentsCreated;
    private final List<BaseComponent> myBaseComponents = new SmartList();
    private final ComponentManager myParentComponentManager;
    private final Condition myDisposedCondition = o -> this.isDisposed();

    protected ComponentManagerImpl(@Nullable ComponentManager parentComponentManager) {
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(this.toString());
    }

    protected ComponentManagerImpl(@Nullable ComponentManager parentComponentManager, @NotNull String name) {
        this.myParentComponentManager = parentComponentManager;
        this.bootstrapPicoContainer(name);
    }

    protected final void init(@Nullable ProgressIndicator indicator, @Nullable Runnable componentsRegistered) {
        List<ComponentConfig> componentConfigs = this.getComponentConfigs(indicator);
        for (ComponentConfig config2 : componentConfigs) {
            this.registerComponents(config2);
        }
        this.myComponentConfigCount = componentConfigs.size();
        if (componentsRegistered != null) {
            componentsRegistered.run();
        }
        this.createComponents(indicator);
        this.myComponentsCreated = true;
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        indicator.setFraction(this.getPercentageOfComponentsLoaded());
    }

    protected final double getPercentageOfComponentsLoaded() {
        return (double)this.myInstantiatedComponentCount / (double)this.myComponentConfigCount;
    }

    protected void createComponents(@Nullable ProgressIndicator indicator) {
        DefaultPicoContainer picoContainer = (DefaultPicoContainer)this.getPicoContainer();
        for (ComponentAdapter componentAdapter : picoContainer.getComponentAdapters()) {
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter)) continue;
            componentAdapter.getComponentInstance((PicoContainer)picoContainer);
            if (indicator == null) continue;
            indicator.checkCanceled();
        }
    }

    @NotNull
    public MessageBus getMessageBus() {
        if (this.myDisposed) {
            this.throwAlreadyDisposed();
        }
        return this.myMessageBus;
    }

    public final boolean isComponentsCreated() {
        return this.myComponentsCreated;
    }

    protected final synchronized void disposeComponents() {
        assert (!this.myDisposeCompleted) : "Already disposed!";
        this.myDisposed = true;
        List<BaseComponent> components = this.myBaseComponents;
        for (int i = components.size() - 1; i >= 0; --i) {
            try {
                components.get(i).disposeComponent();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myBaseComponents.clear();
        this.myComponentConfigCount = -1;
    }

    public final <T> T getComponent(@NotNull Class<T> interfaceClass) {
        MutablePicoContainer picoContainer = this.getPicoContainer();
        ComponentAdapter adapter = picoContainer.getComponentAdapter(interfaceClass);
        if (!(adapter instanceof ComponentConfigComponentAdapter)) {
            return null;
        }
        return (T)adapter.getComponentInstance((PicoContainer)picoContainer);
    }

    public final <T> T getComponent(@NotNull Class<T> interfaceClass, T defaultImplementation) {
        T component = this.getComponent(interfaceClass);
        return component == null ? defaultImplementation : component;
    }

    @Nullable
    protected ProgressIndicator getProgressIndicator() {
        return ProgressManager.getInstance().getProgressIndicator();
    }

    @Override
    public void initializeComponent(@NotNull Object component, boolean service2) {
    }

    protected void handleInitComponentError(Throwable ex, String componentClassName, PluginId pluginId) {
        LOG.error(ex);
    }

    public void registerComponentImplementation(@NotNull Class<?> componentKey, @NotNull Class<?> componentImplementation) {
        this.registerComponentImplementation(componentKey, componentImplementation, false);
    }

    public void registerComponentImplementation(@NotNull Class<?> componentKey, @NotNull Class<?> componentImplementation, boolean shouldBeRegistered) {
        MutablePicoContainer picoContainer = this.getPicoContainer();
        ComponentConfigComponentAdapter adapter = (ComponentConfigComponentAdapter)picoContainer.unregisterComponent(componentKey);
        if (shouldBeRegistered) {
            LOG.assertTrue(adapter != null);
        }
        picoContainer.registerComponent((ComponentAdapter)new ComponentConfigComponentAdapter(componentKey, componentImplementation, null, false));
    }

    public synchronized <T> T registerComponentInstance(@NotNull Class<T> componentKey, @NotNull T componentImplementation) {
        MutablePicoContainer picoContainer = this.getPicoContainer();
        ComponentAdapter adapter = picoContainer.getComponentAdapter(componentKey);
        LOG.assertTrue(adapter instanceof ComponentConfigComponentAdapter);
        ComponentConfigComponentAdapter componentAdapter = (ComponentConfigComponentAdapter)adapter;
        Object oldInstance = componentAdapter.myInitializedComponentInstance;
        componentAdapter.myInitializedComponentInstance = componentImplementation;
        return (T)oldInstance;
    }

    public boolean hasComponent(@NotNull Class interfaceClass) {
        return this.getPicoContainer().getComponentAdapter((Object)interfaceClass) != null;
    }

    @NotNull
    public <T> T[] getComponents(@NotNull Class<T> baseClass) {
        return ArrayUtil.toObjectArray(this.getComponentInstancesOfType(baseClass), baseClass);
    }

    @NotNull
    public final <T> List<T> getComponentInstancesOfType(@NotNull Class<T> baseClass) {
        ArrayList<Object> result2 = null;
        for (ComponentAdapter componentAdapter : ((DefaultPicoContainer)this.getPicoContainer()).getComponentAdapters()) {
            Object instance;
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter) || !ReflectionUtil.isAssignable(baseClass, (Class)componentAdapter.getComponentImplementation()) || (instance = ((ComponentConfigComponentAdapter)componentAdapter).myInitializedComponentInstance) == null) continue;
            if (result2 == null) {
                result2 = new ArrayList<Object>();
            }
            result2.add(instance);
        }
        return ContainerUtil.notNullize(result2);
    }

    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer container = this.myPicoContainer;
        if (container == null || this.myDisposeCompleted) {
            this.throwAlreadyDisposed();
        }
        return container;
    }

    @Contract(value="->fail")
    private void throwAlreadyDisposed() {
        ReadAction.run(() -> {
            ProgressManager.checkCanceled();
            throw new AssertionError((Object)("Already disposed: " + this));
        });
    }

    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        return this.myParentComponentManager == null ? new DefaultPicoContainer() : new DefaultPicoContainer(this.myParentComponentManager.getPicoContainer());
    }

    protected boolean isComponentSuitable(@Nullable Map<String, String> options) {
        return options == null || Extensions.isComponentSuitableForOs((String)options.get("os")) && (!Boolean.parseBoolean(options.get("internal")) || ApplicationManager.getApplication().isInternal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDisposeCompleted = true;
        if (this.myMessageBus != null) {
            Disposer.dispose((Disposable)this.myMessageBus);
            this.myMessageBus = null;
        }
        this.myPicoContainer = null;
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            this.myNameToComponent.clear();
        }
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    private List<ComponentConfig> getComponentConfigs(ProgressIndicator indicator) {
        boolean isDefaultProject = this instanceof Project && ((Project)this).isDefault();
        boolean headless = ApplicationManager.getApplication().isHeadlessEnvironment();
        StartupProgress startupProgress = null;
        if (indicator != null) {
            startupProgress = (message, progress) -> indicator.setFraction((double)progress);
        }
        ArrayList<ComponentConfig> componentConfigs = new ArrayList<ComponentConfig>();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getLoadedPlugins(startupProgress)) {
            List<ComponentConfig> configs = this.getMyComponentConfigsFromDescriptor(plugin);
            componentConfigs.ensureCapacity(componentConfigs.size() + configs.size());
            for (ComponentConfig config2 : configs) {
                if (isDefaultProject && !config2.isLoadForDefaultProject() || !this.isComponentSuitable(config2.options) || !config2.prepareClasses(headless)) continue;
                config2.pluginDescriptor = plugin;
                componentConfigs.add(config2);
            }
        }
        return componentConfigs;
    }

    @NotNull
    public List<ComponentConfig> getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        return plugin.getAppComponents();
    }

    protected void bootstrapPicoContainer(@NotNull String name) {
        MutablePicoContainer picoContainer;
        this.myPicoContainer = picoContainer = this.createPicoContainer();
        this.myMessageBus = MessageBusFactory.newMessageBus((Object)name, this.myParentComponentManager == null ? null : this.myParentComponentManager.getMessageBus());
        picoContainer.registerComponentInstance(MessageBus.class, (Object)this.myMessageBus);
    }

    protected final ComponentManager getParentComponentManager() {
        return this.myParentComponentManager;
    }

    protected final int getComponentConfigCount() {
        return this.myComponentConfigCount;
    }

    @Nullable
    public final PluginId getConfig(@NotNull ComponentAdapter adapter) {
        return adapter instanceof ComponentConfigComponentAdapter ? ((ComponentConfigComponentAdapter)adapter).myPluginId : null;
    }

    public final boolean isWorkspaceComponent(@NotNull Class<?> componentImplementation) {
        ComponentConfigComponentAdapter adapter = this.getComponentAdapter(componentImplementation);
        return adapter != null && adapter.isWorkspaceComponent;
    }

    @Nullable
    private ComponentConfigComponentAdapter getComponentAdapter(@NotNull Class<?> componentImplementation) {
        for (ComponentAdapter componentAdapter : ((DefaultPicoContainer)this.getPicoContainer()).getComponentAdapters()) {
            if (!(componentAdapter instanceof ComponentConfigComponentAdapter) || componentAdapter.getComponentImplementation() != componentImplementation) continue;
            return (ComponentConfigComponentAdapter)componentAdapter;
        }
        return null;
    }

    @NotNull
    public final Condition<?> getDisposed() {
        return this.myDisposedCondition;
    }

    @NotNull
    public static String getComponentName(@NotNull Object component) {
        if (component instanceof NamedComponent) {
            return ((NamedComponent)component).getComponentName();
        }
        return component.getClass().getName();
    }

    protected boolean logSlowComponents() {
        return LOG.isDebugEnabled();
    }

    private void registerComponents(@NotNull ComponentConfig config2) {
        ClassLoader loader = config2.getClassLoader();
        try {
            Class<?> interfaceClass = Class.forName(config2.getInterfaceClass(), true, loader);
            Class<?> implementationClass = Comparing.equal((String)config2.getInterfaceClass(), (String)config2.getImplementationClass()) ? interfaceClass : (StringUtil.isEmpty((String)config2.getImplementationClass()) ? null : Class.forName(config2.getImplementationClass(), true, loader));
            MutablePicoContainer picoContainer = this.getPicoContainer();
            if (config2.options != null && Boolean.parseBoolean((String)config2.options.get("overrides"))) {
                ComponentAdapter oldAdapter = picoContainer.getComponentAdapterOfType(interfaceClass);
                if (oldAdapter == null) {
                    throw new RuntimeException(config2 + " does not override anything");
                }
                picoContainer.unregisterComponent(oldAdapter.getComponentKey());
            }
            if (implementationClass != null) {
                boolean ws = config2.options != null && Boolean.parseBoolean((String)config2.options.get("workspace"));
                picoContainer.registerComponent((ComponentAdapter)new ComponentConfigComponentAdapter(interfaceClass, implementationClass, config2.getPluginId(), ws));
            }
        }
        catch (Throwable t) {
            this.handleInitComponentError(t, null, config2.getPluginId());
        }
    }

    private void registerComponentInstance(@NotNull Object instance) {
        ++this.myInstantiatedComponentCount;
        if (instance instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)instance));
        }
        if (!(instance instanceof BaseComponent)) {
            return;
        }
        BaseComponent baseComponent = (BaseComponent)instance;
        String componentName = baseComponent.getComponentName();
        if (this.myNameToComponent.containsKey(componentName)) {
            BaseComponent loadedComponent = this.myNameToComponent.get(componentName);
            if (!instance.equals(loadedComponent)) {
                String errorMessage = "Component name collision: " + componentName + " " + (loadedComponent == null ? "null" : loadedComponent.getClass()) + " and " + instance.getClass();
                PluginException.logPluginError((Logger)LOG, (String)errorMessage, null, instance.getClass());
            }
        } else {
            this.myNameToComponent.put(componentName, baseComponent);
        }
        this.myBaseComponents.add(baseComponent);
    }

    public synchronized BaseComponent getComponent(@NotNull String name) {
        return this.myNameToComponent.get(name);
    }

    private final class ComponentConfigComponentAdapter
    extends CachingConstructorInjectionComponentAdapter {
        private final PluginId myPluginId;
        private volatile Object myInitializedComponentInstance;
        private boolean myInitializing;
        final boolean isWorkspaceComponent;

        ComponentConfigComponentAdapter(@NotNull Class<?> interfaceClass, @Nullable Class<?> implementationClass, PluginId pluginId, boolean isWorkspaceComponent) {
            super(interfaceClass, implementationClass, null, true);
            this.myPluginId = pluginId;
            this.isWorkspaceComponent = isWorkspaceComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getComponentInstance(@NotNull PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, ProcessCanceledException {
            Object instance = this.myInitializedComponentInstance;
            if (instance != null || ComponentManagerImpl.this.myDisposed) {
                return instance;
            }
            try {
                ComponentConfigComponentAdapter componentConfigComponentAdapter = this;
                synchronized (componentConfigComponentAdapter) {
                    instance = this.myInitializedComponentInstance;
                    if (instance != null) {
                        return instance;
                    }
                    long startTime = System.nanoTime();
                    instance = super.getComponentInstance(picoContainer);
                    if (this.myInitializing) {
                        String errorMessage = "Cyclic component initialization: " + this.getComponentKey();
                        if (this.myPluginId != null) {
                            LOG.error((Throwable)new PluginException(errorMessage, this.myPluginId));
                        } else {
                            LOG.error(new Throwable(errorMessage));
                        }
                    }
                    try {
                        long ms;
                        this.myInitializing = true;
                        ComponentManagerImpl.this.registerComponentInstance(instance);
                        ProgressIndicator indicator = ComponentManagerImpl.this.getProgressIndicator();
                        if (indicator != null) {
                            indicator.setIndeterminate(false);
                            indicator.checkCanceled();
                            ComponentManagerImpl.this.setProgressDuringInit(indicator);
                        }
                        ComponentManagerImpl.this.initializeComponent(instance, false);
                        if (instance instanceof BaseComponent) {
                            ((BaseComponent)instance).initComponent();
                        }
                        if ((ms = (System.nanoTime() - startTime) / 1000000L) > 10L && ComponentManagerImpl.this.logSlowComponents()) {
                            LOG.info(instance.getClass().getName() + " initialized in " + ms + " ms");
                        }
                    }
                    finally {
                        this.myInitializing = false;
                    }
                    this.myInitializedComponentInstance = instance;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                ComponentManagerImpl.this.handleInitComponentError(t, ((Class)this.getComponentKey()).getName(), this.myPluginId);
            }
            return instance;
        }

        public String toString() {
            return "ComponentConfigAdapter[" + this.getComponentKey() + "]: implementation=" + this.getComponentImplementation() + ", plugin=" + this.myPluginId;
        }
    }
}

