/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class ModulePathMacroManager
extends PathMacroManager {
    private final Module myModule;

    public ModulePathMacroManager(@NotNull PathMacros pathMacros, @NotNull Module module) {
        super(pathMacros);
        this.myModule = module;
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result2 = super.getExpandMacroMap();
        ModulePathMacroManager.addFileHierarchyReplacements(result2, "MODULE_DIR", PathMacroUtil.getModuleDir((String)this.myModule.getModuleFilePath()));
        return result2;
    }

    @Override
    @NotNull
    public ReplacePathToMacroMap computeReplacePathMap() {
        ReplacePathToMacroMap result2 = super.computeReplacePathMap();
        String modulePath = PathMacroUtil.getModuleDir((String)this.myModule.getModuleFilePath());
        ModulePathMacroManager.addFileHierarchyReplacements(result2, "MODULE_DIR", modulePath, PathMacroUtil.getUserHomePath());
        return result2;
    }
}

