/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.InstanceComponentAdapter;

public class ServiceManagerImpl
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ServiceManagerImpl.class);
    private static final ExtensionPointName<ServiceDescriptor> APP_SERVICES = new ExtensionPointName("com.intellij.applicationService");
    private static final ExtensionPointName<ServiceDescriptor> PROJECT_SERVICES = new ExtensionPointName("com.intellij.projectService");
    private ExtensionPointName<ServiceDescriptor> myExtensionPointName;

    public ServiceManagerImpl() {
        this.installEP(APP_SERVICES, (ComponentManager)ApplicationManager.getApplication());
    }

    public ServiceManagerImpl(Project project) {
        this.installEP(PROJECT_SERVICES, (ComponentManager)project);
    }

    protected ServiceManagerImpl(boolean ignoreInit) {
    }

    protected final void installEP(@NotNull ExtensionPointName<ServiceDescriptor> point, final @NotNull ComponentManager componentManager) {
        LOG.assertTrue(this.myExtensionPointName == null, (Object)("Already called installEP with " + this.myExtensionPointName));
        this.myExtensionPointName = point;
        final MutablePicoContainer picoContainer = (MutablePicoContainer)componentManager.getPicoContainer();
        point.getPoint(null).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ServiceDescriptor>(){

            public void extensionAdded(@NotNull ServiceDescriptor descriptor, @Nullable PluginDescriptor pluginDescriptor) {
                ComponentAdapter oldAdapter;
                if (descriptor.overrides && (oldAdapter = picoContainer.unregisterComponent((Object)descriptor.getInterface())) == null) {
                    throw new PluginException("Service: " + descriptor.getInterface() + " doesn't override anything", pluginDescriptor != null ? pluginDescriptor.getPluginId() : null);
                }
                if (!StringUtil.isEmpty((String)descriptor.getImplementation())) {
                    picoContainer.registerComponent((ComponentAdapter)new MyComponentAdapter(descriptor, pluginDescriptor, (ComponentManagerEx)componentManager));
                }
            }

            public void extensionRemoved(@NotNull ServiceDescriptor extension, PluginDescriptor pluginDescriptor) {
                picoContainer.unregisterComponent((Object)extension.getInterface());
            }
        }, true, (Disposable)this);
    }

    @NotNull
    public List<ServiceDescriptor> getAllDescriptors() {
        return this.myExtensionPointName.getExtensionList();
    }

    public static void processAllImplementationClasses(@NotNull ComponentManagerImpl componentManager, @NotNull BiPredicate<? super Class<?>, ? super PluginDescriptor> processor2) {
        Collection adapters = componentManager.getPicoContainer().getComponentAdapters();
        if (adapters.isEmpty()) {
            return;
        }
        for (ComponentAdapter o : adapters) {
            PluginId pluginId;
            Class<?> aClass;
            if (o instanceof MyComponentAdapter) {
                MyComponentAdapter adapter = (MyComponentAdapter)o;
                PluginDescriptor pluginDescriptor = adapter.myPluginDescriptor;
                try {
                    ComponentAdapter delegate = adapter.myDelegate;
                    if (delegate == null) {
                        ClassLoader classLoader = pluginDescriptor == null ? ServiceManagerImpl.class.getClassLoader() : pluginDescriptor.getPluginClassLoader();
                        aClass = Class.forName(adapter.myDescriptor.getImplementation(), false, classLoader);
                    } else {
                        aClass = delegate.getComponentImplementation();
                    }
                }
                catch (Throwable e) {
                    if (PlatformUtils.isIdeaUltimate()) {
                        LOG.error(e);
                        continue;
                    }
                    LOG.warn(e);
                    continue;
                }
                if (processor2.test(aClass, (PluginDescriptor)pluginDescriptor)) continue;
                break;
            }
            if (o instanceof ExtensionComponentAdapter || (pluginId = componentManager.getConfig(o)) == null && !(o instanceof InstanceComponentAdapter)) continue;
            try {
                aClass = o.getComponentImplementation();
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (processor2.test(aClass, (PluginDescriptor)(pluginId == null ? null : PluginManager.getPlugin(pluginId)))) continue;
            break;
        }
    }

    public void dispose() {
    }

    private static class MyComponentAdapter
    implements AssignableToComponentAdapter,
    DefaultPicoContainer.LazyComponentAdapter {
        private ComponentAdapter myDelegate;
        private final ServiceDescriptor myDescriptor;
        private final PluginDescriptor myPluginDescriptor;
        private final ComponentManagerEx myComponentManager;
        private volatile Object myInitializedComponentInstance;

        MyComponentAdapter(ServiceDescriptor descriptor, PluginDescriptor pluginDescriptor, ComponentManagerEx componentManager) {
            this.myDescriptor = descriptor;
            this.myPluginDescriptor = pluginDescriptor;
            this.myComponentManager = componentManager;
            this.myDelegate = null;
        }

        public String getComponentKey() {
            return this.myDescriptor.getInterface();
        }

        public Class getComponentImplementation() {
            return this.getDelegate().getComponentImplementation();
        }

        public boolean isComponentInstantiated() {
            return this.myInitializedComponentInstance != null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getComponentInstance(@NotNull PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
            Object instance = this.myInitializedComponentInstance;
            if (instance != null) {
                return instance;
            }
            MyComponentAdapter myComponentAdapter = this;
            synchronized (myComponentAdapter) {
                instance = this.myInitializedComponentInstance;
                if (instance != null) {
                    return instance;
                }
                String implementation = this.myDescriptor.getImplementation();
                if (LOG.isDebugEnabled() && ApplicationManager.getApplication().isWriteAccessAllowed() && !ApplicationManager.getApplication().isUnitTestMode() && PersistentStateComponent.class.isAssignableFrom(this.getDelegate().getComponentImplementation())) {
                    LOG.warn(new Throwable("Getting service from write-action leads to possible deadlock. Service implementation " + implementation));
                }
                try (AccessToken ignore = HeavyProcessLatch.INSTANCE.processStarted("Creating component '" + implementation + "'");){
                    Runnable runnable2 = () -> {
                        this.myInitializedComponentInstance = this.createAndInitialize(container);
                    };
                    if (ProgressIndicatorProvider.getGlobalProgressIndicator() != null) {
                        ProgressManager.getInstance().executeNonCancelableSection(runnable2);
                    } else {
                        runnable2.run();
                    }
                    Object object = this.myInitializedComponentInstance;
                    return object;
                }
            }
        }

        @NotNull
        private Object createAndInitialize(@NotNull PicoContainer container) {
            Object instance = this.getDelegate().getComponentInstance(container);
            if (instance instanceof Disposable) {
                Disposer.register((Disposable)this.myComponentManager, (Disposable)((Disposable)instance));
            }
            this.myComponentManager.initializeComponent(instance, true);
            return instance;
        }

        @NotNull
        private synchronized ComponentAdapter getDelegate() {
            if (this.myDelegate == null) {
                Class<?> implClass;
                try {
                    ClassLoader classLoader = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
                    implClass = Class.forName(this.myDescriptor.getImplementation(), true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException("Failed to load class", (Throwable)e, this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginId() : null);
                }
                this.myDelegate = new CachingConstructorInjectionComponentAdapter((Object)this.getComponentKey(), implClass, null, true);
            }
            return this.myDelegate;
        }

        public void verify(PicoContainer container) throws PicoIntrospectionException {
            this.getDelegate().verify(container);
        }

        public void accept(PicoVisitor visitor) {
            visitor.visitComponentAdapter((ComponentAdapter)this);
        }

        public String getAssignableToClassName() {
            return this.myDescriptor.getInterface();
        }

        public String toString() {
            return "ServiceComponentAdapter[" + this.myDescriptor.getInterface() + "]: implementation=" + this.myDescriptor.getImplementation() + ", plugin=" + this.myPluginDescriptor;
        }
    }
}

