/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.actions.BaseDiffAction;
import com.intellij.openapi.diff.ex.DiffContentFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2019.2")
public class CompareFiles
extends BaseDiffAction {
    public static final DataKey<DiffRequest> DIFF_REQUEST = DataKey.create((String)"CompareFiles.DiffRequest");

    @Override
    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        boolean canShow = CompareFiles.isAvailable(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(canShow);
        } else {
            presentation.setVisible(true);
            presentation.setEnabled(canShow);
        }
    }

    private static boolean isAvailable(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        DiffRequest diffRequest = (DiffRequest)e.getData(DIFF_REQUEST);
        if (diffRequest == null) {
            VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFiles == null || virtualFiles.length != 2) {
                return false;
            }
            diffRequest = CompareFiles.getDiffRequest(project, virtualFiles);
        }
        if (diffRequest == null) {
            return false;
        }
        return DiffManager.getInstance().getDiffTool().canShow(diffRequest);
    }

    @Override
    protected DiffRequest getDiffData(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        DiffRequest diffRequest = (DiffRequest)DIFF_REQUEST.getData(dataContext);
        if (diffRequest != null) {
            return diffRequest;
        }
        VirtualFile[] data = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (data == null || data.length != 2) {
            return null;
        }
        return CompareFiles.getDiffRequest(project, data);
    }

    @Nullable
    private static DiffRequest getDiffRequest(Project project, VirtualFile[] files2) {
        if (files2 == null || files2.length != 2) {
            return null;
        }
        if (files2[0].isDirectory() || files2[1].isDirectory() || files2[0].getFileType() instanceof ArchiveFileType || files2[1].getFileType() instanceof ArchiveFileType) {
            return null;
        }
        String title = DiffBundle.message((String)"diff.element.qualified.name.vs.element.qualified.name.dialog.title", (Object[])new Object[]{CompareFiles.getVirtualFileContentTitle(files2[0]), CompareFiles.getVirtualFileContentTitle(files2[1])});
        SimpleDiffRequest diffRequest = DiffContentFactory.compareVirtualFiles(project, files2[0], files2[1], title);
        if (diffRequest == null) {
            return null;
        }
        diffRequest.setContentTitles(CompareFiles.getVirtualFileContentTitle(files2[0]), CompareFiles.getVirtualFileContentTitle(files2[1]));
        return diffRequest;
    }
}

