/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.diff.DiffTool;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import org.jetbrains.annotations.NotNull;

public class DiffUsageTriggerCollector {
    private static void trigger(@NotNull String feature) {
        FUCounterUsageLogger.getInstance().logEvent("vcs.diff.trigger", feature);
    }

    public static void trigger(@NotNull String feature, @NotNull Enum value) {
        DiffUsageTriggerCollector.trigger(feature + "." + value.name());
    }

    public static void trigger(@NotNull String feature, @NotNull DiffTool diffTool) {
        DiffUsageTriggerCollector.trigger(feature + "." + DiffUsageTriggerCollector.getDiffToolName(diffTool));
    }

    @NotNull
    private static String getDiffToolName(@NotNull DiffTool diffTool) {
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(diffTool.getClass());
        if (pluginInfo.isDevelopedByJetBrains()) {
            return diffTool.getName();
        }
        if (pluginInfo.isSafeToReport()) {
            return "third.party." + pluginInfo.getId();
        }
        return "third.party.other";
    }
}

