/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffErrorElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.diff.impl.dir.ComparableDiffElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.SortedList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DTree {
    private static final Comparator<DTree> COMPARATOR = (o1, o2) -> {
        boolean b1 = o1.isContainer();
        boolean b2 = o2.isContainer();
        return b1 && b2 || !b1 && !b2 ? o1.getName().compareToIgnoreCase(o2.getName()) : (b1 ? 1 : -1);
    };
    private boolean myExpanded = true;
    @Nullable
    private final DTree myParent;
    private HashMap<String, DTree> myChildren;
    private final String myName;
    private final boolean isContainer;
    private SortedList<DTree> myChildrenList;
    private DiffElement<?> mySource;
    private DiffElement<?> myTarget;
    private DiffType myType;
    private boolean myVisible = true;
    private String myPath = null;

    public DTree(@Nullable DTree parent, @NotNull String name, boolean container) {
        this.myParent = parent;
        this.myName = name;
        this.isContainer = container;
    }

    @NotNull
    public Collection<DTree> getChildren() {
        this.init();
        if (this.myChildrenList == null) {
            this.myChildrenList = new SortedList(COMPARATOR);
            this.myChildrenList.addAll(this.myChildren.values());
        }
        return this.myChildrenList;
    }

    public DTree addChild(@NotNull DiffElement element, boolean source, String replacementName) {
        DTree node;
        this.init();
        this.myChildrenList = null;
        String name = element.getName();
        if (replacementName != null && this.myChildren.containsKey(replacementName)) {
            node = this.myChildren.get(replacementName);
        } else if (this.myChildren.containsKey(name)) {
            node = this.myChildren.get(name);
        } else {
            node = new DTree(this, element.getPresentableName(), element.isContainer());
            this.myChildren.put(name, node);
        }
        if (source) {
            node.setSource(element);
        } else {
            node.setTarget(element);
        }
        return node;
    }

    public DiffElement<?> getSource() {
        return this.mySource;
    }

    public void setSource(DiffElement<?> source) {
        this.mySource = source;
    }

    public DiffElement<?> getTarget() {
        return this.myTarget;
    }

    public void setTarget(DiffElement<?> target2) {
        this.myTarget = target2;
    }

    private void init() {
        if (this.myChildren == null) {
            this.myChildren = new HashMap();
        }
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public DTree getParent() {
        return this.myParent;
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public String toString() {
        return this.myName;
    }

    private void prepare() {
        DiffElement<?> src = this.getSource();
        DiffElement<?> trg = this.getTarget();
        if (src instanceof ComparableDiffElement) {
            ((ComparableDiffElement)src).prepare(trg);
        }
        if (trg instanceof ComparableDiffElement) {
            ((ComparableDiffElement)trg).prepare(src);
        }
        for (DTree tree : this.getChildren()) {
            tree.prepare();
        }
    }

    public void update(DirDiffSettings settings) {
        this.prepare();
        this.updateChildren(settings);
    }

    private void updateChildren(DirDiffSettings settings) {
        for (DTree tree : this.getChildren()) {
            DiffElement<?> src = tree.getSource();
            DiffElement<?> trg = tree.getTarget();
            if (src instanceof DiffErrorElement || trg instanceof DiffErrorElement) {
                tree.setType(DiffType.ERROR);
            } else if (src == null && trg != null) {
                tree.setType(DiffType.TARGET);
            } else if (src != null && trg == null) {
                tree.setType(DiffType.SOURCE);
            } else {
                assert (src != null);
                Boolean equals = null;
                if (src instanceof ComparableDiffElement) {
                    equals = ((ComparableDiffElement)src).isContentEqual(trg);
                }
                if (equals == null && trg instanceof ComparableDiffElement) {
                    equals = ((ComparableDiffElement)trg).isContentEqual(src);
                }
                if (equals == null) {
                    switch (settings.compareMode) {
                        case CONTENT: {
                            equals = DTree.isEqualContents(src, trg);
                            break;
                        }
                        case TEXT: {
                            equals = DTree.isEqualContentsAsText(src, trg);
                            break;
                        }
                        case SIZE: {
                            equals = DTree.isEqualSizes(src, trg);
                            break;
                        }
                        case TIMESTAMP: {
                            equals = DTree.isEqualTimestamps(src, trg, settings);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(settings.compareMode.name());
                        }
                    }
                }
                tree.setType(equals != false ? DiffType.EQUAL : DiffType.CHANGED);
            }
            tree.updateChildren(settings);
        }
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void updateVisibility(DirDiffSettings settings) {
        if (this.getChildren().isEmpty()) {
            if (this.myType == DiffType.ERROR) {
                this.myVisible = true;
                return;
            }
            if (this.myType != DiffType.SEPARATOR && !"".equals(settings.getFilter()) && !settings.getFilterPattern().matcher(this.getName()).matches()) {
                this.myVisible = false;
                return;
            }
            if (this.myType == null) {
                this.myVisible = true;
            } else {
                switch (this.myType) {
                    case SOURCE: {
                        this.myVisible = settings.showNewOnSource;
                        break;
                    }
                    case TARGET: {
                        this.myVisible = settings.showNewOnTarget;
                        break;
                    }
                    case SEPARATOR: 
                    case ERROR: {
                        this.myVisible = true;
                        break;
                    }
                    case CHANGED: {
                        this.myVisible = settings.showDifferent;
                        break;
                    }
                    case EQUAL: {
                        this.myVisible = settings.showEqual;
                    }
                }
            }
        } else {
            this.myVisible = false;
            for (DTree child2 : this.myChildren.values()) {
                child2.updateVisibility(settings);
                this.myVisible = this.myVisible || child2.isVisible();
            }
        }
    }

    public void reset() {
        this.myChildren.clear();
    }

    public void remove(DTree node) {
        this.init();
        boolean removed = this.myChildrenList.remove((Object)node);
        if (removed) {
            for (String key : this.myChildren.keySet()) {
                if (this.myChildren.get(key) != node) continue;
                this.myChildren.remove(key);
                return;
            }
        }
    }

    private static boolean isEqualSizes(DiffElement<?> file1, DiffElement<?> file2) {
        return file1.getSize() == file2.getSize();
    }

    private static boolean isEqualTimestamps(DiffElement<?> src, DiffElement<?> trg, DirDiffSettings settings) {
        if (src.getSize() != trg.getSize()) {
            return false;
        }
        return (double)Math.abs(src.getTimeStamp() - trg.getTimeStamp()) <= settings.compareTimestampAccuracy;
    }

    private static boolean isEqualContents(DiffElement<?> file1, DiffElement<?> file2) {
        if (file1.isContainer() || file2.isContainer()) {
            return false;
        }
        if (file1.getSize() != file2.getSize()) {
            return false;
        }
        try {
            return Arrays.equals(file1.getContent(), file2.getContent());
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isEqualContentsAsText(DiffElement<?> file1, DiffElement<?> file2) {
        if (file1.isContainer() || file2.isContainer()) {
            return false;
        }
        if (file1.getFileType().isBinary() || file2.getFileType().isBinary()) {
            return DTree.isEqualContents(file1, file2);
        }
        try {
            byte[] content1 = file1.getContent();
            byte[] content2 = file2.getContent();
            if (Arrays.equals(content1, content2)) {
                return true;
            }
            if (content1 == null || content2 == null) {
                return false;
            }
            String text1 = CharsetToolkit.tryDecodeString((byte[])content1, (Charset)file1.getCharset());
            if (text1 == null) {
                return false;
            }
            String text2 = CharsetToolkit.tryDecodeString((byte[])content2, (Charset)file2.getCharset());
            if (text2 == null) {
                return false;
            }
            String convertedText1 = StringUtil.convertLineSeparators((String)text1);
            String convertedText2 = StringUtil.convertLineSeparators((String)text2);
            return StringUtil.equals((CharSequence)convertedText1, (CharSequence)convertedText2);
        }
        catch (IOException e) {
            return false;
        }
    }

    public DiffType getType() {
        return this.myType;
    }

    public void setType(DiffType type) {
        this.myType = type;
    }

    public String getPath() {
        if (this.myPath == null) {
            DTree parent = this.getParent();
            this.myPath = parent != null ? parent.getPath() + this.getName() + (this.isContainer ? DiffElement.getSeparator() : "") : this.getName() + (this.isContainer ? DiffElement.getSeparator() : "");
        }
        return this.myPath;
    }
}

