/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions.popup;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.popup.SetOperationToBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompareNewFilesWithEachOtherAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DirDiffTableModel model = SetOperationToBase.getModel(e);
        if (model == null) {
            return;
        }
        Couple<DirDiffElementImpl> couple = CompareNewFilesWithEachOtherAction.getSelectedSourceAndTarget(model);
        if (couple == null) {
            return;
        }
        model.setReplacement((DirDiffElementImpl)couple.first, (DirDiffElementImpl)couple.second);
        model.reloadModel(false);
    }

    public void update(@NotNull AnActionEvent e) {
        Couple<DirDiffElementImpl> target2;
        DirDiffTableModel model = SetOperationToBase.getModel(e);
        if (model != null && (target2 = CompareNewFilesWithEachOtherAction.getSelectedSourceAndTarget(model)) != null) {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setDescription("Compare '" + ((DirDiffElementImpl)target2.first).getSourcePresentableName() + "' with '" + ((DirDiffElementImpl)target2.second).getTargetPresentableName() + "'");
            return;
        }
        e.getPresentation().setDescription("Compare selected new files on the left side and on the right side with each other.");
        e.getPresentation().setEnabled(false);
    }

    private static Couple<DirDiffElementImpl> getSelectedSourceAndTarget(DirDiffTableModel model) {
        List<DirDiffElementImpl> elements = model.getSelectedElements();
        if (elements.size() != 2) {
            return null;
        }
        DirDiffElementImpl source = (DirDiffElementImpl)ContainerUtil.find(elements, DirDiffElementImpl::isSource);
        DirDiffElementImpl target2 = (DirDiffElementImpl)ContainerUtil.find(elements, DirDiffElementImpl::isTarget);
        if (source == null || target2 == null || source.getParentNode() != target2.getParentNode()) {
            return null;
        }
        return Couple.of((Object)source, (Object)target2);
    }
}

