/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BaseRevisionTextPatchEP
implements PatchEP {
    public static final Key<Boolean> ourPutBaseRevisionTextKey = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey");
    public static final Key<List<FilePath>> ourBaseRevisionPaths = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourBaseRevisionPaths");
    public static final Key<Map<String, String>> ourStoredTexts = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourStoredTexts");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP");
    private final ChangeListManager myChangeListManager;
    private final String myBaseDir;

    public BaseRevisionTextPatchEP(Project project) {
        this.myBaseDir = project.getBasePath();
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
    }

    @NotNull
    public String getName() {
        return "com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP";
    }

    public CharSequence provideContent(@NotNull String path, CommitContext commitContext) {
        if (commitContext == null) {
            return null;
        }
        if (Boolean.TRUE.equals(commitContext.getUserData(ourPutBaseRevisionTextKey))) {
            File file2 = new File(this.myBaseDir, path);
            FilePath filePathOn = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file2);
            Change change = this.myChangeListManager.getChange(filePathOn);
            List paths = (List)commitContext.getUserData(ourBaseRevisionPaths);
            if (change == null || change.getBeforeRevision() == null || paths == null || !paths.contains(filePathOn)) {
                return null;
            }
            try {
                return change.getBeforeRevision().getContent();
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            Map map2 = (Map)commitContext.getUserData(ourStoredTexts);
            if (map2 != null) {
                File file3 = new File(this.myBaseDir, path);
                return (CharSequence)map2.get(file3.getPath());
            }
        }
        return null;
    }

    public void consumeContent(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
    }

    public void consumeContentBeforePatchApplied(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
        if (commitContext == null) {
            return;
        }
        HashMap<String, String> map2 = (HashMap<String, String>)commitContext.getUserData(ourStoredTexts);
        if (map2 == null) {
            map2 = new HashMap<String, String>();
            commitContext.putUserData(ourStoredTexts, map2);
        }
        File file2 = new File(this.myBaseDir, path);
        map2.put(file2.getPath(), content.toString());
    }
}

