/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CharsetEP
implements PatchEP {
    private static final Key<Map<String, String>> ourName = Key.create((String)"Charset");
    private final String myBaseDir;

    public CharsetEP(Project project) {
        this.myBaseDir = project.getBasePath();
    }

    @NotNull
    public String getName() {
        return "com.intellij.openapi.diff.impl.patch.CharsetEP";
    }

    public CharSequence provideContent(@NotNull String path, CommitContext commitContext) {
        File file2 = new File(this.myBaseDir, path);
        VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        if (vf == null) {
            return null;
        }
        String charsetName = vf.getCharset().name();
        return charsetName;
    }

    public void consumeContent(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
    }

    public void consumeContentBeforePatchApplied(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
        if (commitContext == null) {
            return;
        }
        HashMap<String, String> map2 = (HashMap<String, String>)commitContext.getUserData(ourName);
        if (map2 == null) {
            map2 = new HashMap<String, String>();
            commitContext.putUserData(ourName, map2);
        }
        File file2 = new File(this.myBaseDir, path);
        map2.put(FilePathsHelper.convertPath((String)file2.getPath()), content.toString());
    }

    public static String getCharset(String path, CommitContext commitContext) {
        if (commitContext == null) {
            return null;
        }
        Map userData = (Map)commitContext.getUserData(ourName);
        return userData == null ? null : (String)userData.get(FilePathsHelper.convertPath((String)path));
    }
}

