/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BinaryPatchContentParser;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPatchParser {
    @NonNls
    private static final String DIFF_GIT_HEADER_LINE = "diff --git";
    @NonNls
    private static final Pattern ourGitHeaderLinePattern = Pattern.compile("diff --git\\s+(\\S+)\\s+(\\S+).*");
    @NonNls
    private static final Pattern ourIndexHeaderLinePattern = Pattern.compile("index\\s+([0-9a-fA-F]+)..([0-9a-fA-F]+).*");
    @NonNls
    private static final Pattern ourFileStatusPattern = Pattern.compile("\\s*(new|deleted)\\s+file\\s+mode\\s*(\\d*)\\s*");
    @NonNls
    private static final Pattern ourNewFileModePattern = Pattern.compile("\\s*new\\s+mode\\s*(\\d+)\\s*");
    @NonNls
    private static final String ourGitBinaryContentStart = "GIT binary patch";
    private static final Logger LOG = Logger.getInstance(GitPatchParser.class);

    public static FilePatch parse(@NotNull String start2, @NotNull ListIterator<String> iterator, boolean saveHunks) throws PatchSyntaxException {
        TextFilePatch patch = null;
        PatchReader.PatchContentParser contentParser = new PatchReader.PatchContentParser(saveHunks);
        PatchInfo patchInfo = GitPatchParser.parseGitHeader(start2, iterator, contentParser);
        if (iterator.hasNext()) {
            String next = iterator.next();
            if (next.startsWith(ourGitBinaryContentStart)) {
                patch = BinaryPatchContentParser.readGitBinaryFormatPatch(iterator, patchInfo.myFileStatus);
            } else if (next.startsWith(DIFF_GIT_HEADER_LINE)) {
                patch = new TextFilePatch(null);
                iterator.previous();
            } else if (contentParser.testIsStart(next)) {
                patch = contentParser.readTextPatch(next, iterator, true);
            }
        }
        if (patch == null) {
            patch = new TextFilePatch(null);
        }
        GitPatchParser.applyPatchInfo(patch, patchInfo);
        return patch;
    }

    private static PatchInfo parseGitHeader(@NotNull String startLine, @NotNull ListIterator<String> iterator, @NotNull PatchReader.PatchContentParser contentParser) throws PatchSyntaxException {
        Couple<String> beforeAfterName = GitPatchParser.parseNamesFromGitHeaderLine(startLine);
        FileStatus parsedStatus = FileStatus.MODIFIED;
        int newFileMode = -1;
        Couple sha1Indexes = null;
        if (beforeAfterName == null) {
            throw new PatchSyntaxException(iterator.previousIndex(), "Can't detect file names from git format header line");
        }
        while (iterator.hasNext()) {
            String next = iterator.next();
            Matcher indexMatcher = ourIndexHeaderLinePattern.matcher(next);
            Matcher fileStatusMatcher = ourFileStatusPattern.matcher(next);
            Matcher fileModeMatcher = ourNewFileModePattern.matcher(next);
            try {
                if (fileStatusMatcher.matches()) {
                    parsedStatus = GitPatchParser.parseFileStatus(fileStatusMatcher.group(1));
                    String additionalModeInfo = fileStatusMatcher.group(2);
                    if (StringUtil.isEmptyOrSpaces((String)additionalModeInfo) || parsedStatus != FileStatus.ADDED) continue;
                    newFileMode = Integer.parseInt(additionalModeInfo);
                    continue;
                }
                if (fileModeMatcher.matches()) {
                    newFileMode = Integer.parseInt(fileModeMatcher.group(1));
                    continue;
                }
                if (indexMatcher.matches()) {
                    sha1Indexes = Couple.of((Object)indexMatcher.group(1), (Object)indexMatcher.group(2));
                    continue;
                }
                if (!contentParser.testIsStart(next) && !next.startsWith(ourGitBinaryContentStart)) continue;
                iterator.previous();
                break;
            }
            catch (NumberFormatException e) {
                LOG.debug("Can't parse file mode from " + next);
            }
        }
        return new PatchInfo(beforeAfterName, sha1Indexes, parsedStatus, newFileMode);
    }

    private static void applyPatchInfo(@NotNull FilePatch patch, @NotNull PatchInfo patchInfo) {
        patch.setBeforeName(patchInfo.myBeforeName);
        patch.setAfterName(patchInfo.myAfterName);
        patch.setBeforeVersionId(patchInfo.myBeforeIndex);
        patch.setAfterVersionId(patchInfo.myAfterIndex);
        patch.setNewFileMode(patchInfo.myNewFileMode);
    }

    @Nullable
    private static Couple<String> parseNamesFromGitHeaderLine(@NotNull String start2) {
        Matcher m = ourGitHeaderLinePattern.matcher(start2);
        return m.matches() ? Couple.of((Object)PatchReader.PatchContentParser.stripPatchNameIfNeeded(m.group(1), true, true), (Object)PatchReader.PatchContentParser.stripPatchNameIfNeeded(m.group(2), true, false)) : null;
    }

    @NotNull
    private static FileStatus parseFileStatus(@NotNull String status) {
        if (status.startsWith("new")) {
            return FileStatus.ADDED;
        }
        if (status.startsWith("deleted")) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    private static class PatchInfo {
        @Nullable
        private final String myBeforeName;
        @Nullable
        private final String myAfterName;
        @Nullable
        private final String myBeforeIndex;
        @Nullable
        private final String myAfterIndex;
        private final int myNewFileMode;
        @NotNull
        private final FileStatus myFileStatus;

        private PatchInfo(@NotNull Couple<String> beforeAfterName, @Nullable Couple<String> indexes, @NotNull FileStatus status, int newFileMode) {
            this.myBeforeName = (String)beforeAfterName.first;
            this.myAfterName = (String)beforeAfterName.second;
            this.myBeforeIndex = (String)Pair.getFirst(indexes);
            this.myAfterIndex = (String)Pair.getSecond(indexes);
            this.myNewFileMode = newFileMode;
            this.myFileStatus = status;
        }
    }
}

