/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.diff.util.IntPair;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.apply.PlainSimplePatchApplier;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericPatchApplier {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier");
    private static final int ourMaxWalk = 1000;
    private final TreeMap<TextRange, MyAppliedData> myTransformations;
    private final List<String> myLines;
    private final List<? extends PatchHunk> myHunks;
    private final boolean myBaseFileEndsWithNewLine;
    private boolean myHadAlreadyAppliedMet;
    private final ArrayList<SplitHunk> myNotBound;
    private final ArrayList<SplitHunk> myNotExact;
    private boolean mySuppressNewLineInEnd;
    @NotNull
    private final List<AppliedTextPatch.AppliedSplitPatchHunk> myAppliedInfo;
    private static final IntPair EMPTY_OFFSET = new IntPair(0, 0);

    private static void debug(String s) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(s);
        }
    }

    public GenericPatchApplier(CharSequence text, List<? extends PatchHunk> hunks) {
        GenericPatchApplier.debug("GenericPatchApplier created, hunks: " + hunks.size());
        this.myLines = new ArrayList<String>();
        Collections.addAll(this.myLines, LineTokenizer.tokenize((CharSequence)text, (boolean)false));
        this.myBaseFileEndsWithNewLine = StringUtil.endsWithLineBreak((CharSequence)text);
        this.myHunks = hunks;
        Comparator<TextRange> textRangeComparator = Comparator.comparingInt(TextRange::getStartOffset);
        this.myTransformations = new TreeMap(textRangeComparator);
        this.myNotExact = new ArrayList();
        this.myNotBound = new ArrayList();
        this.myAppliedInfo = new ArrayList<AppliedTextPatch.AppliedSplitPatchHunk>();
    }

    @Nullable
    public static AppliedPatch apply(CharSequence text, List<? extends PatchHunk> hunks) {
        String patchedText = PlainSimplePatchApplier.apply(text, hunks);
        if (patchedText != null) {
            return new AppliedPatch(patchedText, ApplyPatchStatus.SUCCESS);
        }
        GenericPatchApplier applier = new GenericPatchApplier(text, hunks);
        boolean success2 = applier.execute();
        if (!success2) {
            return null;
        }
        return new AppliedPatch(applier.getAfter(), applier.getStatus());
    }

    @NotNull
    public static AppliedSomehowPatch applySomehow(CharSequence text, List<? extends PatchHunk> hunks) {
        String patchedText = PlainSimplePatchApplier.apply(text, hunks);
        if (patchedText != null) {
            return new AppliedSomehowPatch(patchedText, ApplyPatchStatus.SUCCESS, false);
        }
        GenericPatchApplier applier = new GenericPatchApplier(text, hunks);
        boolean success2 = applier.execute();
        if (!success2) {
            applier.trySolveSomehow();
        }
        return new AppliedSomehowPatch(applier.getAfter(), applier.getStatus(), !success2);
    }

    public ApplyPatchStatus getStatus() {
        if (!this.myNotExact.isEmpty()) {
            return ApplyPatchStatus.FAILURE;
        }
        if (this.myTransformations.isEmpty() && this.myHadAlreadyAppliedMet) {
            return ApplyPatchStatus.ALREADY_APPLIED;
        }
        boolean haveAlreadyApplied = this.myHadAlreadyAppliedMet;
        boolean haveTrue = false;
        for (MyAppliedData data : this.myTransformations.values()) {
            if (data.isHaveAlreadyApplied()) {
                haveAlreadyApplied |= true;
                continue;
            }
            haveTrue = true;
        }
        if (haveAlreadyApplied && !haveTrue) {
            return ApplyPatchStatus.ALREADY_APPLIED;
        }
        if (haveAlreadyApplied) {
            return ApplyPatchStatus.PARTIAL;
        }
        return ApplyPatchStatus.SUCCESS;
    }

    private void printTransformations(String comment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(comment + " GenericPatchApplier.printTransformations ---->");
            int cnt = 0;
            for (Map.Entry<TextRange, MyAppliedData> entry : this.myTransformations.entrySet()) {
                TextRange key = entry.getKey();
                MyAppliedData value = entry.getValue();
                LOG.info(cnt + " lines " + key.getStartOffset() + ":" + key.getEndOffset() + " will replace into: " + StringUtil.join(value.getList(), (String)"\n"));
            }
            LOG.debug("<------ GenericPatchApplier.printTransformations");
        }
    }

    /*
     * WARNING - void declaration
     */
    public int weightContextMatch(int maxWalk, int maxPartsToCheck) {
        ArrayList<SplitHunk> hunks = new ArrayList<SplitHunk>(this.myHunks.size());
        for (PatchHunk patchHunk : this.myHunks) {
            hunks.addAll(SplitHunk.read(patchHunk));
        }
        int cntPlus = 0;
        int n = maxPartsToCheck;
        for (SplitHunk hunk : hunks) {
            void var5_8;
            SplitHunk copy = GenericPatchApplier.createWithAllContextCopy(hunk);
            if (copy.isInsertion()) continue;
            if (this.testForPartialContextMatch(copy, new ExactMatchSolver(copy), maxWalk, null)) {
                ++cntPlus;
            }
            if (--var5_8 != false) continue;
            break;
        }
        return cntPlus;
    }

    public boolean execute() {
        SplitHunk copy;
        GenericPatchApplier.debug("GenericPatchApplier execute started");
        if (!this.myHunks.isEmpty()) {
            this.mySuppressNewLineInEnd = this.myHunks.get(this.myHunks.size() - 1).isNoNewLineAtEnd();
        }
        for (PatchHunk patchHunk : this.myHunks) {
            this.myNotExact.addAll(SplitHunk.read(patchHunk));
        }
        Iterator<SplitHunk> iterator = this.myNotExact.iterator();
        while (iterator.hasNext()) {
            SplitHunk splitHunk = iterator.next();
            copy = GenericPatchApplier.createWithAllContextCopy(splitHunk);
            if (!this.testForExactMatch(copy, splitHunk)) continue;
            iterator.remove();
        }
        this.printTransformations("after exact match");
        iterator = this.myNotExact.iterator();
        while (iterator.hasNext()) {
            SplitHunk splitHunk = iterator.next();
            copy = GenericPatchApplier.createWithAllContextCopy(splitHunk);
            if (copy.isInsertion() || !this.testForPartialContextMatch(copy, new ExactMatchSolver(copy), 1000, splitHunk)) continue;
            iterator.remove();
        }
        this.printTransformations("after exact but without context");
        iterator = this.myNotExact.iterator();
        while (iterator.hasNext()) {
            SplitHunk splitHunk = iterator.next();
            SplitHunk original = GenericPatchApplier.copySplitHunk(splitHunk, splitHunk.getContextAfter(), splitHunk.getContextBefore());
            GenericPatchApplier.complementInsertAndDelete(splitHunk);
            if (splitHunk.isInsertion()) {
                this.processAppliedInfoForUnApplied(original);
                continue;
            }
            if (this.testForPartialContextMatch(splitHunk, new ExactMatchSolver(splitHunk), 1000, original)) {
                iterator.remove();
                continue;
            }
            this.processAppliedInfoForUnApplied(original);
        }
        this.printTransformations("after variable place match");
        return this.myNotExact.isEmpty();
    }

    @NotNull
    private static SplitHunk copySplitHunk(@NotNull SplitHunk hunk, @NotNull List<String> contextAfter, @NotNull List<String> contextBefore) {
        ArrayList<BeforeAfter<List<String>>> steps = new ArrayList<BeforeAfter<List<String>>>();
        for (BeforeAfter<List<String>> step : hunk.getPatchSteps()) {
            steps.add((BeforeAfter<List<String>>)new BeforeAfter(new ArrayList((Collection)step.getBefore()), new ArrayList((Collection)step.getAfter())));
        }
        return new SplitHunk(hunk.getStartLineBefore(), hunk.getStartLineAfter(), steps, new ArrayList<String>(contextAfter), new ArrayList<String>(contextBefore));
    }

    private static SplitHunk createWithAllContextCopy(SplitHunk hunk) {
        SplitHunk copy = GenericPatchApplier.copySplitHunk(hunk, new ArrayList<String>(), new ArrayList<String>());
        List<BeforeAfter<List<String>>> steps = copy.getPatchSteps();
        if (steps.isEmpty()) {
            int contextSize = hunk.getContextBefore().size() + hunk.getContextAfter().size();
            LOG.warn(GenericPatchApplier.constructHunkWarnMessage(hunk.getStartLineBefore(), hunk.getStartLineAfter(), contextSize, contextSize));
            StringBuilder sb = new StringBuilder();
            StringUtil.join(hunk.getContextBefore(), (String)"\n", (StringBuilder)sb);
            StringUtil.join(hunk.getContextAfter(), (String)"\n", (StringBuilder)sb);
            LOG.debug(sb.toString());
            return copy;
        }
        BeforeAfter<List<String>> first = steps.get(0);
        int lastStepIndex = steps.size() - 1;
        BeforeAfter<List<String>> last = steps.get(lastStepIndex);
        BeforeAfter<List<String>> firstCopy = GenericPatchApplier.copyBeforeAfter(first);
        steps.set(0, firstCopy);
        ((List)firstCopy.getBefore()).addAll(0, hunk.getContextBefore());
        ((List)firstCopy.getAfter()).addAll(0, hunk.getContextBefore());
        if (first == last) {
            ((List)firstCopy.getBefore()).addAll(hunk.getContextAfter());
            ((List)firstCopy.getAfter()).addAll(hunk.getContextAfter());
        } else {
            BeforeAfter<List<String>> lastCopy = GenericPatchApplier.copyBeforeAfter(last);
            ((List)lastCopy.getBefore()).addAll(hunk.getContextAfter());
            ((List)lastCopy.getAfter()).addAll(hunk.getContextAfter());
            steps.set(lastStepIndex, lastCopy);
        }
        return copy;
    }

    @NotNull
    private static String constructHunkWarnMessage(int startLineBefore, int startLineAfter, int sizeBefore, int sizeAfter) {
        return String.format("Can't detect hunk modification lines for: -%d,%d +%d,%d", startLineBefore, sizeBefore, startLineAfter, sizeAfter);
    }

    private static BeforeAfter<List<String>> copyBeforeAfter(BeforeAfter<List<String>> first) {
        return new BeforeAfter(new ArrayList((Collection)first.getBefore()), new ArrayList((Collection)first.getAfter()));
    }

    private static void complementInsertAndDelete(SplitHunk hunk) {
        List<BeforeAfter<List<String>>> steps = hunk.getPatchSteps();
        BeforeAfter<List<String>> first = steps.get(0);
        BeforeAfter<List<String>> last = steps.get(steps.size() - 1);
        boolean complementFirst = ((List)first.getBefore()).isEmpty() || ((List)first.getAfter()).isEmpty();
        boolean complementLast = ((List)last.getBefore()).isEmpty() || ((List)last.getAfter()).isEmpty();
        List<String> contextBefore = hunk.getContextBefore();
        if (complementFirst && !contextBefore.isEmpty()) {
            String firstContext = contextBefore.get(contextBefore.size() - 1);
            ((List)first.getBefore()).add(0, firstContext);
            ((List)first.getAfter()).add(0, firstContext);
            contextBefore.remove(contextBefore.size() - 1);
        }
        List<String> contextAfter = hunk.getContextAfter();
        if (complementLast && !contextAfter.isEmpty()) {
            String firstContext = contextAfter.get(0);
            ((List)last.getBefore()).add(firstContext);
            ((List)last.getAfter()).add(firstContext);
            contextAfter.remove(0);
        }
    }

    private static boolean complementIfShort(SplitHunk hunk) {
        boolean complementFirst;
        List<BeforeAfter<List<String>>> steps = hunk.getPatchSteps();
        if (steps.size() > 1) {
            return false;
        }
        BeforeAfter<List<String>> first = steps.get(0);
        boolean bl = complementFirst = ((List)first.getBefore()).isEmpty() || ((List)first.getAfter()).isEmpty() || ((List)first.getBefore()).size() == 1 || ((List)first.getAfter()).size() == 1;
        if (!complementFirst) {
            return false;
        }
        List<String> contextBefore = hunk.getContextBefore();
        if (!contextBefore.isEmpty()) {
            String firstContext = contextBefore.get(contextBefore.size() - 1);
            ((List)first.getBefore()).add(0, firstContext);
            ((List)first.getAfter()).add(0, firstContext);
            contextBefore.remove(contextBefore.size() - 1);
            return true;
        }
        List<String> contextAfter = hunk.getContextAfter();
        if (!contextAfter.isEmpty()) {
            String firstContext = contextAfter.get(0);
            ((List)first.getBefore()).add(firstContext);
            ((List)first.getAfter()).add(firstContext);
            contextAfter.remove(0);
            return true;
        }
        return false;
    }

    public void trySolveSomehow() {
        assert (!this.myNotExact.isEmpty());
        for (SplitHunk hunk : this.myNotExact) {
            hunk.cutSameTail();
            if (this.testForPartialContextMatch(hunk, new LongTryMismatchSolver(hunk), 1000, null)) continue;
            if (GenericPatchApplier.complementIfShort(hunk)) {
                if (this.testForPartialContextMatch(hunk, new LongTryMismatchSolver(hunk), 1000, null)) continue;
                this.myNotBound.add(hunk);
                continue;
            }
            this.myNotBound.add(hunk);
        }
        Collections.sort(this.myNotBound, HunksComparator.getInstance());
        this.myNotExact.clear();
    }

    private boolean testForPartialContextMatch(SplitHunk splitHunkWithExtendedContext, MismatchSolver mismatchSolver, int maxWalkFromBinding, @Nullable SplitHunk originalSplitHunk) {
        List<BeforeAfter<List<String>>> steps = splitHunkWithExtendedContext.getPatchSteps();
        BetterPoint betterPoint = new BetterPoint();
        if (splitHunkWithExtendedContext.isInsertion()) {
            return false;
        }
        Iterator<FirstLineDescriptor> iterator = mismatchSolver.getStartLineVariationsIterator();
        while (iterator.hasNext() && (betterPoint.getPoint() == null || !betterPoint.getPoint().idealFound())) {
            FirstLineDescriptor descriptor = iterator.next();
            Iterator<Integer> matchingIterator = this.getMatchingIterator(descriptor.getLine(), splitHunkWithExtendedContext.getStartLineBefore() + descriptor.getOffset(), maxWalkFromBinding);
            while (matchingIterator.hasNext() && (betterPoint.getPoint() == null || !betterPoint.getPoint().idealFound())) {
                UnfairTextRange textRangeInOldDocument;
                List<BeforeAfter<List<String>>> list2;
                Integer lineNumber = matchingIterator.next();
                List<BeforeAfter<List<String>>> patchSteps = splitHunkWithExtendedContext.getPatchSteps();
                BeforeAfter<List<String>> step = patchSteps.get(descriptor.getStepNumber());
                FragmentResult fragmentResult = this.checkFragmented(lineNumber, descriptor.getOffsetInStep(), step, descriptor.isIsInBefore());
                if (descriptor.getStepNumber() > 0 && fragmentResult.isStartAtEdge()) {
                    list2 = Collections.unmodifiableList(patchSteps.subList(0, descriptor.getStepNumber()));
                    int offsetForStart = -descriptor.getOffsetInStep() - 1;
                    SequentialStepsChecker backChecker = new SequentialStepsChecker(lineNumber + offsetForStart, false);
                    backChecker.go(list2);
                    fragmentResult.setContainAlreadyApplied(fragmentResult.isContainAlreadyApplied() || backChecker.isUsesAlreadyApplied());
                    fragmentResult.setStart(fragmentResult.getStart() - backChecker.getSizeOfFragmentToBeReplaced());
                    fragmentResult.addDistance(backChecker.getDistance());
                    fragmentResult.setStartAtEdge(backChecker.getDistance() == 0);
                }
                if (steps.size() > descriptor.getStepNumber() + 1 && fragmentResult.isEndAtEdge() && !(list2 = Collections.unmodifiableList(patchSteps.subList(descriptor.getStepNumber() + 1, patchSteps.size()))).isEmpty()) {
                    SequentialStepsChecker checker = new SequentialStepsChecker(fragmentResult.getEnd() + 1, true);
                    checker.go(list2);
                    fragmentResult.setContainAlreadyApplied(fragmentResult.isContainAlreadyApplied() || checker.isUsesAlreadyApplied());
                    fragmentResult.setEnd(fragmentResult.getEnd() + checker.getSizeOfFragmentToBeReplaced());
                    fragmentResult.addDistance(checker.getDistance());
                    fragmentResult.setEndAtEdge(checker.getDistance() == 0);
                }
                if (!this.pointCanBeUsed((TextRange)(textRangeInOldDocument = new UnfairTextRange(fragmentResult.getStart(), fragmentResult.getEnd())))) continue;
                int distance2 = fragmentResult.myDistance;
                int commonPart = fragmentResult.getEnd() - fragmentResult.getStart() + 1;
                int contextDistance = 0;
                if (distance2 == 0 || commonPart < 2) {
                    int distanceBack = this.getDistanceBack(fragmentResult.getStart() - 1, splitHunkWithExtendedContext.getContextBefore());
                    int distanceInContextAfter = this.getDistance(fragmentResult.getEnd() + 1, splitHunkWithExtendedContext.getContextAfter());
                    contextDistance = distanceBack + distanceInContextAfter;
                }
                betterPoint.feed(new Point(distance2, (TextRange)textRangeInOldDocument, fragmentResult.isContainAlreadyApplied(), contextDistance, commonPart));
            }
        }
        Point pointPoint = betterPoint.getPoint();
        if (pointPoint == null) {
            return false;
        }
        if (!mismatchSolver.isAllowMismatch()) {
            int contextCommon;
            if (pointPoint.getDistance() > 0) {
                return false;
            }
            if (pointPoint.myCommon < 2 && (contextCommon = splitHunkWithExtendedContext.getContextBefore().size() + splitHunkWithExtendedContext.getContextAfter().size() - pointPoint.myContextDistance) == 0) {
                return false;
            }
        }
        this.putCutIntoTransformations(pointPoint.getInOldDocument(), originalSplitHunk, new MyAppliedData(splitHunkWithExtendedContext.getAfterAll(), pointPoint.myUsesAlreadyApplied, false, pointPoint.getDistance() == 0, ChangeType.REPLACE), originalSplitHunk == null ? EMPTY_OFFSET : new IntPair(originalSplitHunk.getContextBefore().size() - splitHunkWithExtendedContext.getContextBefore().size(), originalSplitHunk.getContextAfter().size() - splitHunkWithExtendedContext.getContextAfter().size()));
        return true;
    }

    private FragmentResult checkFragmented(int lineInTheMiddle, int offsetInStep, BeforeAfter<List<String>> step, boolean inBefore) {
        List lines2 = inBefore ? (List)step.getBefore() : (List)step.getAfter();
        List<String> start2 = lines2.subList(0, offsetInStep);
        int startDistance = 0;
        if (!start2.isEmpty()) {
            startDistance = lineInTheMiddle - 1 < 0 ? start2.size() : this.getDistanceBack(lineInTheMiddle - 1, start2);
        }
        List<String> end = lines2.subList(offsetInStep, lines2.size());
        int endDistance = 0;
        if (!end.isEmpty()) {
            endDistance = this.getDistance(lineInTheMiddle, end);
        }
        FragmentResult fragmentResult = new FragmentResult(lineInTheMiddle - (start2.size() - startDistance), lineInTheMiddle + (end.size() - endDistance) - 1, !inBefore);
        fragmentResult.addDistance(startDistance + endDistance);
        fragmentResult.setStartAtEdge(startDistance == 0);
        fragmentResult.setEndAtEdge(endDistance == 0);
        return fragmentResult;
    }

    @NotNull
    public List<AppliedTextPatch.AppliedSplitPatchHunk> getAppliedInfo() {
        return this.myAppliedInfo;
    }

    private int getDistanceBack(int idxStart, List<String> lines2) {
        if (idxStart < 0) {
            return lines2.size();
        }
        int cnt = lines2.size() - 1;
        for (int i = idxStart; i >= 0 && cnt >= 0; --i, --cnt) {
            if (this.myLines.get(i).equals(lines2.get(cnt))) continue;
            return cnt + 1;
        }
        return cnt + 1;
    }

    private int getDistance(int idxStart, List<String> lines2) {
        if (idxStart >= this.myLines.size()) {
            return lines2.size();
        }
        int cnt = 0;
        for (int i = idxStart; i < this.myLines.size() && cnt < lines2.size(); ++i, ++cnt) {
            if (this.myLines.get(i).equals(lines2.get(cnt))) continue;
            return lines2.size() - cnt;
        }
        return lines2.size() - cnt;
    }

    public void putCutIntoTransformations(TextRange range2, MyAppliedData value) {
        this.putCutIntoTransformations(range2, null, value, EMPTY_OFFSET);
    }

    public void putCutIntoTransformations(TextRange range2, @Nullable SplitHunk splitHunk, MyAppliedData value, @NotNull IntPair contextOffsetInPatchSteps) {
        int j;
        int i;
        List<String> list2 = value.getList();
        boolean eofHunkAndLastLineShouldBeChanged = this.containsLastLine(range2) && splitHunk != null && splitHunk.getContextAfter().isEmpty() && !splitHunk.getAfterAll().isEmpty();
        int cnt = list2.size() - 1;
        if (!eofHunkAndLastLineShouldBeChanged) {
            for (i = range2.getEndOffset(); i > range2.getStartOffset() && cnt >= 0 && list2.get(cnt).equals(this.myLines.get(i)); --i, --cnt) {
            }
        }
        int endSize = list2.size();
        if (cnt + 1 <= list2.size() - 1) {
            endSize = cnt + 1;
        }
        int cntStart = 0;
        if (endSize > 0) {
            int lastProcessedIndex;
            int n = lastProcessedIndex = eofHunkAndLastLineShouldBeChanged ? list2.size() - 1 : list2.size();
            for (j = range2.getStartOffset(); j < range2.getEndOffset() && cntStart < lastProcessedIndex && list2.get(cntStart).equals(this.myLines.get(j)); ++j, ++cntStart) {
            }
        }
        if (j != range2.getStartOffset() || i != range2.getEndOffset()) {
            if (cntStart >= endSize) {
                if (list2.size() == range2.getLength() + 1) {
                    this.myHadAlreadyAppliedMet = value.isHaveAlreadyApplied();
                    this.processAppliedInfo(splitHunk, range2, contextOffsetInPatchSteps, AppliedTextPatch.HunkStatus.ALREADY_APPLIED);
                } else {
                    UnfairTextRange textRange = new UnfairTextRange(j, i + (cntStart - endSize));
                    this.myTransformations.put((TextRange)textRange, new MyAppliedData(Collections.emptyList(), value.isHaveAlreadyApplied(), value.isPlaceCoinside(), value.isChangedCoinside(), value.myChangeType));
                    this.processAppliedInfo(splitHunk, range2, contextOffsetInPatchSteps, AppliedTextPatch.HunkStatus.EXACTLY_APPLIED);
                }
            } else {
                if (i < j) {
                    assert (cntStart > 0);
                    MyAppliedData newData = new MyAppliedData(new ArrayList<String>(list2.subList(cntStart - (j - i), endSize)), value.isHaveAlreadyApplied(), value.isPlaceCoinside(), value.isChangedCoinside(), value.myChangeType);
                    TextRange newRange = new TextRange(i, i);
                    this.myTransformations.put(newRange, newData);
                    this.processAppliedInfo(splitHunk, range2, contextOffsetInPatchSteps, AppliedTextPatch.HunkStatus.EXACTLY_APPLIED);
                    return;
                }
                MyAppliedData newData = new MyAppliedData(new ArrayList<String>(list2.subList(cntStart, endSize)), value.isHaveAlreadyApplied(), value.isPlaceCoinside(), value.isChangedCoinside(), value.myChangeType);
                TextRange newRange = new TextRange(j, i);
                this.myTransformations.put(newRange, newData);
                this.processAppliedInfo(splitHunk, range2, contextOffsetInPatchSteps, AppliedTextPatch.HunkStatus.EXACTLY_APPLIED);
            }
        } else {
            this.myTransformations.put(range2, value);
            this.processAppliedInfo(splitHunk, range2, contextOffsetInPatchSteps, AppliedTextPatch.HunkStatus.EXACTLY_APPLIED);
        }
    }

    private void processAppliedInfoForUnApplied(@NotNull SplitHunk original) {
        this.myAppliedInfo.add(new AppliedTextPatch.AppliedSplitPatchHunk(original, -1, -1, AppliedTextPatch.HunkStatus.NOT_APPLIED));
    }

    private void processAppliedInfo(@Nullable SplitHunk hunk, @NotNull TextRange lineWithPartContextApplied, @NotNull IntPair contextRangeShift, AppliedTextPatch.HunkStatus hunkStatus) {
        if (hunk != null) {
            int newStart = lineWithPartContextApplied.getStartOffset() + contextRangeShift.val1;
            int newEnd = hunk.isInsertion() && hunkStatus != AppliedTextPatch.HunkStatus.ALREADY_APPLIED ? newStart : lineWithPartContextApplied.getEndOffset() + 1 - contextRangeShift.val2;
            this.myAppliedInfo.add(new AppliedTextPatch.AppliedSplitPatchHunk(hunk, newStart, newEnd, hunkStatus));
        }
    }

    private boolean pointCanBeUsed(TextRange range2) {
        Map.Entry<TextRange, MyAppliedData> entry = this.myTransformations.ceilingEntry(range2);
        return entry == null || !entry.getKey().intersects(range2);
    }

    private Iterator<Integer> getMatchingIterator(String line, int originalStart, int maxWalkFromBinding) {
        return ContainerUtil.concatIterators((Iterator[])new Iterator[]{new WalkingIterator(line, originalStart, maxWalkFromBinding, true), new WalkingIterator(line, originalStart, maxWalkFromBinding, false)});
    }

    private boolean testForExactMatch(SplitHunk splitHunk, SplitHunk originalHunk) {
        int offset = splitHunk.getContextBefore().size();
        List<BeforeAfter<List<String>>> steps = splitHunk.getPatchSteps();
        if (splitHunk.isInsertion()) {
            boolean emptyFile;
            boolean bl = emptyFile = this.myLines.isEmpty() || this.myLines.size() == 1 && this.myLines.get(0).trim().isEmpty();
            if (emptyFile) {
                this.myNotBound.add(splitHunk);
                this.processAppliedInfoForUnApplied(splitHunk);
            }
            return emptyFile;
        }
        int idx = splitHunk.getStartLineBefore() + offset;
        int cnt = 0;
        boolean hadAlreadyApplied = false;
        for (BeforeAfter<List<String>> step : steps) {
            int length;
            if (this.myLines.size() <= idx) {
                return false;
            }
            if (((List)step.getBefore()).isEmpty()) continue;
            Pair<Integer, Boolean> distance2 = new FragmentMatcher(idx + cnt, step).find(false);
            if ((Integer)distance2.getFirst() > 0) {
                return false;
            }
            if (((Boolean)distance2.getSecond()).booleanValue()) {
                length = ((List)step.getBefore()).size();
            } else {
                length = ((List)step.getAfter()).size();
                hadAlreadyApplied = true;
            }
            cnt += length;
        }
        this.putCutIntoTransformations(new TextRange(idx, idx + cnt - 1), originalHunk, new MyAppliedData(splitHunk.getAfterAll(), hadAlreadyApplied, true, true, ChangeType.REPLACE), new IntPair(originalHunk.getContextBefore().size() - splitHunk.getContextBefore().size(), originalHunk.getContextAfter().size() - splitHunk.getContextAfter().size()));
        return true;
    }

    public String getAfter() {
        StringBuilder sb = new StringBuilder();
        for (SplitHunk hunk : this.myNotBound) {
            GenericPatchApplier.linesToSb(sb, hunk.getAfterAll(), true);
        }
        this.iterateTransformations((Consumer<? super TextRange>)((Consumer)range2 -> {
            List<String> baseLineslist = this.myLines.subList(range2.getStartOffset(), range2.getEndOffset() + 1);
            boolean withLineBreak = !this.containsLastLine((TextRange)range2) || this.myBaseFileEndsWithNewLine;
            GenericPatchApplier.linesToSb(sb, baseLineslist, withLineBreak);
        }), (Consumer<? super TextRange>)((Consumer)range2 -> {
            MyAppliedData appliedData = this.myTransformations.get(range2);
            List<String> list2 = appliedData.getList();
            boolean withLineBreak = !this.containsLastLine((TextRange)range2) || !this.mySuppressNewLineInEnd;
            GenericPatchApplier.linesToSb(sb, list2, withLineBreak);
        }));
        return sb.toString();
    }

    private boolean containsLastLine(@NotNull TextRange range2) {
        return range2.getEndOffset() == this.myLines.size() - 1;
    }

    private static void linesToSb(StringBuilder sb, List<String> list2, boolean withEndLineBreak) {
        StringUtil.join(list2, (String)"\n", (StringBuilder)sb);
        if (!list2.isEmpty() && withEndLineBreak) {
            sb.append('\n');
        }
    }

    private void iterateTransformations(Consumer<? super TextRange> consumerExcluded, Consumer<? super TextRange> consumerIncluded) {
        if (this.myTransformations.isEmpty()) {
            consumerExcluded.consume((Object)new UnfairTextRange(0, this.myLines.size() - 1));
        } else {
            Set<Map.Entry<TextRange, MyAppliedData>> entries2 = this.myTransformations.entrySet();
            Iterator<Map.Entry<TextRange, MyAppliedData>> iterator = entries2.iterator();
            assert (iterator.hasNext());
            Map.Entry<TextRange, MyAppliedData> first = iterator.next();
            TextRange range2 = first.getKey();
            if (range2.getStartOffset() > 0) {
                consumerExcluded.consume((Object)new TextRange(0, range2.getStartOffset() - 1));
            }
            consumerIncluded.consume((Object)range2);
            int previousEnd = range2.getEndOffset() + 1;
            while (iterator.hasNext() && previousEnd < this.myLines.size()) {
                Map.Entry<TextRange, MyAppliedData> entry = iterator.next();
                TextRange key = entry.getKey();
                consumerExcluded.consume((Object)new UnfairTextRange(previousEnd, key.getStartOffset() - 1));
                consumerIncluded.consume((Object)key);
                previousEnd = key.getEndOffset() + 1;
            }
            if (previousEnd < this.myLines.size()) {
                consumerExcluded.consume((Object)new TextRange(previousEnd, this.myLines.size() - 1));
            }
        }
    }

    public TreeMap<TextRange, MyAppliedData> getTransformations() {
        return this.myTransformations;
    }

    private static class HunksComparator
    implements Comparator<SplitHunk> {
        private static final HunksComparator ourInstance = new HunksComparator();

        private HunksComparator() {
        }

        public static HunksComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(SplitHunk o1, SplitHunk o2) {
            return Integer.compare(o1.getStartLineBefore(), o2.getStartLineBefore());
        }
    }

    public static enum ChangeType {
        REPLACE;

    }

    public static class MyAppliedData {
        private List<String> myList;
        private final boolean myHaveAlreadyApplied;
        private final boolean myPlaceCoinside;
        private final boolean myChangedCoinside;
        private final ChangeType myChangeType;

        public MyAppliedData(List<String> list2, boolean alreadyApplied, boolean placeCoinside, boolean changedCoinside, ChangeType changeType) {
            this.myList = list2;
            this.myHaveAlreadyApplied = alreadyApplied;
            this.myPlaceCoinside = placeCoinside;
            this.myChangedCoinside = changedCoinside;
            this.myChangeType = changeType;
        }

        public List<String> getList() {
            return this.myList;
        }

        public void cutToSize(int size) {
            assert (size > 0 && size < this.myList.size());
            this.myList = new ArrayList<String>(this.myList.subList(0, size));
        }

        public boolean isHaveAlreadyApplied() {
            return this.myHaveAlreadyApplied;
        }

        public boolean isPlaceCoinside() {
            return this.myPlaceCoinside;
        }

        public boolean isChangedCoinside() {
            return this.myChangedCoinside;
        }
    }

    public static class SplitHunk {
        private final List<String> myContextBefore;
        private final List<String> myContextAfter;
        @NotNull
        private final List<BeforeAfter<List<String>>> myPatchSteps;
        private final int myStartLineBefore;
        private final int myStartLineAfter;

        public SplitHunk(int startLineBefore, int startLineAfter, @NotNull List<BeforeAfter<List<String>>> patchSteps, List<String> contextAfter, List<String> contextBefore) {
            this.myStartLineBefore = startLineBefore;
            this.myStartLineAfter = startLineAfter;
            this.myPatchSteps = patchSteps;
            this.myContextAfter = contextAfter;
            this.myContextBefore = contextBefore;
        }

        public void cutSameTail() {
            BeforeAfter<List<String>> lastStep = this.myPatchSteps.get(this.myPatchSteps.size() - 1);
            List before = (List)lastStep.getBefore();
            List after = (List)lastStep.getAfter();
            int cntBefore = before.size() - 1;
            for (int cntAfter = after.size() - 1; cntBefore >= 0 && cntAfter > 0 && ((String)before.get(cntBefore)).equals(after.get(cntAfter)); --cntBefore, --cntAfter) {
            }
            int cutSame = before.size() - 1 - cntBefore;
            for (int i = 0; i < cutSame; ++i) {
                before.remove(before.size() - 1);
                after.remove(after.size() - 1);
            }
        }

        public static List<SplitHunk> read(PatchHunk hunk) {
            ArrayList<SplitHunk> result2 = new ArrayList<SplitHunk>();
            List lines2 = hunk.getLines();
            int i = 0;
            ArrayList<String> contextBefore = new ArrayList<String>();
            int newSize = 0;
            int oldSize = 0;
            while (i < lines2.size()) {
                int inheritedContext = contextBefore.size();
                ArrayList<String> contextAfter = new ArrayList<String>();
                ArrayList<BeforeAfter<List<String>>> steps = new ArrayList<BeforeAfter<List<String>>>();
                int endIdx = SplitHunk.readOne(lines2, contextBefore, contextAfter, steps, i);
                int startLineBefore = hunk.getStartLineBefore();
                int startLineAfter = hunk.getStartLineAfter();
                if (steps.isEmpty()) {
                    LOG.warn(GenericPatchApplier.constructHunkWarnMessage(startLineBefore, startLineAfter, hunk.getEndLineBefore() - startLineBefore, hunk.getEndLineAfter() - startLineAfter));
                    LOG.debug("Wrong chunk text: " + hunk.getText());
                } else {
                    result2.add(new SplitHunk(startLineBefore + i - inheritedContext - newSize, startLineAfter + i - inheritedContext - oldSize, steps, contextAfter, contextBefore));
                }
                for (BeforeAfter beforeAfter : steps) {
                    newSize += ((List)beforeAfter.getAfter()).size();
                    oldSize += ((List)beforeAfter.getBefore()).size();
                }
                i = endIdx;
                if (i >= lines2.size()) continue;
                contextBefore = new ArrayList<String>(contextAfter);
            }
            return result2;
        }

        private static int readOne(List<? extends PatchLine> lines2, List<? super String> contextBefore, List<? super String> contextAfter, List<? super BeforeAfter<List<String>>> steps, int startI) {
            PatchLine patchLine;
            PatchLine.Type type;
            PatchLine patchLine2;
            int i;
            for (i = startI; i < lines2.size() && PatchLine.Type.CONTEXT == (patchLine2 = lines2.get(i)).getType(); ++i) {
                contextBefore.add(patchLine2.getText());
            }
            boolean addFirst = i < lines2.size() && PatchLine.Type.ADD == lines2.get(i).getType();
            ArrayList<String> before = new ArrayList<String>();
            ArrayList<String> after = new ArrayList<String>();
            while (i < lines2.size() && PatchLine.Type.CONTEXT != (type = (patchLine = lines2.get(i)).getType())) {
                if (PatchLine.Type.ADD == type) {
                    if (addFirst && !before.isEmpty()) {
                        steps.add((BeforeAfter<List<String>>)new BeforeAfter(before, after));
                        before = new ArrayList();
                        after = new ArrayList();
                    }
                    after.add(patchLine.getText());
                } else if (PatchLine.Type.REMOVE == type) {
                    if (!addFirst && !after.isEmpty()) {
                        steps.add((BeforeAfter<List<String>>)new BeforeAfter(before, after));
                        before = new ArrayList();
                        after = new ArrayList();
                    }
                    before.add(patchLine.getText());
                }
                ++i;
            }
            if (!before.isEmpty() || !after.isEmpty()) {
                steps.add((BeforeAfter<List<String>>)new BeforeAfter(before, after));
            }
            while (i < lines2.size()) {
                patchLine = lines2.get(i);
                if (PatchLine.Type.CONTEXT != patchLine.getType()) {
                    return i;
                }
                contextAfter.add(patchLine.getText());
                ++i;
            }
            return lines2.size();
        }

        public boolean isInsertion() {
            return this.myPatchSteps.size() == 1 && ((List)this.myPatchSteps.get(0).getBefore()).isEmpty();
        }

        public int getStartLineBefore() {
            return this.myStartLineBefore;
        }

        public int getStartLineAfter() {
            return this.myStartLineAfter;
        }

        public List<String> getContextBefore() {
            return this.myContextBefore;
        }

        public List<String> getContextAfter() {
            return this.myContextAfter;
        }

        @NotNull
        public List<BeforeAfter<List<String>>> getPatchSteps() {
            return this.myPatchSteps;
        }

        public List<String> getAfterAll() {
            ArrayList<String> after = new ArrayList<String>();
            for (BeforeAfter<List<String>> step : this.myPatchSteps) {
                after.addAll((Collection)step.getAfter());
            }
            return after;
        }
    }

    private class FragmentMatcher {
        private final int myIdx;
        private int myOffsetIdxInHunk = 0;
        private Boolean myBeforeSide;
        private final BeforeAfter<List<String>> myBeforeAfter;

        private FragmentMatcher(int idx, BeforeAfter<List<String>> beforeAfter) {
            this.myIdx = idx;
            this.myBeforeAfter = beforeAfter;
        }

        public void setSideAndIdx(int startInHunk, boolean beforeSide) {
            this.myOffsetIdxInHunk = startInHunk;
            this.myBeforeSide = beforeSide;
            if (this.myBeforeSide != false ? !$assertionsDisabled && ((List)this.myBeforeAfter.getBefore()).size() <= this.myOffsetIdxInHunk && (this.myOffsetIdxInHunk != 0 || !((List)this.myBeforeAfter.getBefore()).isEmpty()) : !$assertionsDisabled && ((List)this.myBeforeAfter.getAfter()).size() <= this.myOffsetIdxInHunk && (this.myOffsetIdxInHunk != 0 || !((List)this.myBeforeAfter.getAfter()).isEmpty())) {
                throw new AssertionError();
            }
        }

        public Pair<Integer, Boolean> find(boolean canMismatch) {
            if (this.myBeforeSide != null) {
                if (this.myBeforeSide.booleanValue()) {
                    return new Pair((Object)this.checkSide((List)this.myBeforeAfter.getBefore(), canMismatch), (Object)true);
                }
                return new Pair((Object)this.checkSide((List)this.myBeforeAfter.getAfter(), canMismatch), (Object)false);
            }
            int beforeCheckResult = this.checkSide((List)this.myBeforeAfter.getBefore(), canMismatch);
            int afterCheckResult = this.checkSide((List)this.myBeforeAfter.getAfter(), canMismatch);
            Pair beforePair = new Pair((Object)beforeCheckResult, (Object)true);
            Pair afterPair = new Pair((Object)afterCheckResult, (Object)false);
            if (!canMismatch) {
                if (beforeCheckResult == 0) {
                    return beforePair;
                }
                if (afterCheckResult == 0) {
                    return afterPair;
                }
                return beforePair;
            }
            int beforeCommon = ((List)this.myBeforeAfter.getBefore()).size() - beforeCheckResult;
            int afterCommon = ((List)this.myBeforeAfter.getAfter()).size() - afterCheckResult;
            if (beforeCommon > 0 && afterCommon > 0) {
                if (beforeCommon == 1 && ((List)this.myBeforeAfter.getBefore()).size() == 1 && afterCommon > 1) {
                    return afterPair;
                }
                if (afterCommon == 1 && ((List)this.myBeforeAfter.getAfter()).size() == 1 && beforeCommon > 1) {
                    return beforePair;
                }
                if (beforeCommon >= afterCommon) {
                    return beforePair;
                }
                return afterPair;
            }
            if (afterCommon > 0) {
                return afterPair;
            }
            return beforePair;
        }

        private int checkSide(List<String> side, boolean canMismatch) {
            int j;
            int distance2 = 0;
            if (this.myOffsetIdxInHunk > 0) {
                int i;
                int linesIdx = this.myIdx - 1;
                for (i = this.myOffsetIdxInHunk - 1; i >= 0 && linesIdx >= 0 && ((String)GenericPatchApplier.this.myLines.get(linesIdx)).equals(side.get(i)); --i, --linesIdx) {
                }
                if (++i > 0 && !canMismatch) {
                    return i;
                }
                distance2 = i;
            }
            int linesEndIdx = this.myIdx;
            for (j = this.myOffsetIdxInHunk; j < side.size() && linesEndIdx < GenericPatchApplier.this.myLines.size() && ((String)GenericPatchApplier.this.myLines.get(linesEndIdx)).equals(side.get(j)); ++j, ++linesEndIdx) {
            }
            return distance2 += side.size() - j;
        }
    }

    private class WalkingIterator
    implements Iterator<Integer> {
        private final String myLine;
        private final boolean myDirection;
        private int myLeftWalk;
        private int myCurrentIdx;

        private WalkingIterator(String line, int start2, int leftWalk, boolean direction) {
            this.myLine = line;
            this.myLeftWalk = leftWalk;
            this.myDirection = direction;
            this.myCurrentIdx = direction ? start2 - 1 : start2;
            this.step();
        }

        @Override
        public boolean hasNext() {
            return this.myCurrentIdx != -1;
        }

        @Override
        public Integer next() {
            int currentIdx = this.myCurrentIdx;
            this.step();
            return currentIdx;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void step() {
            if (this.myDirection) {
                int i;
                int maxWalk = this.myLeftWalk + i;
                this.myCurrentIdx = -1;
                for (i = this.myCurrentIdx + 1; i < GenericPatchApplier.this.myLines.size() && i < maxWalk; ++i) {
                    String s = (String)GenericPatchApplier.this.myLines.get(i);
                    if (!this.myLine.equals(s) || this.isSeized(i)) continue;
                    this.myCurrentIdx = i;
                    this.myLeftWalk = maxWalk - 1 - i;
                    break;
                }
            } else {
                int i;
                int maxWalk = Math.max(-1, i - this.myLeftWalk);
                this.myCurrentIdx = -1;
                for (i = this.myCurrentIdx - 1; i >= 0 && i > maxWalk && i < GenericPatchApplier.this.myLines.size(); --i) {
                    String s = (String)GenericPatchApplier.this.myLines.get(i);
                    if (!this.myLine.equals(s) || this.isSeized(i)) continue;
                    this.myCurrentIdx = i;
                    this.myLeftWalk = i - (maxWalk + 1);
                    break;
                }
            }
        }

        private boolean isSeized(int lineNumber) {
            TextRange art = new TextRange(lineNumber, lineNumber);
            TextRange floor = GenericPatchApplier.this.myTransformations.floorKey(art);
            return floor != null && floor.intersects(art);
        }
    }

    private static abstract class MismatchSolver {
        protected final ArrayList<FirstLineDescriptor> myResult = new ArrayList();
        private final boolean myAllowMismatch;

        protected MismatchSolver(boolean allowMismatch) {
            this.myAllowMismatch = allowMismatch;
        }

        public Iterator<FirstLineDescriptor> getStartLineVariationsIterator() {
            return this.myResult.iterator();
        }

        public boolean isAllowMismatch() {
            return this.myAllowMismatch;
        }
    }

    public static class LongTryMismatchSolver
    extends MismatchSolver {
        public LongTryMismatchSolver(SplitHunk hunk) {
            super(true);
            List<BeforeAfter<List<String>>> steps = hunk.getPatchSteps();
            int beforeOffset = 0;
            int afterOffset = 0;
            for (int i = 0; i < steps.size() && i < 3; ++i) {
                BeforeAfter<List<String>> list2 = steps.get(i);
                List before = (List)list2.getBefore();
                for (int j = 0; j < before.size() && j < 2; ++j) {
                    String s = (String)before.get(j);
                    this.myResult.add(new FirstLineDescriptor(s, beforeOffset + j, i, j, true));
                }
                List after = (List)list2.getAfter();
                for (int j = 0; j < after.size() && j < 2; ++j) {
                    String s = (String)after.get(j);
                    this.myResult.add(new FirstLineDescriptor(s, afterOffset + j, i, j, false));
                }
                beforeOffset += before.size();
                afterOffset += after.size();
            }
        }
    }

    private static class ExactMatchSolver
    extends MismatchSolver {
        private ExactMatchSolver(SplitHunk hunk) {
            super(false);
            List<BeforeAfter<List<String>>> steps = hunk.getPatchSteps();
            BeforeAfter<List<String>> first = steps.get(0);
            if (steps.size() == 1 && ((List)first.getBefore()).isEmpty()) {
                this.myResult.add(new FirstLineDescriptor((String)((List)first.getBefore()).get(0), 0, 0, 0, true));
            }
            if (!((List)first.getBefore()).isEmpty()) {
                this.myResult.add(new FirstLineDescriptor((String)((List)first.getBefore()).get(0), 0, 0, 0, true));
            }
            if (!((List)first.getAfter()).isEmpty()) {
                this.myResult.add(new FirstLineDescriptor((String)((List)first.getAfter()).get(0), 0, 0, 0, false));
            }
            assert (!this.myResult.isEmpty());
        }
    }

    private static class FirstLineDescriptor {
        private final String myLine;
        private final int myOffset;
        private final int myStepNumber;
        private final int myOffsetInStep;
        private final boolean myIsInBefore;

        private FirstLineDescriptor(String line, int offset, int stepNumber, int offsetInStep, boolean isInBefore) {
            this.myLine = line;
            this.myOffset = offset;
            this.myStepNumber = stepNumber;
            this.myOffsetInStep = offsetInStep;
            this.myIsInBefore = isInBefore;
        }

        public String getLine() {
            return this.myLine;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public int getStepNumber() {
            return this.myStepNumber;
        }

        public int getOffsetInStep() {
            return this.myOffsetInStep;
        }

        public boolean isIsInBefore() {
            return this.myIsInBefore;
        }
    }

    private class SequentialStepsChecker {
        private int myDistance;
        private int myIdx;
        private final int myStartIdx;
        private final boolean myForward;
        private boolean myUsesAlreadyApplied;

        private SequentialStepsChecker(int lineNumber, boolean forward) {
            this.myStartIdx = lineNumber;
            this.myIdx = lineNumber;
            this.myForward = forward;
        }

        public boolean isUsesAlreadyApplied() {
            return this.myUsesAlreadyApplied;
        }

        public int getDistance() {
            return this.myDistance;
        }

        public void go(List<? extends BeforeAfter<List<String>>> steps) {
            Consumer stepConsumer = listBeforeAfter -> {
                if (this.myDistance == 0) {
                    if (((List)listBeforeAfter.getBefore()).isEmpty()) {
                        return;
                    }
                    FragmentMatcher fragmentMatcher = new FragmentMatcher(this.myIdx, (BeforeAfter)listBeforeAfter);
                    Pair<Integer, Boolean> pair = fragmentMatcher.find(true);
                    this.myDistance = (Integer)pair.getFirst();
                    this.myIdx = this.myDistance == 0 ? (this.myIdx += (Boolean)pair.getSecond() != false ? ((List)listBeforeAfter.getBefore()).size() : ((List)listBeforeAfter.getAfter()).size()) : (this.myIdx += ((Boolean)pair.getSecond() != false ? ((List)listBeforeAfter.getBefore()).size() : ((List)listBeforeAfter.getAfter()).size()) - (Integer)pair.getFirst());
                    this.myUsesAlreadyApplied = (Boolean)pair.getSecond() == false;
                } else {
                    this.myDistance += ((List)listBeforeAfter.getBefore()).size();
                }
            };
            if (this.myForward) {
                for (BeforeAfter<List<String>> beforeAfter : steps) {
                    stepConsumer.consume(beforeAfter);
                }
            } else {
                for (int i = steps.size() - 1; i >= 0; --i) {
                    BeforeAfter<List<String>> beforeAfter = steps.get(i);
                    stepConsumer.consume(beforeAfter);
                }
            }
        }

        public int getSizeOfFragmentToBeReplaced() {
            return this.myForward ? this.myIdx - this.myStartIdx : this.myStartIdx - this.myIdx;
        }
    }

    private static class Point {
        private final int myDistance;
        private final int myContextDistance;
        private final int myCommon;
        private final boolean myUsesAlreadyApplied;
        private final TextRange myInOldDocument;

        private Point(int distance2, TextRange inOldDocument, boolean usesAlreadyApplied, int contextDistance, int common) {
            this.myDistance = distance2;
            this.myInOldDocument = inOldDocument;
            this.myUsesAlreadyApplied = usesAlreadyApplied;
            this.myContextDistance = contextDistance;
            this.myCommon = common;
        }

        public boolean meBetter(Point maxPoint) {
            if (this.myCommon <= 1 && maxPoint.myCommon > 1) {
                return false;
            }
            if (maxPoint.myCommon <= 1 && this.myCommon > 1) {
                return true;
            }
            return this.myDistance < maxPoint.getDistance() || this.myDistance == 0 && maxPoint.getDistance() == 0 && this.myContextDistance < maxPoint.myContextDistance;
        }

        public int getDistance() {
            return this.myDistance;
        }

        public boolean idealFound() {
            return this.myDistance == 0 && this.myContextDistance == 0;
        }

        public TextRange getInOldDocument() {
            return this.myInOldDocument;
        }
    }

    private static class BetterPoint {
        private Point myPoint;

        private BetterPoint() {
        }

        public void feed(@NotNull Point point) {
            if (this.myPoint == null || point.meBetter(this.myPoint)) {
                this.myPoint = point;
            }
        }

        public Point getPoint() {
            return this.myPoint;
        }
    }

    private static class FragmentResult {
        private int myStart;
        private int myEnd;
        private boolean myContainAlreadyApplied;
        private int myDistance;
        private boolean myStartAtEdge;
        private boolean myEndAtEdge;

        private FragmentResult(int start2, int end, boolean containAlreadyApplied) {
            this.myStart = start2;
            this.myEnd = end;
            this.myContainAlreadyApplied = containAlreadyApplied;
            this.myDistance = 0;
        }

        public boolean isStartAtEdge() {
            return this.myStartAtEdge;
        }

        public void setStartAtEdge(boolean startAtEdge) {
            this.myStartAtEdge = startAtEdge;
        }

        public boolean isEndAtEdge() {
            return this.myEndAtEdge;
        }

        public void setEndAtEdge(boolean endAtEdge) {
            this.myEndAtEdge = endAtEdge;
        }

        public void addDistance(int distance2) {
            this.myDistance += distance2;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public boolean isContainAlreadyApplied() {
            return this.myContainAlreadyApplied;
        }

        public void setStart(int start2) {
            this.myStart = start2;
        }

        public void setEnd(int end) {
            this.myEnd = end;
        }

        public void setContainAlreadyApplied(boolean containAlreadyApplied) {
            this.myContainAlreadyApplied = containAlreadyApplied;
        }
    }

    public static class AppliedSomehowPatch
    extends AppliedPatch {
        public final boolean isAppliedSomehow;

        public AppliedSomehowPatch(@NotNull String text, @NotNull ApplyPatchStatus status, boolean isAppliedSomehow) {
            super(text, status);
            this.isAppliedSomehow = isAppliedSomehow;
        }
    }

    public static class AppliedPatch {
        @NotNull
        public final String patchedText;
        @NotNull
        public final ApplyPatchStatus status;

        public AppliedPatch(@NotNull String patchedText, @NotNull ApplyPatchStatus status) {
            this.patchedText = patchedText;
            this.status = status;
        }
    }
}

