/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainSimplePatchApplier {
    private static final Logger LOG = Logger.getInstance(PlainSimplePatchApplier.class);
    @NotNull
    private final List<? extends PatchHunk> myHunks;
    @NotNull
    private final CharSequence myText;
    @NotNull
    private final LineOffsets myLineOffsets;
    private final StringBuilder sb = new StringBuilder();
    private int baseLine = 0;
    private int patchedLine = 0;

    @Nullable
    public static String apply(@NotNull CharSequence text, @NotNull List<? extends PatchHunk> hunks) {
        return new PlainSimplePatchApplier(text, hunks).execute();
    }

    private PlainSimplePatchApplier(@NotNull CharSequence text, @NotNull List<? extends PatchHunk> hunks) {
        this.myText = text;
        this.myHunks = hunks;
        this.myLineOffsets = LineOffsetsUtil.create(text);
    }

    @Nullable
    private String execute() {
        if (this.myHunks.isEmpty()) {
            return this.myText.toString();
        }
        try {
            for (PatchHunk patchHunk : this.myHunks) {
                this.appendUnchangedLines(patchHunk.getStartLineBefore());
                this.checkContextLines(patchHunk);
                this.applyChangedLines(patchHunk);
            }
            if (!this.handleLastLine()) {
                this.appendUnchangedLines(this.myLineOffsets.getLineCount());
            }
            return this.sb.toString();
        }
        catch (PatchApplyException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private boolean handleLastLine() {
        List lastHunkLines = ((PatchHunk)ObjectUtils.notNull((Object)ContainerUtil.getLastItem(this.myHunks))).getLines();
        PatchLine lastBaseLine = (PatchLine)ContainerUtil.findLast((List)lastHunkLines, line -> line.getType() != PatchLine.Type.ADD);
        PatchLine lastPatchedLine = (PatchLine)ContainerUtil.findLast((List)lastHunkLines, line -> line.getType() != PatchLine.Type.REMOVE);
        if (lastBaseLine != null) {
            boolean lastLineAlreadyApplied;
            boolean bl = lastLineAlreadyApplied = !lastBaseLine.isSuppressNewLine() && this.baseLine + 1 == this.myLineOffsets.getLineCount() && this.getLineContent(this.baseLine).length() == 0 || lastBaseLine.isSuppressNewLine() && this.baseLine == this.myLineOffsets.getLineCount();
            if (lastLineAlreadyApplied) {
                boolean isNoNewlinePatched;
                boolean bl2 = isNoNewlinePatched = lastPatchedLine != null ? lastPatchedLine.isSuppressNewLine() : lastBaseLine.isSuppressNewLine();
                if (!isNoNewlinePatched && this.patchedLine > 0) {
                    this.sb.append('\n');
                }
                return true;
            }
            return false;
        }
        if (this.baseLine == 0 && this.myText.length() == 0) {
            boolean isNoNewlinePatched;
            boolean bl = isNoNewlinePatched = lastPatchedLine != null && lastPatchedLine.isSuppressNewLine();
            if (!isNoNewlinePatched && this.patchedLine > 0) {
                this.sb.append('\n');
            }
            return true;
        }
        return false;
    }

    private void checkContextLines(@NotNull PatchHunk hunk) {
        int baseStart = hunk.getStartLineBefore();
        int baseEnd = hunk.getEndLineBefore();
        int patchedStart = hunk.getStartLineAfter();
        int patchedEnd = hunk.getEndLineAfter();
        if (this.baseLine != baseStart) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk base start: expected  - %s, actual - %s", this.baseLine, baseStart));
        }
        if (this.patchedLine != patchedStart) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk patched start: expected  - %s, actual - %s", this.patchedLine, patchedStart));
        }
        if (baseEnd > this.myLineOffsets.getLineCount()) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk base end: total lines  - %s, hunk end - %s", this.myLineOffsets.getLineCount(), baseEnd));
        }
        int baseCount = ContainerUtil.count((Iterable)hunk.getLines(), patchLine -> patchLine.getType() != PatchLine.Type.ADD);
        int patchedCount = ContainerUtil.count((Iterable)hunk.getLines(), patchLine -> patchLine.getType() != PatchLine.Type.REMOVE);
        if (baseCount != baseEnd - baseStart) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk base body: expected - %s, actual - %s", baseEnd - baseStart, baseCount));
        }
        if (patchedCount != patchedEnd - patchedStart) {
            PlainSimplePatchApplier.error(String.format("Unexpected hunk patched body: expected - %s, actual - %s", patchedEnd - patchedStart, patchedCount));
        }
        int count = 0;
        for (PatchLine patchLine2 : hunk.getLines()) {
            String actualContent;
            if (patchLine2.getType() == PatchLine.Type.ADD) continue;
            CharSequence expectedContent = this.getLineContent(baseStart + count);
            if (!StringUtil.equals((CharSequence)expectedContent, (CharSequence)(actualContent = patchLine2.getText()))) {
                PlainSimplePatchApplier.error(String.format("Unexpected hunk content: expected - '%s', actual - '%s'", expectedContent, patchLine2));
            }
            ++count;
        }
    }

    private void applyChangedLines(@NotNull PatchHunk hunk) {
        for (PatchLine patchLine : hunk.getLines()) {
            if (patchLine.getType() == PatchLine.Type.REMOVE) continue;
            this.appendLine(patchLine.getText());
        }
        this.baseLine = hunk.getEndLineBefore();
    }

    private void appendUnchangedLines(int untilLine) {
        if (this.baseLine > untilLine) {
            PlainSimplePatchApplier.error(String.format("Unexpected base line: expected - %s, actual - %s", this.baseLine, untilLine));
        }
        if (untilLine > this.myLineOffsets.getLineCount()) {
            PlainSimplePatchApplier.error(String.format("Unexpected base line: total lines - %s, actual - %s", this.myLineOffsets.getLineCount(), untilLine));
        }
        for (int i = this.baseLine; i < untilLine; ++i) {
            this.appendLine(this.getLineContent(i));
        }
        this.baseLine = untilLine;
    }

    private void appendLine(CharSequence lineContent) {
        if (this.patchedLine > 0) {
            this.sb.append('\n');
        }
        this.sb.append(lineContent);
        ++this.patchedLine;
    }

    @NotNull
    private CharSequence getLineContent(int line) {
        return this.myText.subSequence(this.myLineOffsets.getLineStart(line), this.myLineOffsets.getLineEnd(line));
    }

    private static void error(@NotNull String error) {
        throw new PatchApplyException(error);
    }

    private static class PatchApplyException
    extends RuntimeException {
        PatchApplyException(String message) {
            super(message);
        }
    }
}

