/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PathsVerifier;
import com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion;
import com.intellij.openapi.diff.impl.patch.formove.UndoApplyPatchDialog;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchApplier<Unused> {
    private static final Logger LOG = Logger.getInstance(PatchApplier.class);
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    @NotNull
    private final List<? extends FilePatch> myPatches;
    private final CommitContext myCommitContext;
    @Nullable
    private final LocalChangeList myTargetChangeList;
    @NotNull
    private final List<FilePatch> myRemainingPatches;
    @NotNull
    private final List<FilePatch> myFailedPatches;
    private final PathsVerifier myVerifier;
    private final boolean myReverseConflict;
    @Nullable
    private final String myLeftConflictPanelTitle;
    @Nullable
    private final String myRightConflictPanelTitle;

    public PatchApplier(@NotNull Project project, @NotNull VirtualFile baseDirectory, @NotNull List<? extends FilePatch> patches2, @Nullable LocalChangeList targetChangeList, @Nullable CommitContext commitContext, boolean reverseConflict, @Nullable String leftConflictPanelTitle, @Nullable String rightConflictPanelTitle) {
        this.myProject = project;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches2;
        this.myTargetChangeList = targetChangeList;
        this.myCommitContext = commitContext;
        this.myReverseConflict = reverseConflict;
        this.myLeftConflictPanelTitle = leftConflictPanelTitle;
        this.myRightConflictPanelTitle = rightConflictPanelTitle;
        this.myRemainingPatches = new ArrayList<FilePatch>();
        this.myFailedPatches = new ArrayList<FilePatch>();
        this.myVerifier = new PathsVerifier(this.myProject, this.myBaseDirectory, this.myPatches);
    }

    public void setIgnoreContentRootsCheck() {
        this.myVerifier.setIgnoreContentRootsCheck(true);
    }

    public PatchApplier(@NotNull Project project, @NotNull VirtualFile baseDirectory, @NotNull List<? extends FilePatch> patches2, @Nullable LocalChangeList targetChangeList, @Nullable CommitContext commitContext) {
        this(project, baseDirectory, patches2, targetChangeList, commitContext, false, null, null);
    }

    @Deprecated
    public PatchApplier(@NotNull Project project, @NotNull VirtualFile baseDirectory, @NotNull List<? extends FilePatch> patches2, @Nullable LocalChangeList targetChangeList, @Nullable CustomBinaryPatchApplier ignored, @Nullable CommitContext commitContext) {
        this(project, baseDirectory, patches2, targetChangeList, commitContext, false, null, null);
    }

    @NotNull
    public List<FilePatch> getRemainingPatches() {
        return this.myRemainingPatches;
    }

    @NotNull
    private Collection<FilePatch> getFailedPatches() {
        return this.myFailedPatches;
    }

    @NotNull
    private List<FilePatch> getBinaryPatches() {
        return ContainerUtil.mapNotNull(this.myVerifier.getBinaryPatches(), patchInfo -> patchInfo.getApplyPatch().getPatch());
    }

    public void execute() {
        this.execute(true, false);
    }

    public ApplyPatchStatus execute(boolean showSuccessNotification, boolean silentAddDelete) {
        return PatchApplier.executePatchGroup(Collections.singletonList(this), this.myTargetChangeList, showSuccessNotification, silentAddDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWithDefaultConfirmations(@NotNull Project project, boolean resetConfirmations, @NotNull Runnable task2) {
        if (!resetConfirmations) {
            task2.run();
        } else {
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            VcsShowConfirmationOption addConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
            VcsShowConfirmationOption deleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
            VcsShowConfirmationOption.Value addConfirmationValue = addConfirmation.getValue();
            VcsShowConfirmationOption.Value deleteConfirmationValue = deleteConfirmation.getValue();
            addConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            deleteConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            try {
                task2.run();
            }
            finally {
                addConfirmation.setValue(addConfirmationValue);
                deleteConfirmation.setValue(deleteConfirmationValue);
            }
        }
    }

    public static ApplyPatchStatus executePatchGroup(Collection<PatchApplier> group, @Nullable LocalChangeList localChangeList) {
        return PatchApplier.executePatchGroup(group, localChangeList, true, false);
    }

    public static ApplyPatchStatus executePatchGroup(Collection<PatchApplier> group, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean silentAddDelete) {
        if (group.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        Project project = group.iterator().next().myProject;
        return (ApplyPatchStatus)((Object)PartialChangesUtil.computeUnderChangeList(project, targetChangeList, "Applying patch...", () -> {
            ApplyPatchStatus result2 = ApplyPatchStatus.SUCCESS;
            for (PatchApplier patchApplier : group) {
                result2 = ApplyPatchStatus.and(result2, patchApplier.nonWriteActionPreCheck());
            }
            Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project, "Before patch");
            TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(project);
            Ref refStatus = new Ref((Object)result2);
            try {
                PatchApplier.runWithDefaultConfirmations(project, silentAddDelete, () -> CommandProcessor.getInstance().executeCommand(project, () -> {
                    for (PatchApplier applier : group) {
                        refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)((Object)((Object)((Object)refStatus.get())))), applier.createFiles()));
                        applier.addSkippedItems(trigger);
                    }
                    trigger.prepare();
                    if (refStatus.get() == ApplyPatchStatus.SUCCESS) {
                        refStatus.set(null);
                    }
                    for (PatchApplier applier : group) {
                        refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)((Object)((Object)((Object)refStatus.get())))), applier.executeWritable()));
                        if (refStatus.get() != ApplyPatchStatus.ABORT) continue;
                        break;
                    }
                }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null));
            }
            finally {
                VcsFileListenerContextHelper.getInstance((Project)project).clearContext();
                LocalHistory.getInstance().putSystemLabel(project, "After patch");
            }
            result2 = (ApplyPatchStatus)((Object)((Object)refStatus.get()));
            result2 = result2 == null ? ApplyPatchStatus.FAILURE : result2;
            trigger.processIt();
            if (result2 == ApplyPatchStatus.FAILURE) {
                PatchApplier.suggestRollback(project, group, beforeLabel);
            } else if (result2 == ApplyPatchStatus.ABORT) {
                PatchApplier.rollbackUnderProgress(project, beforeLabel);
            }
            if (showSuccessNotification || !ApplyPatchStatus.SUCCESS.equals((Object)result2)) {
                PatchApplier.showApplyStatus(project, result2);
            }
            HashSet<FilePath> directlyAffected = new HashSet<FilePath>();
            HashSet<VirtualFile> indirectlyAffected = new HashSet<VirtualFile>();
            for (PatchApplier applier : group) {
                directlyAffected.addAll(applier.getDirectlyAffected());
                indirectlyAffected.addAll(applier.getIndirectlyAffected());
            }
            directlyAffected.addAll(trigger.getAffected());
            PatchApplier.refreshPassedFiles(project, directlyAffected, indirectlyAffected);
            return result2;
        }, true));
    }

    private static void suggestRollback(@NotNull Project project, @NotNull Collection<PatchApplier> group, @NotNull Label beforeLabel) {
        List allFailed = ContainerUtil.concat(group, applier -> applier.getFailedPatches());
        boolean shouldInformAboutBinaries = ContainerUtil.exists(group, applier -> !applier.getBinaryPatches().isEmpty());
        List filePaths = ContainerUtil.map((Collection)allFailed, filePatch -> VcsUtil.getFilePath((String)((String)ObjectUtils.chooseNotNull((Object)filePatch.getAfterName(), (Object)filePatch.getBeforeName()))));
        UndoApplyPatchDialog undoApplyPatchDialog = new UndoApplyPatchDialog(project, filePaths, shouldInformAboutBinaries);
        if (undoApplyPatchDialog.showAndGet()) {
            PatchApplier.rollbackUnderProgress(project, beforeLabel);
        }
    }

    private static void rollbackUnderProgress(@NotNull Project project, @NotNull Label labelToRevert) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                labelToRevert.revert(project, project.getBaseDir());
                VcsNotifier.getInstance(project).notifyImportantWarning("Apply Patch Aborted", "All files changed during apply patch action were rolled back");
            }
            catch (LocalHistoryException e) {
                VcsNotifier.getInstance(project).notifyImportantWarning("Rollback Failed", "Try using 'Local History' dialog to perform revert manually.");
            }
        }, "Rollback Applied Changes...", true, project);
    }

    private void addSkippedItems(TriggerAdditionOrDeletion trigger) {
        trigger.addExisting(this.myVerifier.getToBeAdded());
        trigger.addDeleted(this.myVerifier.getToBeDeleted());
    }

    @NotNull
    private ApplyPatchStatus nonWriteActionPreCheck() {
        List<FilePatch> failedPreCheck = this.myVerifier.nonWriteActionPreCheck();
        List<FilePatch> skipped = this.myVerifier.getSkipped();
        this.myRemainingPatches.addAll(this.myPatches);
        this.myFailedPatches.addAll(failedPreCheck);
        this.myPatches.removeAll(failedPreCheck);
        this.myPatches.removeAll(skipped);
        if (!failedPreCheck.isEmpty()) {
            return ApplyPatchStatus.FAILURE;
        }
        if (skipped.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        if (skipped.size() == this.myPatches.size()) {
            return ApplyPatchStatus.ALREADY_APPLIED;
        }
        return ApplyPatchStatus.PARTIAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ApplyPatchStatus executeWritable() {
        ReadonlyStatusHandler.OperationStatus readOnlyFilesStatus = ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(this.myVerifier.getWritableFiles());
        if (readOnlyFilesStatus.hasReadonlyFiles()) {
            PatchApplier.showError(this.myProject, readOnlyFilesStatus.getReadonlyFilesMessage());
            return ApplyPatchStatus.ABORT;
        }
        this.myFailedPatches.addAll(this.myVerifier.filterBadFileTypePatches());
        ApplyPatchStatus result2 = this.myFailedPatches.isEmpty() ? null : ApplyPatchStatus.FAILURE;
        List<PathsVerifier.PatchAndFile> textPatches = this.myVerifier.getTextPatches();
        try {
            PatchApplier.markInternalOperation(textPatches, true);
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.and(result2, this.actualApply(textPatches, this.myVerifier.getBinaryPatches(), this.myCommitContext));
            return applyPatchStatus;
        }
        finally {
            PatchApplier.markInternalOperation(textPatches, false);
        }
    }

    @NotNull
    private ApplyPatchStatus createFiles() {
        Application application = ApplicationManager.getApplication();
        Boolean isSuccess = (Boolean)application.runWriteAction(() -> {
            List<FilePatch> filePatches = this.myVerifier.execute();
            this.myFailedPatches.addAll(filePatches);
            this.myPatches.removeAll(filePatches);
            return this.myFailedPatches.isEmpty();
        });
        return isSuccess != false ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE;
    }

    private static void markInternalOperation(List<? extends PathsVerifier.PatchAndFile> textPatches, boolean set2) {
        for (PathsVerifier.PatchAndFile patchAndFile : textPatches) {
            ChangesUtil.markInternalOperation((VirtualFile)patchAndFile.getFile(), (boolean)set2);
        }
    }

    private List<FilePath> getDirectlyAffected() {
        return this.myVerifier.getDirectlyAffected();
    }

    private List<VirtualFile> getIndirectlyAffected() {
        return this.myVerifier.getAllAffected();
    }

    private static void refreshPassedFiles(@NotNull Project project, @NotNull Collection<? extends FilePath> directlyAffected, @NotNull Collection<? extends VirtualFile> indirectlyAffected) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (FilePath filePath : directlyAffected) {
            lfs.refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        if (project.isDisposed()) {
            return;
        }
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        vcsDirtyScopeManager.filePathsDirty(directlyAffected, null);
        vcsDirtyScopeManager.filesDirty(indirectlyAffected, null);
    }

    @Nullable
    private ApplyPatchStatus actualApply(List<? extends PathsVerifier.PatchAndFile> textPatches, List<? extends PathsVerifier.PatchAndFile> binaryPatches, CommitContext commitContext) {
        ApplyPatchStatus status;
        ApplyPatchContext context = new ApplyPatchContext(this.myBaseDirectory, 0, true, true);
        try {
            status = this.applyList(textPatches, context, null, commitContext);
            if (status == ApplyPatchStatus.ABORT) {
                return status;
            }
            status = this.applyList(binaryPatches, context, status, commitContext);
        }
        catch (IOException e) {
            PatchApplier.showError(this.myProject, e.getMessage());
            return ApplyPatchStatus.ABORT;
        }
        return status;
    }

    private ApplyPatchStatus applyList(List<? extends PathsVerifier.PatchAndFile> patches2, ApplyPatchContext context, ApplyPatchStatus status, CommitContext commiContext) throws IOException {
        for (PathsVerifier.PatchAndFile patchAndFile : patches2) {
            ApplyFilePatchBase<?> applyFilePatch = patchAndFile.getApplyPatch();
            ApplyPatchStatus patchStatus = ApplyPatchAction.applyContent(this.myProject, applyFilePatch, context, patchAndFile.getFile(), commiContext, this.myReverseConflict, this.myLeftConflictPanelTitle, this.myRightConflictPanelTitle);
            if (patchStatus == ApplyPatchStatus.SUCCESS || patchStatus == ApplyPatchStatus.ALREADY_APPLIED) {
                PatchApplier.applyAdditionalPatchData(patchAndFile.getFile(), applyFilePatch.getPatch());
            }
            if (patchStatus == ApplyPatchStatus.ABORT) {
                return patchStatus;
            }
            status = ApplyPatchStatus.and(status, patchStatus);
            if (patchStatus == ApplyPatchStatus.FAILURE) {
                this.myFailedPatches.add((FilePatch)applyFilePatch.getPatch());
                continue;
            }
            if (patchStatus == ApplyPatchStatus.SKIP) continue;
            this.myVerifier.doMoveIfNeeded(patchAndFile.getFile());
            this.myRemainingPatches.remove(applyFilePatch.getPatch());
        }
        return status;
    }

    private static <V extends FilePatch> void applyAdditionalPatchData(@NotNull VirtualFile fileToApplyData, @NotNull V filePatch) {
        int newFileMode = filePatch.getNewFileMode();
        File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)fileToApplyData);
        if (newFileMode == 100755 || newFileMode == 100644) {
            try {
                file2.setExecutable(newFileMode == 100755);
            }
            catch (Exception e) {
                LOG.warn("Can't change file mode for " + fileToApplyData.getPresentableName());
            }
        }
    }

    private static void showApplyStatus(@NotNull Project project, ApplyPatchStatus status) {
        VcsNotifier vcsNotifier = VcsNotifier.getInstance(project);
        if (status == ApplyPatchStatus.ALREADY_APPLIED) {
            vcsNotifier.notifyMinorInfo(VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.already.applied", (Object[])new Object[0]));
        } else if (status == ApplyPatchStatus.PARTIAL) {
            vcsNotifier.notifyMinorInfo(VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.partially.applied", (Object[])new Object[0]));
        } else if (status == ApplyPatchStatus.SUCCESS) {
            vcsNotifier.notifySuccess(VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]));
        }
    }

    public static void showError(Project project, String message) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VcsImplUtil.showErrorMessage(project, message, VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]));
    }
}

